/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.datapipeline.DataPipelineAsyncClient;
import software.amazon.awssdk.services.datapipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;

public class QueryObjectsPublisher
implements SdkPublisher<QueryObjectsResponse> {
    private final DataPipelineAsyncClient client;
    private final QueryObjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryObjectsPublisher(DataPipelineAsyncClient client, QueryObjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryObjectsPublisher(DataPipelineAsyncClient client, QueryObjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryObjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryObjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ids() {
        Function<QueryObjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new QueryObjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class QueryObjectsResponseFetcher
    implements AsyncPageFetcher<QueryObjectsResponse> {
        private QueryObjectsResponseFetcher() {
        }

        public boolean hasNextPage(QueryObjectsResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public CompletableFuture<QueryObjectsResponse> nextPage(QueryObjectsResponse previousPage) {
            if (previousPage == null) {
                return QueryObjectsPublisher.this.client.queryObjects(QueryObjectsPublisher.this.firstRequest);
            }
            return QueryObjectsPublisher.this.client.queryObjects((QueryObjectsRequest)((Object)QueryObjectsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

