/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.AddTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.AddTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatResponse;
import software.amazon.awssdk.services.datapipeline.model.SetStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsPublisher;
import software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher;
import software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsPublisher;

/**
 * Service client for accessing AWS Data Pipeline asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS Data Pipeline configures and manages a data-driven workflow called a pipeline. AWS Data Pipeline handles the
 * details of scheduling and ensuring that data dependencies are met so that your application can focus on processing
 * the data.
 * </p>
 * <p>
 * AWS Data Pipeline provides a JAR implementation of a task runner called AWS Data Pipeline Task Runner. AWS Data
 * Pipeline Task Runner provides logic for common data management scenarios, such as performing database queries and
 * running data analysis using Amazon Elastic MapReduce (Amazon EMR). You can use AWS Data Pipeline Task Runner as your
 * task runner, or you can write your own task runner to provide custom data management.
 * </p>
 * <p>
 * AWS Data Pipeline implements two main sets of functionality. Use the first set to create a pipeline and define data
 * sources, schedules, dependencies, and the transforms to be performed on the data. Use the second set in your task
 * runner application to receive the next task ready for processing. The logic for performing the task, such as querying
 * the data, running data analysis, or converting the data from one format to another, is contained within the task
 * runner. The task runner performs the task assigned to it by the web service, reporting progress to the web service as
 * it does so. When the task is done, the task runner reports the final success or failure of the task to the web
 * service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataPipelineAsyncClient extends AwsClient {
    String SERVICE_NAME = "datapipeline";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "datapipeline";

    /**
     * <p>
     * Validates the specified pipeline and starts processing pipeline tasks. If the pipeline does not pass validation,
     * activation fails.
     * </p>
     * <p>
     * If you need to pause the pipeline to investigate an issue with a component, such as a data source or script, call
     * <a>DeactivatePipeline</a>.
     * </p>
     * <p>
     * To activate a finished pipeline, modify the end date for the pipeline and then activate it.
     * </p>
     *
     * @param activatePipelineRequest
     *        Contains the parameters for ActivatePipeline.
     * @return A Java Future containing the result of the ActivatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ActivatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ActivatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ActivatePipelineResponse> activatePipeline(ActivatePipelineRequest activatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the specified pipeline and starts processing pipeline tasks. If the pipeline does not pass validation,
     * activation fails.
     * </p>
     * <p>
     * If you need to pause the pipeline to investigate an issue with a component, such as a data source or script, call
     * <a>DeactivatePipeline</a>.
     * </p>
     * <p>
     * To activate a finished pipeline, modify the end date for the pipeline and then activate it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivatePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link ActivatePipelineRequest#builder()}
     * </p>
     *
     * @param activatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest.Builder} to create a
     *        request. Contains the parameters for ActivatePipeline.
     * @return A Java Future containing the result of the ActivatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ActivatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ActivatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ActivatePipelineResponse> activatePipeline(
            Consumer<ActivatePipelineRequest.Builder> activatePipelineRequest) {
        return activatePipeline(ActivatePipelineRequest.builder().applyMutation(activatePipelineRequest).build());
    }

    /**
     * <p>
     * Adds or modifies tags for the specified pipeline.
     * </p>
     *
     * @param addTagsRequest
     *        Contains the parameters for AddTags.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or modifies tags for the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.AddTagsRequest.Builder} to create a request.
     *        Contains the parameters for AddTags.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Creates a new, empty pipeline. Use <a>PutPipelineDefinition</a> to populate the pipeline.
     * </p>
     *
     * @param createPipelineRequest
     *        Contains the parameters for CreatePipeline.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/CreatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, empty pipeline. Use <a>PutPipelineDefinition</a> to populate the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest.Builder} to create a
     *        request. Contains the parameters for CreatePipeline.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/CreatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * Deactivates the specified running pipeline. The pipeline is set to the <code>DEACTIVATING</code> state until the
     * deactivation process completes.
     * </p>
     * <p>
     * To resume a deactivated pipeline, use <a>ActivatePipeline</a>. By default, the pipeline resumes from the last
     * completed execution. Optionally, you can specify the date and time to resume the pipeline.
     * </p>
     *
     * @param deactivatePipelineRequest
     *        Contains the parameters for DeactivatePipeline.
     * @return A Java Future containing the result of the DeactivatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DeactivatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DeactivatePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivatePipelineResponse> deactivatePipeline(DeactivatePipelineRequest deactivatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified running pipeline. The pipeline is set to the <code>DEACTIVATING</code> state until the
     * deactivation process completes.
     * </p>
     * <p>
     * To resume a deactivated pipeline, use <a>ActivatePipeline</a>. By default, the pipeline resumes from the last
     * completed execution. Optionally, you can specify the date and time to resume the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivatePipelineRequest.Builder} avoiding the
     * need to create one manually via {@link DeactivatePipelineRequest#builder()}
     * </p>
     *
     * @param deactivatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest.Builder} to create a
     *        request. Contains the parameters for DeactivatePipeline.
     * @return A Java Future containing the result of the DeactivatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DeactivatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DeactivatePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivatePipelineResponse> deactivatePipeline(
            Consumer<DeactivatePipelineRequest.Builder> deactivatePipelineRequest) {
        return deactivatePipeline(DeactivatePipelineRequest.builder().applyMutation(deactivatePipelineRequest).build());
    }

    /**
     * <p>
     * Deletes a pipeline, its pipeline definition, and its run history. AWS Data Pipeline attempts to cancel instances
     * associated with the pipeline that are currently being processed by task runners.
     * </p>
     * <p>
     * Deleting a pipeline cannot be undone. You cannot query or restore a deleted pipeline. To temporarily pause a
     * pipeline instead of deleting it, call <a>SetStatus</a> with the status set to <code>PAUSE</code> on individual
     * components. Components that are paused by <a>SetStatus</a> can be resumed.
     * </p>
     *
     * @param deletePipelineRequest
     *        Contains the parameters for DeletePipeline.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DeletePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pipeline, its pipeline definition, and its run history. AWS Data Pipeline attempts to cancel instances
     * associated with the pipeline that are currently being processed by task runners.
     * </p>
     * <p>
     * Deleting a pipeline cannot be undone. You cannot query or restore a deleted pipeline. To temporarily pause a
     * pipeline instead of deleting it, call <a>SetStatus</a> with the status set to <code>PAUSE</code> on individual
     * components. Components that are paused by <a>SetStatus</a> can be resumed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest.Builder} to create a
     *        request. Contains the parameters for DeletePipeline.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DeletePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * Gets the object definitions for a set of objects associated with the pipeline. Object definitions are composed of
     * a set of fields that define the properties of the object.
     * </p>
     *
     * @param describeObjectsRequest
     *        Contains the parameters for DescribeObjects.
     * @return A Java Future containing the result of the DescribeObjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DescribeObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribeObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeObjectsResponse> describeObjects(DescribeObjectsRequest describeObjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the object definitions for a set of objects associated with the pipeline. Object definitions are composed of
     * a set of fields that define the properties of the object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeObjectsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeObjectsRequest#builder()}
     * </p>
     *
     * @param describeObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest.Builder} to create a
     *        request. Contains the parameters for DescribeObjects.
     * @return A Java Future containing the result of the DescribeObjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DescribeObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribeObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeObjectsResponse> describeObjects(
            Consumer<DescribeObjectsRequest.Builder> describeObjectsRequest) {
        return describeObjects(DescribeObjectsRequest.builder().applyMutation(describeObjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeObjects(software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsPublisher publisher = client.describeObjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsPublisher publisher = client.describeObjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeObjects(software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeObjectsRequest
     *        Contains the parameters for DescribeObjects.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DescribeObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribeObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeObjectsPublisher describeObjectsPaginator(DescribeObjectsRequest describeObjectsRequest) {
        return new DescribeObjectsPublisher(this, describeObjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeObjects(software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsPublisher publisher = client.describeObjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsPublisher publisher = client.describeObjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeObjects(software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeObjectsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeObjectsRequest#builder()}
     * </p>
     *
     * @param describeObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest.Builder} to create a
     *        request. Contains the parameters for DescribeObjects.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DescribeObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribeObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeObjectsPublisher describeObjectsPaginator(Consumer<DescribeObjectsRequest.Builder> describeObjectsRequest) {
        return describeObjectsPaginator(DescribeObjectsRequest.builder().applyMutation(describeObjectsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata about one or more pipelines. The information retrieved includes the name of the pipeline, the
     * pipeline identifier, its current state, and the user account that owns the pipeline. Using account credentials,
     * you can retrieve metadata about pipelines that you or your IAM users have created. If you are using an IAM user
     * account, you can retrieve metadata about only those pipelines for which you have read permissions.
     * </p>
     * <p>
     * To retrieve the full pipeline definition instead of metadata about the pipeline, call
     * <a>GetPipelineDefinition</a>.
     * </p>
     *
     * @param describePipelinesRequest
     *        Contains the parameters for DescribePipelines.
     * @return A Java Future containing the result of the DescribePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DescribePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePipelinesResponse> describePipelines(DescribePipelinesRequest describePipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata about one or more pipelines. The information retrieved includes the name of the pipeline, the
     * pipeline identifier, its current state, and the user account that owns the pipeline. Using account credentials,
     * you can retrieve metadata about pipelines that you or your IAM users have created. If you are using an IAM user
     * account, you can retrieve metadata about only those pipelines for which you have read permissions.
     * </p>
     * <p>
     * To retrieve the full pipeline definition instead of metadata about the pipeline, call
     * <a>GetPipelineDefinition</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePipelinesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePipelinesRequest#builder()}
     * </p>
     *
     * @param describePipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest.Builder} to create a
     *        request. Contains the parameters for DescribePipelines.
     * @return A Java Future containing the result of the DescribePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.DescribePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePipelinesResponse> describePipelines(
            Consumer<DescribePipelinesRequest.Builder> describePipelinesRequest) {
        return describePipelines(DescribePipelinesRequest.builder().applyMutation(describePipelinesRequest).build());
    }

    /**
     * <p>
     * Task runners call <code>EvaluateExpression</code> to evaluate a string in the context of the specified object.
     * For example, a task runner can evaluate SQL queries stored in Amazon S3.
     * </p>
     *
     * @param evaluateExpressionRequest
     *        Contains the parameters for EvaluateExpression.
     * @return A Java Future containing the result of the EvaluateExpression operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.EvaluateExpression
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/EvaluateExpression"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EvaluateExpressionResponse> evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Task runners call <code>EvaluateExpression</code> to evaluate a string in the context of the specified object.
     * For example, a task runner can evaluate SQL queries stored in Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateExpressionRequest.Builder} avoiding the
     * need to create one manually via {@link EvaluateExpressionRequest#builder()}
     * </p>
     *
     * @param evaluateExpressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest.Builder} to create a
     *        request. Contains the parameters for EvaluateExpression.
     * @return A Java Future containing the result of the EvaluateExpression operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.EvaluateExpression
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/EvaluateExpression"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EvaluateExpressionResponse> evaluateExpression(
            Consumer<EvaluateExpressionRequest.Builder> evaluateExpressionRequest) {
        return evaluateExpression(EvaluateExpressionRequest.builder().applyMutation(evaluateExpressionRequest).build());
    }

    /**
     * <p>
     * Gets the definition of the specified pipeline. You can call <code>GetPipelineDefinition</code> to retrieve the
     * pipeline definition that you provided using <a>PutPipelineDefinition</a>.
     * </p>
     *
     * @param getPipelineDefinitionRequest
     *        Contains the parameters for GetPipelineDefinition.
     * @return A Java Future containing the result of the GetPipelineDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.GetPipelineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/GetPipelineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPipelineDefinitionResponse> getPipelineDefinition(
            GetPipelineDefinitionRequest getPipelineDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the definition of the specified pipeline. You can call <code>GetPipelineDefinition</code> to retrieve the
     * pipeline definition that you provided using <a>PutPipelineDefinition</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetPipelineDefinitionRequest#builder()}
     * </p>
     *
     * @param getPipelineDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest.Builder} to create
     *        a request. Contains the parameters for GetPipelineDefinition.
     * @return A Java Future containing the result of the GetPipelineDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.GetPipelineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/GetPipelineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPipelineDefinitionResponse> getPipelineDefinition(
            Consumer<GetPipelineDefinitionRequest.Builder> getPipelineDefinitionRequest) {
        return getPipelineDefinition(GetPipelineDefinitionRequest.builder().applyMutation(getPipelineDefinitionRequest).build());
    }

    /**
     * <p>
     * Lists the pipeline identifiers for all active pipelines that you have permission to access.
     * </p>
     *
     * @param listPipelinesRequest
     *        Contains the parameters for ListPipelines.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the pipeline identifiers for all active pipelines that you have permission to access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest.Builder} to create a
     *        request. Contains the parameters for ListPipelines.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelines(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Lists the pipeline identifiers for all active pipelines that you have permission to access.
     * </p>
     *
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines() {
        return listPipelines(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator() {
        return listPipelinesPaginator(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @param listPipelinesRequest
     *        Contains the parameters for ListPipelines.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) {
        return new ListPipelinesPublisher(this, listPipelinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest.Builder} to create a
     *        request. Contains the parameters for ListPipelines.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelinesPaginator(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Task runners call <code>PollForTask</code> to receive a task to perform from AWS Data Pipeline. The task runner
     * specifies which tasks it can perform by setting a value for the <code>workerGroup</code> parameter. The task
     * returned can come from any of the pipelines that match the <code>workerGroup</code> value passed in by the task
     * runner and that was launched using the IAM user credentials specified by the task runner.
     * </p>
     * <p>
     * If tasks are ready in the work queue, <code>PollForTask</code> returns a response immediately. If no tasks are
     * available in the queue, <code>PollForTask</code> uses long-polling and holds on to a poll connection for up to a
     * 90 seconds, during which time the first newly scheduled task is handed to the task runner. To accomodate this,
     * set the socket timeout in your task runner to 90 seconds. The task runner should not call
     * <code>PollForTask</code> again on the same <code>workerGroup</code> until it receives a response, and this can
     * take up to 90 seconds.
     * </p>
     *
     * @param pollForTaskRequest
     *        Contains the parameters for PollForTask.
     * @return A Java Future containing the result of the PollForTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.PollForTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PollForTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PollForTaskResponse> pollForTask(PollForTaskRequest pollForTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Task runners call <code>PollForTask</code> to receive a task to perform from AWS Data Pipeline. The task runner
     * specifies which tasks it can perform by setting a value for the <code>workerGroup</code> parameter. The task
     * returned can come from any of the pipelines that match the <code>workerGroup</code> value passed in by the task
     * runner and that was launched using the IAM user credentials specified by the task runner.
     * </p>
     * <p>
     * If tasks are ready in the work queue, <code>PollForTask</code> returns a response immediately. If no tasks are
     * available in the queue, <code>PollForTask</code> uses long-polling and holds on to a poll connection for up to a
     * 90 seconds, during which time the first newly scheduled task is handed to the task runner. To accomodate this,
     * set the socket timeout in your task runner to 90 seconds. The task runner should not call
     * <code>PollForTask</code> again on the same <code>workerGroup</code> until it receives a response, and this can
     * take up to 90 seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PollForTaskRequest.Builder} avoiding the need to
     * create one manually via {@link PollForTaskRequest#builder()}
     * </p>
     *
     * @param pollForTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest.Builder} to create a request.
     *        Contains the parameters for PollForTask.
     * @return A Java Future containing the result of the PollForTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.PollForTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PollForTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PollForTaskResponse> pollForTask(Consumer<PollForTaskRequest.Builder> pollForTaskRequest) {
        return pollForTask(PollForTaskRequest.builder().applyMutation(pollForTaskRequest).build());
    }

    /**
     * <p>
     * Adds tasks, schedules, and preconditions to the specified pipeline. You can use
     * <code>PutPipelineDefinition</code> to populate a new pipeline.
     * </p>
     * <p>
     * <code>PutPipelineDefinition</code> also validates the configuration as it adds it to the pipeline. Changes to the
     * pipeline are saved unless one of the following three validation errors exists in the pipeline.
     * </p>
     * <ol>
     * <li>An object is missing a name or identifier field.</li>
     * <li>A string or reference field is empty.</li>
     * <li>The number of objects in the pipeline exceeds the maximum allowed objects.</li>
     * <li>The pipeline is in a FINISHED state.</li>
     * </ol>
     * <p>
     * Pipeline object definitions are passed to the <code>PutPipelineDefinition</code> action and returned by the
     * <a>GetPipelineDefinition</a> action.
     * </p>
     *
     * @param putPipelineDefinitionRequest
     *        Contains the parameters for PutPipelineDefinition.
     * @return A Java Future containing the result of the PutPipelineDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.PutPipelineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PutPipelineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPipelineDefinitionResponse> putPipelineDefinition(
            PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tasks, schedules, and preconditions to the specified pipeline. You can use
     * <code>PutPipelineDefinition</code> to populate a new pipeline.
     * </p>
     * <p>
     * <code>PutPipelineDefinition</code> also validates the configuration as it adds it to the pipeline. Changes to the
     * pipeline are saved unless one of the following three validation errors exists in the pipeline.
     * </p>
     * <ol>
     * <li>An object is missing a name or identifier field.</li>
     * <li>A string or reference field is empty.</li>
     * <li>The number of objects in the pipeline exceeds the maximum allowed objects.</li>
     * <li>The pipeline is in a FINISHED state.</li>
     * </ol>
     * <p>
     * Pipeline object definitions are passed to the <code>PutPipelineDefinition</code> action and returned by the
     * <a>GetPipelineDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPipelineDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link PutPipelineDefinitionRequest#builder()}
     * </p>
     *
     * @param putPipelineDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionRequest.Builder} to create
     *        a request. Contains the parameters for PutPipelineDefinition.
     * @return A Java Future containing the result of the PutPipelineDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.PutPipelineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PutPipelineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPipelineDefinitionResponse> putPipelineDefinition(
            Consumer<PutPipelineDefinitionRequest.Builder> putPipelineDefinitionRequest) {
        return putPipelineDefinition(PutPipelineDefinitionRequest.builder().applyMutation(putPipelineDefinitionRequest).build());
    }

    /**
     * <p>
     * Queries the specified pipeline for the names of objects that match the specified set of conditions.
     * </p>
     *
     * @param queryObjectsRequest
     *        Contains the parameters for QueryObjects.
     * @return A Java Future containing the result of the QueryObjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.QueryObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/QueryObjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryObjectsResponse> queryObjects(QueryObjectsRequest queryObjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries the specified pipeline for the names of objects that match the specified set of conditions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryObjectsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryObjectsRequest#builder()}
     * </p>
     *
     * @param queryObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest.Builder} to create a
     *        request. Contains the parameters for QueryObjects.
     * @return A Java Future containing the result of the QueryObjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.QueryObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/QueryObjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryObjectsResponse> queryObjects(Consumer<QueryObjectsRequest.Builder> queryObjectsRequest) {
        return queryObjects(QueryObjectsRequest.builder().applyMutation(queryObjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #queryObjects(software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsPublisher publisher = client.queryObjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsPublisher publisher = client.queryObjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryObjects(software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest)} operation.</b>
     * </p>
     *
     * @param queryObjectsRequest
     *        Contains the parameters for QueryObjects.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.QueryObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/QueryObjects" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryObjectsPublisher queryObjectsPaginator(QueryObjectsRequest queryObjectsRequest) {
        return new QueryObjectsPublisher(this, queryObjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #queryObjects(software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsPublisher publisher = client.queryObjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsPublisher publisher = client.queryObjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryObjects(software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryObjectsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryObjectsRequest#builder()}
     * </p>
     *
     * @param queryObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest.Builder} to create a
     *        request. Contains the parameters for QueryObjects.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.QueryObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/QueryObjects" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryObjectsPublisher queryObjectsPaginator(Consumer<QueryObjectsRequest.Builder> queryObjectsRequest) {
        return queryObjectsPaginator(QueryObjectsRequest.builder().applyMutation(queryObjectsRequest).build());
    }

    /**
     * <p>
     * Removes existing tags from the specified pipeline.
     * </p>
     *
     * @param removeTagsRequest
     *        Contains the parameters for RemoveTags.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes existing tags from the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest.Builder} to create a request.
     *        Contains the parameters for RemoveTags.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Task runners call <code>ReportTaskProgress</code> when assigned a task to acknowledge that it has the task. If
     * the web service does not receive this acknowledgement within 2 minutes, it assigns the task in a subsequent
     * <a>PollForTask</a> call. After this initial acknowledgement, the task runner only needs to report progress every
     * 15 minutes to maintain its ownership of the task. You can change this reporting time from 15 minutes by
     * specifying a <code>reportProgressTimeout</code> field in your pipeline.
     * </p>
     * <p>
     * If a task runner does not report its status after 5 minutes, AWS Data Pipeline assumes that the task runner is
     * unable to process the task and reassigns the task in a subsequent response to <a>PollForTask</a>. Task runners
     * should call <code>ReportTaskProgress</code> every 60 seconds.
     * </p>
     *
     * @param reportTaskProgressRequest
     *        Contains the parameters for ReportTaskProgress.
     * @return A Java Future containing the result of the ReportTaskProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ReportTaskProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ReportTaskProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReportTaskProgressResponse> reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Task runners call <code>ReportTaskProgress</code> when assigned a task to acknowledge that it has the task. If
     * the web service does not receive this acknowledgement within 2 minutes, it assigns the task in a subsequent
     * <a>PollForTask</a> call. After this initial acknowledgement, the task runner only needs to report progress every
     * 15 minutes to maintain its ownership of the task. You can change this reporting time from 15 minutes by
     * specifying a <code>reportProgressTimeout</code> field in your pipeline.
     * </p>
     * <p>
     * If a task runner does not report its status after 5 minutes, AWS Data Pipeline assumes that the task runner is
     * unable to process the task and reassigns the task in a subsequent response to <a>PollForTask</a>. Task runners
     * should call <code>ReportTaskProgress</code> every 60 seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReportTaskProgressRequest.Builder} avoiding the
     * need to create one manually via {@link ReportTaskProgressRequest#builder()}
     * </p>
     *
     * @param reportTaskProgressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest.Builder} to create a
     *        request. Contains the parameters for ReportTaskProgress.
     * @return A Java Future containing the result of the ReportTaskProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ReportTaskProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ReportTaskProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReportTaskProgressResponse> reportTaskProgress(
            Consumer<ReportTaskProgressRequest.Builder> reportTaskProgressRequest) {
        return reportTaskProgress(ReportTaskProgressRequest.builder().applyMutation(reportTaskProgressRequest).build());
    }

    /**
     * <p>
     * Task runners call <code>ReportTaskRunnerHeartbeat</code> every 15 minutes to indicate that they are operational.
     * If the AWS Data Pipeline Task Runner is launched on a resource managed by AWS Data Pipeline, the web service can
     * use this call to detect when the task runner application has failed and restart a new instance.
     * </p>
     *
     * @param reportTaskRunnerHeartbeatRequest
     *        Contains the parameters for ReportTaskRunnerHeartbeat.
     * @return A Java Future containing the result of the ReportTaskRunnerHeartbeat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ReportTaskRunnerHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ReportTaskRunnerHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReportTaskRunnerHeartbeatResponse> reportTaskRunnerHeartbeat(
            ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Task runners call <code>ReportTaskRunnerHeartbeat</code> every 15 minutes to indicate that they are operational.
     * If the AWS Data Pipeline Task Runner is launched on a resource managed by AWS Data Pipeline, the web service can
     * use this call to detect when the task runner application has failed and restart a new instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReportTaskRunnerHeartbeatRequest.Builder} avoiding
     * the need to create one manually via {@link ReportTaskRunnerHeartbeatRequest#builder()}
     * </p>
     *
     * @param reportTaskRunnerHeartbeatRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest.Builder} to
     *        create a request. Contains the parameters for ReportTaskRunnerHeartbeat.
     * @return A Java Future containing the result of the ReportTaskRunnerHeartbeat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ReportTaskRunnerHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ReportTaskRunnerHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReportTaskRunnerHeartbeatResponse> reportTaskRunnerHeartbeat(
            Consumer<ReportTaskRunnerHeartbeatRequest.Builder> reportTaskRunnerHeartbeatRequest) {
        return reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest.builder()
                .applyMutation(reportTaskRunnerHeartbeatRequest).build());
    }

    /**
     * <p>
     * Requests that the status of the specified physical or logical pipeline objects be updated in the specified
     * pipeline. This update might not occur immediately, but is eventually consistent. The status that can be set
     * depends on the type of object (for example, DataNode or Activity). You cannot perform this operation on
     * <code>FINISHED</code> pipelines and attempting to do so returns <code>InvalidRequestException</code>.
     * </p>
     *
     * @param setStatusRequest
     *        Contains the parameters for SetStatus.
     * @return A Java Future containing the result of the SetStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.SetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetStatusResponse> setStatus(SetStatusRequest setStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests that the status of the specified physical or logical pipeline objects be updated in the specified
     * pipeline. This update might not occur immediately, but is eventually consistent. The status that can be set
     * depends on the type of object (for example, DataNode or Activity). You cannot perform this operation on
     * <code>FINISHED</code> pipelines and attempting to do so returns <code>InvalidRequestException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetStatusRequest.Builder} avoiding the need to
     * create one manually via {@link SetStatusRequest#builder()}
     * </p>
     *
     * @param setStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.SetStatusRequest.Builder} to create a request.
     *        Contains the parameters for SetStatus.
     * @return A Java Future containing the result of the SetStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.SetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetStatusResponse> setStatus(Consumer<SetStatusRequest.Builder> setStatusRequest) {
        return setStatus(SetStatusRequest.builder().applyMutation(setStatusRequest).build());
    }

    /**
     * <p>
     * Task runners call <code>SetTaskStatus</code> to notify AWS Data Pipeline that a task is completed and provide
     * information about the final status. A task runner makes this call regardless of whether the task was sucessful. A
     * task runner does not need to call <code>SetTaskStatus</code> for tasks that are canceled by the web service
     * during a call to <a>ReportTaskProgress</a>.
     * </p>
     *
     * @param setTaskStatusRequest
     *        Contains the parameters for SetTaskStatus.
     * @return A Java Future containing the result of the SetTaskStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.SetTaskStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetTaskStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetTaskStatusResponse> setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Task runners call <code>SetTaskStatus</code> to notify AWS Data Pipeline that a task is completed and provide
     * information about the final status. A task runner makes this call regardless of whether the task was sucessful. A
     * task runner does not need to call <code>SetTaskStatus</code> for tasks that are canceled by the web service
     * during a call to <a>ReportTaskProgress</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTaskStatusRequest.Builder} avoiding the need to
     * create one manually via {@link SetTaskStatusRequest#builder()}
     * </p>
     *
     * @param setTaskStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest.Builder} to create a
     *        request. Contains the parameters for SetTaskStatus.
     * @return A Java Future containing the result of the SetTaskStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>TaskNotFoundException The specified task was not found.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.SetTaskStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetTaskStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetTaskStatusResponse> setTaskStatus(Consumer<SetTaskStatusRequest.Builder> setTaskStatusRequest) {
        return setTaskStatus(SetTaskStatusRequest.builder().applyMutation(setTaskStatusRequest).build());
    }

    /**
     * <p>
     * Validates the specified pipeline definition to ensure that it is well formed and can be run without error.
     * </p>
     *
     * @param validatePipelineDefinitionRequest
     *        Contains the parameters for ValidatePipelineDefinition.
     * @return A Java Future containing the result of the ValidatePipelineDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ValidatePipelineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ValidatePipelineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidatePipelineDefinitionResponse> validatePipelineDefinition(
            ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the specified pipeline definition to ensure that it is well formed and can be run without error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidatePipelineDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link ValidatePipelineDefinitionRequest#builder()}
     * </p>
     *
     * @param validatePipelineDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest.Builder} to
     *        create a request. Contains the parameters for ValidatePipelineDefinition.
     * @return A Java Future containing the result of the ValidatePipelineDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException An internal service error occurred.</li>
     *         <li>InvalidRequestException The request was not valid. Verify that your request was properly formatted,
     *         that the signature was generated with the correct credentials, and that you haven't exceeded any of the
     *         service limits for your account.</li>
     *         <li>PipelineNotFoundException The specified pipeline was not found. Verify that you used the correct user
     *         and account identifiers.</li>
     *         <li>PipelineDeletedException The specified pipeline has been deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataPipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataPipelineAsyncClient.ValidatePipelineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ValidatePipelineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidatePipelineDefinitionResponse> validatePipelineDefinition(
            Consumer<ValidatePipelineDefinitionRequest.Builder> validatePipelineDefinitionRequest) {
        return validatePipelineDefinition(ValidatePipelineDefinitionRequest.builder()
                .applyMutation(validatePipelineDefinitionRequest).build());
    }

    @Override
    default DataPipelineServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DataPipelineAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DataPipelineAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DataPipelineAsyncClient}.
     */
    static DataPipelineAsyncClientBuilder builder() {
        return new DefaultDataPipelineAsyncClientBuilder();
    }
}
