/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreatePipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePipelineRequest extends DataPipelineRequest implements
        ToCopyableBuilder<CreatePipelineRequest.Builder, CreatePipelineRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::uniqueId)).setter(setter(Builder::uniqueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreatePipelineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, UNIQUE_ID_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private final String name;

    private final String uniqueId;

    private final String description;

    private final List<Tag> tags;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.uniqueId = builder.uniqueId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS account,
     * because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.
     * </p>
     * 
     * @return The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS
     *         account, because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data Pipeline.
     * You are responsible for defining the format and ensuring the uniqueness of this identifier. You use this
     * parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For example, if the first
     * call to <code>CreatePipeline</code> does not succeed, you can pass in the same unique identifier and pipeline
     * name combination on a subsequent call to <code>CreatePipeline</code>. <code>CreatePipeline</code> ensures that if
     * a pipeline already exists with the same name and unique identifier, a new pipeline is not created. Instead,
     * you'll receive the pipeline identifier from the previous attempt. The uniqueness of the name and unique
     * identifier combination is scoped to the AWS account or IAM user credentials.
     * </p>
     * 
     * @return A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data
     *         Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier. You
     *         use this parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For
     *         example, if the first call to <code>CreatePipeline</code> does not succeed, you can pass in the same
     *         unique identifier and pipeline name combination on a subsequent call to <code>CreatePipeline</code>.
     *         <code>CreatePipeline</code> ensures that if a pipeline already exists with the same name and unique
     *         identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the
     *         previous attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS
     *         account or IAM user credentials.
     */
    public String uniqueId() {
        return uniqueId;
    }

    /**
     * <p>
     * The description for the pipeline.
     * </p>
     * 
     * @return The description for the pipeline.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
     * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling
     *         User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(uniqueId(), other.uniqueId())
                && Objects.equals(description(), other.description()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("CreatePipelineRequest").add("Name", name()).add("UniqueId", uniqueId())
                .add("Description", description()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "uniqueId":
            return Optional.ofNullable(clazz.cast(uniqueId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePipelineRequest> {
        /**
         * <p>
         * The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS account,
         * because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.
         * </p>
         * 
         * @param name
         *        The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS
         *        account, because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data
         * Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier. You use
         * this parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For example, if
         * the first call to <code>CreatePipeline</code> does not succeed, you can pass in the same unique identifier
         * and pipeline name combination on a subsequent call to <code>CreatePipeline</code>.
         * <code>CreatePipeline</code> ensures that if a pipeline already exists with the same name and unique
         * identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the previous
         * attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS account or IAM
         * user credentials.
         * </p>
         * 
         * @param uniqueId
         *        A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data
         *        Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier.
         *        You use this parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For
         *        example, if the first call to <code>CreatePipeline</code> does not succeed, you can pass in the same
         *        unique identifier and pipeline name combination on a subsequent call to <code>CreatePipeline</code>.
         *        <code>CreatePipeline</code> ensures that if a pipeline already exists with the same name and unique
         *        identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the
         *        previous attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS
         *        account or IAM user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);

        /**
         * <p>
         * The description for the pipeline.
         * </p>
         * 
         * @param description
         *        The description for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
         * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html"
         *        >Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
         * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html"
         *        >Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
         * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String name;

        private String uniqueId;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            name(model.name);
            uniqueId(model.uniqueId);
            description(model.description);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
