/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for EvaluateExpression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateExpressionRequest extends DataPipelineRequest implements
        ToCopyableBuilder<EvaluateExpressionRequest.Builder, EvaluateExpressionRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluateExpressionRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<String> OBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluateExpressionRequest::objectId)).setter(setter(Builder::objectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectId").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluateExpressionRequest::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD,
            OBJECT_ID_FIELD, EXPRESSION_FIELD));

    private final String pipelineId;

    private final String objectId;

    private final String expression;

    private EvaluateExpressionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectId = builder.objectId;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * The ID of the pipeline.
     * </p>
     * 
     * @return The ID of the pipeline.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * <p>
     * The ID of the object.
     * </p>
     * 
     * @return The ID of the object.
     */
    public String objectId() {
        return objectId;
    }

    /**
     * <p>
     * The expression to evaluate.
     * </p>
     * 
     * @return The expression to evaluate.
     */
    public String expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(objectId());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateExpressionRequest)) {
            return false;
        }
        EvaluateExpressionRequest other = (EvaluateExpressionRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && Objects.equals(objectId(), other.objectId())
                && Objects.equals(expression(), other.expression());
    }

    @Override
    public String toString() {
        return ToString.builder("EvaluateExpressionRequest").add("PipelineId", pipelineId()).add("ObjectId", objectId())
                .add("Expression", expression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "objectId":
            return Optional.ofNullable(clazz.cast(objectId()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateExpressionRequest, T> g) {
        return obj -> g.apply((EvaluateExpressionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateExpressionRequest> {
        /**
         * <p>
         * The ID of the pipeline.
         * </p>
         * 
         * @param pipelineId
         *        The ID of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * The ID of the object.
         * </p>
         * 
         * @param objectId
         *        The ID of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectId(String objectId);

        /**
         * <p>
         * The expression to evaluate.
         * </p>
         * 
         * @param expression
         *        The expression to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private String objectId;

        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateExpressionRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            objectId(model.objectId);
            expression(model.expression);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getObjectId() {
            return objectId;
        }

        @Override
        public final Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public final void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public final String getExpression() {
            return expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateExpressionRequest build() {
            return new EvaluateExpressionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
