/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ReportTaskProgress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportTaskProgressResponse extends DataPipelineResponse implements
        ToCopyableBuilder<ReportTaskProgressResponse.Builder, ReportTaskProgressResponse> {
    private static final SdkField<Boolean> CANCELED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canceled").getter(getter(ReportTaskProgressResponse::canceled)).setter(setter(Builder::canceled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canceled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean canceled;

    private ReportTaskProgressResponse(BuilderImpl builder) {
        super(builder);
        this.canceled = builder.canceled;
    }

    /**
     * <p>
     * If true, the calling task runner should cancel processing of the task. The task runner does not need to call
     * <a>SetTaskStatus</a> for canceled tasks.
     * </p>
     * 
     * @return If true, the calling task runner should cancel processing of the task. The task runner does not need to
     *         call <a>SetTaskStatus</a> for canceled tasks.
     */
    public final Boolean canceled() {
        return canceled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(canceled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportTaskProgressResponse)) {
            return false;
        }
        ReportTaskProgressResponse other = (ReportTaskProgressResponse) obj;
        return Objects.equals(canceled(), other.canceled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportTaskProgressResponse").add("Canceled", canceled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canceled":
            return Optional.ofNullable(clazz.cast(canceled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("canceled", CANCELED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportTaskProgressResponse, T> g) {
        return obj -> g.apply((ReportTaskProgressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ReportTaskProgressResponse> {
        /**
         * <p>
         * If true, the calling task runner should cancel processing of the task. The task runner does not need to call
         * <a>SetTaskStatus</a> for canceled tasks.
         * </p>
         * 
         * @param canceled
         *        If true, the calling task runner should cancel processing of the task. The task runner does not need
         *        to call <a>SetTaskStatus</a> for canceled tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canceled(Boolean canceled);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private Boolean canceled;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportTaskProgressResponse model) {
            super(model);
            canceled(model.canceled);
        }

        public final Boolean getCanceled() {
            return canceled;
        }

        public final void setCanceled(Boolean canceled) {
            this.canceled = canceled;
        }

        @Override
        public final Builder canceled(Boolean canceled) {
            this.canceled = canceled;
            return this;
        }

        @Override
        public ReportTaskProgressResponse build() {
            return new ReportTaskProgressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
