/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A comparision that is used to determine whether a query should return this object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Selector implements SdkPojo, Serializable, ToCopyableBuilder<Selector.Builder, Selector> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldName").getter(getter(Selector::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<Operator> OPERATOR_FIELD = SdkField.<Operator> builder(MarshallingType.SDK_POJO)
            .memberName("operator").getter(getter(Selector::operator)).setter(setter(Builder::operator))
            .constructor(Operator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final Operator operator;

    private Selector(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The name of the field that the operator will be applied to. The field name is the "key" portion of the field
     * definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the field is not set
     * on the object, the condition fails.
     * </p>
     * 
     * @return The name of the field that the operator will be applied to. The field name is the "key" portion of the
     *         field definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the
     *         field is not set on the object, the condition fails.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * Returns the value of the Operator property for this object.
     * 
     * @return The value of the Operator property for this object.
     */
    public final Operator operator() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Selector)) {
            return false;
        }
        Selector other = (Selector) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(operator(), other.operator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Selector").add("FieldName", fieldName()).add("Operator", operator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldName", FIELD_NAME_FIELD);
        map.put("operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Selector, T> g) {
        return obj -> g.apply((Selector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Selector> {
        /**
         * <p>
         * The name of the field that the operator will be applied to. The field name is the "key" portion of the field
         * definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the field is not
         * set on the object, the condition fails.
         * </p>
         * 
         * @param fieldName
         *        The name of the field that the operator will be applied to. The field name is the "key" portion of the
         *        field definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the
         *        field is not set on the object, the condition fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * Sets the value of the Operator property for this object.
         *
         * @param operator
         *        The new value for the Operator property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(Operator operator);

        /**
         * Sets the value of the Operator property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Operator.Builder} avoiding the need to
         * create one manually via {@link Operator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Operator.Builder#build()} is called immediately and its result is
         * passed to {@link #operator(Operator)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link Operator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(Operator)
         */
        default Builder operator(Consumer<Operator.Builder> operator) {
            return operator(Operator.builder().applyMutation(operator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private Operator operator;

        private BuilderImpl() {
        }

        private BuilderImpl(Selector model) {
            fieldName(model.fieldName);
            operator(model.operator);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final Operator.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(Operator.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public Selector build() {
            return new Selector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
