/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the query to run against an object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Query implements SdkPojo, Serializable, ToCopyableBuilder<Query.Builder, Query> {
    private static final SdkField<List<Selector>> SELECTORS_FIELD = SdkField
            .<List<Selector>> builder(MarshallingType.LIST)
            .getter(getter(Query::selectors))
            .setter(setter(Builder::selectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Selector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Selector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Selector> selectors;

    private Query(BuilderImpl builder) {
        this.selectors = builder.selectors;
    }

    /**
     * <p>
     * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of selectors that define the query. An object must satisfy all of the selectors to match the query.
     */
    public List<Selector> selectors() {
        return selectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query) obj;
        return Objects.equals(selectors(), other.selectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Query").add("Selectors", selectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selectors":
            return Optional.ofNullable(clazz.cast(selectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Query, T> g) {
        return obj -> g.apply((Query) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Query> {
        /**
         * <p>
         * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
         * </p>
         * 
         * @param selectors
         *        List of selectors that define the query. An object must satisfy all of the selectors to match the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Collection<Selector> selectors);

        /**
         * <p>
         * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
         * </p>
         * 
         * @param selectors
         *        List of selectors that define the query. An object must satisfy all of the selectors to match the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Selector... selectors);

        /**
         * <p>
         * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Selector>.Builder} avoiding the need to
         * create one manually via {@link List<Selector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Selector>.Builder#build()} is called immediately and its
         * result is passed to {@link #selectors(List<Selector>)}.
         * 
         * @param selectors
         *        a consumer that will call methods on {@link List<Selector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectors(List<Selector>)
         */
        Builder selectors(Consumer<Selector.Builder>... selectors);
    }

    static final class BuilderImpl implements Builder {
        private List<Selector> selectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            selectors(model.selectors);
        }

        public final Collection<Selector.Builder> getSelectors() {
            return selectors != null ? selectors.stream().map(Selector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectors(Collection<Selector> selectors) {
            this.selectors = SelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Selector... selectors) {
            selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<Selector.Builder>... selectors) {
            selectors(Stream.of(selectors).map(c -> Selector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSelectors(Collection<Selector.BuilderImpl> selectors) {
            this.selectors = SelectorListCopier.copyFromBuilder(selectors);
        }

        @Override
        public Query build() {
            return new Query(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
