/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of QueryObjects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryObjectsResponse extends DataPipelineResponse implements
        ToCopyableBuilder<QueryObjectsResponse.Builder, QueryObjectsResponse> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(QueryObjectsResponse::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryObjectsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()).build();

    private static final SdkField<Boolean> HAS_MORE_RESULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(QueryObjectsResponse::hasMoreResults)).setter(setter(Builder::hasMoreResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, MARKER_FIELD,
            HAS_MORE_RESULTS_FIELD));

    private final List<String> ids;

    private final String marker;

    private final Boolean hasMoreResults;

    private QueryObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    /**
     * <p>
     * The identifiers that match the query selectors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The identifiers that match the query selectors.
     */
    public List<String> ids() {
        return ids;
    }

    /**
     * <p>
     * The starting point for the next page of results. To view the next page of results, call <code>QueryObjects</code>
     * again with this marker value. If the value is null, there are no more results.
     * </p>
     * 
     * @return The starting point for the next page of results. To view the next page of results, call
     *         <code>QueryObjects</code> again with this marker value. If the value is null, there are no more results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Indicates whether there are more results that can be obtained by a subsequent call.
     * </p>
     * 
     * @return Indicates whether there are more results that can be obtained by a subsequent call.
     */
    public Boolean hasMoreResults() {
        return hasMoreResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ids());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryObjectsResponse)) {
            return false;
        }
        QueryObjectsResponse other = (QueryObjectsResponse) obj;
        return Objects.equals(ids(), other.ids()) && Objects.equals(marker(), other.marker())
                && Objects.equals(hasMoreResults(), other.hasMoreResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryObjectsResponse").add("Ids", ids()).add("Marker", marker())
                .add("HasMoreResults", hasMoreResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "hasMoreResults":
            return Optional.ofNullable(clazz.cast(hasMoreResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryObjectsResponse, T> g) {
        return obj -> g.apply((QueryObjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, QueryObjectsResponse> {
        /**
         * <p>
         * The identifiers that match the query selectors.
         * </p>
         * 
         * @param ids
         *        The identifiers that match the query selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * The identifiers that match the query selectors.
         * </p>
         * 
         * @param ids
         *        The identifiers that match the query selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * The starting point for the next page of results. To view the next page of results, call
         * <code>QueryObjects</code> again with this marker value. If the value is null, there are no more results.
         * </p>
         * 
         * @param marker
         *        The starting point for the next page of results. To view the next page of results, call
         *        <code>QueryObjects</code> again with this marker value. If the value is null, there are no more
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Indicates whether there are more results that can be obtained by a subsequent call.
         * </p>
         * 
         * @param hasMoreResults
         *        Indicates whether there are more results that can be obtained by a subsequent call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreResults(Boolean hasMoreResults);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryObjectsResponse model) {
            super(model);
            ids(model.ids);
            marker(model.marker);
            hasMoreResults(model.hasMoreResults);
        }

        public final Collection<String> getIds() {
            return ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public QueryObjectsResponse build() {
            return new QueryObjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
