/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * StartTaskExecutionResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTaskExecutionResponse extends DataSyncResponse implements
        ToCopyableBuilder<StartTaskExecutionResponse.Builder, StartTaskExecutionResponse> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTaskExecutionResponse::taskExecutionArn)).setter(setter(Builder::taskExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD));

    private final String taskExecutionArn;

    private StartTaskExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutionArn = builder.taskExecutionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specific task execution that was started.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specific task execution that was started.
     */
    public String taskExecutionArn() {
        return taskExecutionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskExecutionResponse)) {
            return false;
        }
        StartTaskExecutionResponse other = (StartTaskExecutionResponse) obj;
        return Objects.equals(taskExecutionArn(), other.taskExecutionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartTaskExecutionResponse").add("TaskExecutionArn", taskExecutionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskExecutionArn":
            return Optional.ofNullable(clazz.cast(taskExecutionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskExecutionResponse, T> g) {
        return obj -> g.apply((StartTaskExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartTaskExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specific task execution that was started.
         * </p>
         * 
         * @param taskExecutionArn
         *        The Amazon Resource Name (ARN) of the specific task execution that was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionArn(String taskExecutionArn);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String taskExecutionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskExecutionResponse model) {
            super(model);
            taskExecutionArn(model.taskExecutionArn);
        }

        public final String getTaskExecutionArn() {
            return taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public StartTaskExecutionResponse build() {
            return new StartTaskExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
