/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateLocationEfsRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationEfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationEfsRequest.Builder, CreateLocationEfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationEfsRequest::subdirectory)).setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> EFS_FILESYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationEfsRequest::efsFilesystemArn)).setter(setter(Builder::efsFilesystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsFilesystemArn").build()).build();

    private static final SdkField<Ec2Config> EC2_CONFIG_FIELD = SdkField.<Ec2Config> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLocationEfsRequest::ec2Config)).setter(setter(Builder::ec2Config))
            .constructor(Ec2Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2Config").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .getter(getter(CreateLocationEfsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD,
            EFS_FILESYSTEM_ARN_FIELD, EC2_CONFIG_FIELD, TAGS_FIELD));

    private final String subdirectory;

    private final String efsFilesystemArn;

    private final Ec2Config ec2Config;

    private final List<TagListEntry> tags;

    private CreateLocationEfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.efsFilesystemArn = builder.efsFilesystemArn;
        this.ec2Config = builder.ec2Config;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from the EFS
     * source location or write data to the EFS destination. By default, AWS DataSync uses the root directory.
     * </p>
     * <note>
     * <p>
     * <code>Subdirectory</code> must be specified with forward slashes. For example <code>/path/to/folder</code>.
     * </p>
     * </note>
     * 
     * @return A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from
     *         the EFS source location or write data to the EFS destination. By default, AWS DataSync uses the root
     *         directory.</p> <note>
     *         <p>
     *         <code>Subdirectory</code> must be specified with forward slashes. For example
     *         <code>/path/to/folder</code>.
     *         </p>
     */
    public String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Amazon EFS file system.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Amazon EFS file system.
     */
    public String efsFilesystemArn() {
        return efsFilesystemArn;
    }

    /**
     * <p>
     * The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs to
     * be able to communicate with the security group on the mount target in the subnet specified.
     * </p>
     * <p>
     * The exact relationship between security group M (of the mount target) and security group S (which you provide for
     * DataSync to use at this stage) is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security group M (which you associate with the mount target) must allow inbound access for the Transmission
     * Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by
     * IP address (CIDR range) or security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the
     * NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address
     * (CIDR range) or security group.
     * </p>
     * <p>
     * For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and Mount
     * Targets in the <i>Amazon EFS User Guide.</i>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The subnet and security group that the Amazon EFS file system uses. The security group that you provide
     *         needs to be able to communicate with the security group on the mount target in the subnet specified.</p>
     *         <p>
     *         The exact relationship between security group M (of the mount target) and security group S (which you
     *         provide for DataSync to use at this stage) is as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Security group M (which you associate with the mount target) must allow inbound access for the
     *         Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound
     *         connections either by IP address (CIDR range) or security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Security group S (provided to DataSync to access EFS) should have a rule that enables outbound
     *         connections to the NFS port on one of the file system’s mount targets. You can enable outbound
     *         connections either by IP address (CIDR range) or security group.
     *         </p>
     *         <p>
     *         For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and
     *         Mount Targets in the <i>Amazon EFS User Guide.</i>
     *         </p>
     *         </li>
     */
    public Ec2Config ec2Config() {
        return ec2Config;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string.
     * This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for
     * your location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
     *         string. This value helps you manage, filter, and search for your resources. We recommend that you create
     *         a name tag for your location.
     */
    public List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(efsFilesystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(ec2Config());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationEfsRequest)) {
            return false;
        }
        CreateLocationEfsRequest other = (CreateLocationEfsRequest) obj;
        return Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(efsFilesystemArn(), other.efsFilesystemArn()) && Objects.equals(ec2Config(), other.ec2Config())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLocationEfsRequest").add("Subdirectory", subdirectory())
                .add("EfsFilesystemArn", efsFilesystemArn()).add("Ec2Config", ec2Config()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "EfsFilesystemArn":
            return Optional.ofNullable(clazz.cast(efsFilesystemArn()));
        case "Ec2Config":
            return Optional.ofNullable(clazz.cast(ec2Config()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationEfsRequest, T> g) {
        return obj -> g.apply((CreateLocationEfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationEfsRequest> {
        /**
         * <p>
         * A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from the
         * EFS source location or write data to the EFS destination. By default, AWS DataSync uses the root directory.
         * </p>
         * <note>
         * <p>
         * <code>Subdirectory</code> must be specified with forward slashes. For example <code>/path/to/folder</code>.
         * </p>
         * </note>
         * 
         * @param subdirectory
         *        A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data
         *        from the EFS source location or write data to the EFS destination. By default, AWS DataSync uses the
         *        root directory.</p> <note>
         *        <p>
         *        <code>Subdirectory</code> must be specified with forward slashes. For example
         *        <code>/path/to/folder</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Amazon EFS file system.
         * </p>
         * 
         * @param efsFilesystemArn
         *        The Amazon Resource Name (ARN) for the Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFilesystemArn(String efsFilesystemArn);

        /**
         * <p>
         * The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs
         * to be able to communicate with the security group on the mount target in the subnet specified.
         * </p>
         * <p>
         * The exact relationship between security group M (of the mount target) and security group S (which you provide
         * for DataSync to use at this stage) is as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Security group M (which you associate with the mount target) must allow inbound access for the Transmission
         * Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections
         * either by IP address (CIDR range) or security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to
         * the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP
         * address (CIDR range) or security group.
         * </p>
         * <p>
         * For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and
         * Mount Targets in the <i>Amazon EFS User Guide.</i>
         * </p>
         * </li>
         * </ul>
         * 
         * @param ec2Config
         *        The subnet and security group that the Amazon EFS file system uses. The security group that you
         *        provide needs to be able to communicate with the security group on the mount target in the subnet
         *        specified.</p>
         *        <p>
         *        The exact relationship between security group M (of the mount target) and security group S (which you
         *        provide for DataSync to use at this stage) is as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Security group M (which you associate with the mount target) must allow inbound access for the
         *        Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable
         *        inbound connections either by IP address (CIDR range) or security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Security group S (provided to DataSync to access EFS) should have a rule that enables outbound
         *        connections to the NFS port on one of the file system’s mount targets. You can enable outbound
         *        connections either by IP address (CIDR range) or security group.
         *        </p>
         *        <p>
         *        For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances
         *        and Mount Targets in the <i>Amazon EFS User Guide.</i>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Config(Ec2Config ec2Config);

        /**
         * <p>
         * The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs
         * to be able to communicate with the security group on the mount target in the subnet specified.
         * </p>
         * <p>
         * The exact relationship between security group M (of the mount target) and security group S (which you provide
         * for DataSync to use at this stage) is as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Security group M (which you associate with the mount target) must allow inbound access for the Transmission
         * Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections
         * either by IP address (CIDR range) or security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to
         * the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP
         * address (CIDR range) or security group.
         * </p>
         * <p>
         * For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and
         * Mount Targets in the <i>Amazon EFS User Guide.</i>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link Ec2Config.Builder} avoiding the need to create
         * one manually via {@link Ec2Config#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ec2Config.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2Config(Ec2Config)}.
         * 
         * @param ec2Config
         *        a consumer that will call methods on {@link Ec2Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Config(Ec2Config)
         */
        default Builder ec2Config(Consumer<Ec2Config.Builder> ec2Config) {
            return ec2Config(Ec2Config.builder().applyMutation(ec2Config).build());
        }

        /**
         * <p>
         * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
         * string. This value helps you manage, filter, and search for your resources. We recommend that you create a
         * name tag for your location.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents a tag that you want to add to the resource. The value can be an
         *        empty string. This value helps you manage, filter, and search for your resources. We recommend that
         *        you create a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
         * string. This value helps you manage, filter, and search for your resources. We recommend that you create a
         * name tag for your location.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents a tag that you want to add to the resource. The value can be an
         *        empty string. This value helps you manage, filter, and search for your resources. We recommend that
         *        you create a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
         * string. This value helps you manage, filter, and search for your resources. We recommend that you create a
         * name tag for your location.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagListEntry>.Builder} avoiding the need to
         * create one manually via {@link List<TagListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String subdirectory;

        private String efsFilesystemArn;

        private Ec2Config ec2Config;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationEfsRequest model) {
            super(model);
            subdirectory(model.subdirectory);
            efsFilesystemArn(model.efsFilesystemArn);
            ec2Config(model.ec2Config);
            tags(model.tags);
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        public final String getEfsFilesystemArn() {
            return efsFilesystemArn;
        }

        @Override
        public final Builder efsFilesystemArn(String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
            return this;
        }

        public final void setEfsFilesystemArn(String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
        }

        public final Ec2Config.Builder getEc2Config() {
            return ec2Config != null ? ec2Config.toBuilder() : null;
        }

        @Override
        public final Builder ec2Config(Ec2Config ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        public final void setEc2Config(Ec2Config.BuilderImpl ec2Config) {
            this.ec2Config = ec2Config != null ? ec2Config.build() : null;
        }

        public final Collection<TagListEntry.Builder> getTags() {
            return tags != null ? tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationEfsRequest build() {
            return new CreateLocationEfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
