/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * StartTaskExecutionRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTaskExecutionRequest extends DataSyncRequest implements
        ToCopyableBuilder<StartTaskExecutionRequest.Builder, StartTaskExecutionRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTaskExecutionRequest::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<Options> OVERRIDE_OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartTaskExecutionRequest::overrideOptions)).setter(setter(Builder::overrideOptions))
            .constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideOptions").build()).build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .getter(getter(StartTaskExecutionRequest::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD,
            OVERRIDE_OPTIONS_FIELD, INCLUDES_FIELD));

    private final String taskArn;

    private final Options overrideOptions;

    private final List<FilterRule> includes;

    private StartTaskExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.overrideOptions = builder.overrideOptions;
        this.includes = builder.includes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task to start.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task to start.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * Returns the value of the OverrideOptions property for this object.
     * 
     * @return The value of the OverrideOptions property for this object.
     */
    public Options overrideOptions() {
        return overrideOptions;
    }

    /**
     * Returns true if the Includes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that determines which files to include when running a task. The pattern should contain a
     * single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a
     * pipe). For example: <code>"/folder1|/folder2"</code>
     * </p>
     * <p>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of filter rules that determines which files to include when running a task. The pattern should
     *         contain a single filter string that consists of the patterns to include. The patterns are delimited by
     *         "|" (that is, a pipe). For example: <code>"/folder1|/folder2"</code> </p>
     *         <p>
     */
    public List<FilterRule> includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(overrideOptions());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskExecutionRequest)) {
            return false;
        }
        StartTaskExecutionRequest other = (StartTaskExecutionRequest) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(overrideOptions(), other.overrideOptions())
                && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartTaskExecutionRequest").add("TaskArn", taskArn()).add("OverrideOptions", overrideOptions())
                .add("Includes", includes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "OverrideOptions":
            return Optional.ofNullable(clazz.cast(overrideOptions()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskExecutionRequest, T> g) {
        return obj -> g.apply((StartTaskExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTaskExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task to start.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * Sets the value of the OverrideOptions property for this object.
         *
         * @param overrideOptions
         *        The new value for the OverrideOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideOptions(Options overrideOptions);

        /**
         * Sets the value of the OverrideOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link Options.Builder} avoiding the need to create one
         * manually via {@link Options#builder()}.
         *
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #overrideOptions(Options)}.
         * 
         * @param overrideOptions
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideOptions(Options)
         */
        default Builder overrideOptions(Consumer<Options.Builder> overrideOptions) {
            return overrideOptions(Options.builder().applyMutation(overrideOptions).build());
        }

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The pattern should contain
         * a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is,
         * a pipe). For example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param includes
         *        A list of filter rules that determines which files to include when running a task. The pattern should
         *        contain a single filter string that consists of the patterns to include. The patterns are delimited by
         *        "|" (that is, a pipe). For example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The pattern should contain
         * a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is,
         * a pipe). For example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param includes
         *        A list of filter rules that determines which files to include when running a task. The pattern should
         *        contain a single filter string that consists of the patterns to include. The patterns are delimited by
         *        "|" (that is, a pipe). For example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The pattern should contain
         * a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is,
         * a pipe). For example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilterRule>.Builder} avoiding the need to
         * create one manually via {@link List<FilterRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilterRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link List<FilterRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(List<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String taskArn;

        private Options overrideOptions;

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskExecutionRequest model) {
            super(model);
            taskArn(model.taskArn);
            overrideOptions(model.overrideOptions);
            includes(model.includes);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Options.Builder getOverrideOptions() {
            return overrideOptions != null ? overrideOptions.toBuilder() : null;
        }

        @Override
        public final Builder overrideOptions(Options overrideOptions) {
            this.overrideOptions = overrideOptions;
            return this;
        }

        public final void setOverrideOptions(Options.BuilderImpl overrideOptions) {
            this.overrideOptions = overrideOptions != null ? overrideOptions.build() : null;
        }

        public final Collection<FilterRule.Builder> getIncludes() {
            return includes != null ? includes.stream().map(FilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskExecutionRequest build() {
            return new StartTaskExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
