/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListAgentsResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentsResponse extends DataSyncResponse implements
        ToCopyableBuilder<ListAgentsResponse.Builder, ListAgentsResponse> {
    private static final SdkField<List<AgentListEntry>> AGENTS_FIELD = SdkField
            .<List<AgentListEntry>> builder(MarshallingType.LIST)
            .getter(getter(ListAgentsResponse::agents))
            .setter(setter(Builder::agents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAgentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AGENTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AgentListEntry> agents;

    private final String nextToken;

    private ListAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agents = builder.agents;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Agents property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAgents() {
        return agents != null && !(agents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of agents in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of agents in your account.
     */
    public List<AgentListEntry> agents() {
        return agents;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin returning the next list of agents.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin returning the next list of agents.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentsResponse)) {
            return false;
        }
        ListAgentsResponse other = (ListAgentsResponse) obj;
        return Objects.equals(agents(), other.agents()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAgentsResponse").add("Agents", agents()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Agents":
            return Optional.ofNullable(clazz.cast(agents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentsResponse, T> g) {
        return obj -> g.apply((ListAgentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgentsResponse> {
        /**
         * <p>
         * A list of agents in your account.
         * </p>
         * 
         * @param agents
         *        A list of agents in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(Collection<AgentListEntry> agents);

        /**
         * <p>
         * A list of agents in your account.
         * </p>
         * 
         * @param agents
         *        A list of agents in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(AgentListEntry... agents);

        /**
         * <p>
         * A list of agents in your account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AgentListEntry>.Builder} avoiding the need
         * to create one manually via {@link List<AgentListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AgentListEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #agents(List<AgentListEntry>)}.
         * 
         * @param agents
         *        a consumer that will call methods on {@link List<AgentListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agents(List<AgentListEntry>)
         */
        Builder agents(Consumer<AgentListEntry.Builder>... agents);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin returning the next list of agents.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates the position at which to begin returning the next list of agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private List<AgentListEntry> agents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentsResponse model) {
            super(model);
            agents(model.agents);
            nextToken(model.nextToken);
        }

        public final Collection<AgentListEntry.Builder> getAgents() {
            return agents != null ? agents.stream().map(AgentListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agents(Collection<AgentListEntry> agents) {
            this.agents = AgentListCopier.copy(agents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(AgentListEntry... agents) {
            agents(Arrays.asList(agents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(Consumer<AgentListEntry.Builder>... agents) {
            agents(Stream.of(agents).map(c -> AgentListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAgents(Collection<AgentListEntry.BuilderImpl> agents) {
            this.agents = AgentListCopier.copyFromBuilder(agents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAgentsResponse build() {
            return new ListAgentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
