/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTaskExecutionResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskExecutionResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeTaskExecutionResponse.Builder, DescribeTaskExecutionResponse> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTaskExecutionResponse::taskExecutionArn)).setter(setter(Builder::taskExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTaskExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Options> OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeTaskExecutionResponse::options)).setter(setter(Builder::options))
            .constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTaskExecutionResponse::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTaskExecutionResponse::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeTaskExecutionResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Long> ESTIMATED_FILES_TO_TRANSFER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeTaskExecutionResponse::estimatedFilesToTransfer))
            .setter(setter(Builder::estimatedFilesToTransfer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedFilesToTransfer").build())
            .build();

    private static final SdkField<Long> ESTIMATED_BYTES_TO_TRANSFER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeTaskExecutionResponse::estimatedBytesToTransfer))
            .setter(setter(Builder::estimatedBytesToTransfer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedBytesToTransfer").build())
            .build();

    private static final SdkField<Long> FILES_TRANSFERRED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeTaskExecutionResponse::filesTransferred)).setter(setter(Builder::filesTransferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesTransferred").build()).build();

    private static final SdkField<Long> BYTES_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeTaskExecutionResponse::bytesWritten)).setter(setter(Builder::bytesWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesWritten").build()).build();

    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeTaskExecutionResponse::bytesTransferred)).setter(setter(Builder::bytesTransferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()).build();

    private static final SdkField<TaskExecutionResultDetail> RESULT_FIELD = SdkField
            .<TaskExecutionResultDetail> builder(MarshallingType.SDK_POJO).getter(getter(DescribeTaskExecutionResponse::result))
            .setter(setter(Builder::result)).constructor(TaskExecutionResultDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD,
            STATUS_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, INCLUDES_FIELD, START_TIME_FIELD, ESTIMATED_FILES_TO_TRANSFER_FIELD,
            ESTIMATED_BYTES_TO_TRANSFER_FIELD, FILES_TRANSFERRED_FIELD, BYTES_WRITTEN_FIELD, BYTES_TRANSFERRED_FIELD,
            RESULT_FIELD));

    private final String taskExecutionArn;

    private final String status;

    private final Options options;

    private final List<FilterRule> excludes;

    private final List<FilterRule> includes;

    private final Instant startTime;

    private final Long estimatedFilesToTransfer;

    private final Long estimatedBytesToTransfer;

    private final Long filesTransferred;

    private final Long bytesWritten;

    private final Long bytesTransferred;

    private final TaskExecutionResultDetail result;

    private DescribeTaskExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutionArn = builder.taskExecutionArn;
        this.status = builder.status;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.startTime = builder.startTime;
        this.estimatedFilesToTransfer = builder.estimatedFilesToTransfer;
        this.estimatedBytesToTransfer = builder.estimatedBytesToTransfer;
        this.filesTransferred = builder.filesTransferred;
        this.bytesWritten = builder.bytesWritten;
        this.bytesTransferred = builder.bytesTransferred;
        this.result = builder.result;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is
     * hierarchical and includes <code>TaskArn</code> for the task that was executed.
     * </p>
     * <p>
     * For example, a <code>TaskExecution</code> value with the ARN
     * <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
     * executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is
     *         hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
     *         <p>
     *         For example, a <code>TaskExecution</code> value with the ARN
     *         <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
     *         executed the task with the ARN
     *         <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
     */
    public String taskExecutionArn() {
        return taskExecutionArn;
    }

    /**
     * <p>
     * The status of the task execution.
     * </p>
     * <p>
     * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS DataSync
     * User Guide.</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task execution. </p>
     *         <p>
     *         For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS
     *         DataSync User Guide.</i>
     * @see TaskExecutionStatus
     */
    public TaskExecutionStatus status() {
        return TaskExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task execution.
     * </p>
     * <p>
     * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS DataSync
     * User Guide.</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task execution. </p>
     *         <p>
     *         For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS
     *         DataSync User Guide.</i>
     * @see TaskExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the Options property for this object.
     * 
     * @return The value of the Options property for this object.
     */
    public Options options() {
        return options;
    }

    /**
     * Returns true if the Excludes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that determines which files to exclude from a task. The list should contain a single
     * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for
     * example: <code>"/folder1|/folder2"</code>
     * </p>
     * <p>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of filter rules that determines which files to exclude from a task. The list should contain a
     *         single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
     *         is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
     *         <p>
     */
    public List<FilterRule> excludes() {
        return excludes;
    }

    /**
     * Returns true if the Includes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that determines which files to include when running a task. The list should contain a
     * single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a
     * pipe), for example: <code>"/folder1|/folder2"</code>
     * </p>
     * <p>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of filter rules that determines which files to include when running a task. The list should
     *         contain a single filter string that consists of the patterns to include. The patterns are delimited by
     *         "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
     *         <p>
     */
    public List<FilterRule> includes() {
        return includes;
    }

    /**
     * <p>
     * The time that the task execution was started.
     * </p>
     * 
     * @return The time that the task execution was started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The expected number of files that is to be transferred over the network. This value is calculated during the
     * PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred.
     * It's calculated based on comparing the content of the source and destination locations and finding the delta that
     * needs to be transferred.
     * </p>
     * 
     * @return The expected number of files that is to be transferred over the network. This value is calculated during
     *         the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be
     *         transferred. It's calculated based on comparing the content of the source and destination locations and
     *         finding the delta that needs to be transferred.
     */
    public Long estimatedFilesToTransfer() {
        return estimatedFilesToTransfer;
    }

    /**
     * <p>
     * The estimated physical number of bytes that is to be transferred over the network.
     * </p>
     * 
     * @return The estimated physical number of bytes that is to be transferred over the network.
     */
    public Long estimatedBytesToTransfer() {
        return estimatedBytesToTransfer;
    }

    /**
     * <p>
     * The actual number of files that was transferred over the network. This value is calculated and updated on an
     * ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and
     * sent over the network.
     * </p>
     * <p>
     * If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This
     * value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is
     * implementation-specific for some location types, so don't use it as an indicator for a correct file number or to
     * monitor your task execution.
     * </p>
     * 
     * @return The actual number of files that was transferred over the network. This value is calculated and updated on
     *         an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the
     *         source and sent over the network. </p>
     *         <p>
     *         If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>.
     *         This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is
     *         implementation-specific for some location types, so don't use it as an indicator for a correct file
     *         number or to monitor your task execution.
     */
    public Long filesTransferred() {
        return filesTransferred;
    }

    /**
     * <p>
     * The number of logical bytes written to the destination AWS storage resource.
     * </p>
     * 
     * @return The number of logical bytes written to the destination AWS storage resource.
     */
    public Long bytesWritten() {
        return bytesWritten;
    }

    /**
     * <p>
     * The physical number of bytes transferred over the network.
     * </p>
     * 
     * @return The physical number of bytes transferred over the network.
     */
    public Long bytesTransferred() {
        return bytesTransferred;
    }

    /**
     * <p>
     * The result of the task execution.
     * </p>
     * 
     * @return The result of the task execution.
     */
    public TaskExecutionResultDetail result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedFilesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedBytesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(filesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(bytesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskExecutionResponse)) {
            return false;
        }
        DescribeTaskExecutionResponse other = (DescribeTaskExecutionResponse) obj;
        return Objects.equals(taskExecutionArn(), other.taskExecutionArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(options(), other.options())
                && Objects.equals(excludes(), other.excludes()) && Objects.equals(includes(), other.includes())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(estimatedFilesToTransfer(), other.estimatedFilesToTransfer())
                && Objects.equals(estimatedBytesToTransfer(), other.estimatedBytesToTransfer())
                && Objects.equals(filesTransferred(), other.filesTransferred())
                && Objects.equals(bytesWritten(), other.bytesWritten())
                && Objects.equals(bytesTransferred(), other.bytesTransferred()) && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTaskExecutionResponse").add("TaskExecutionArn", taskExecutionArn())
                .add("Status", statusAsString()).add("Options", options()).add("Excludes", excludes())
                .add("Includes", includes()).add("StartTime", startTime())
                .add("EstimatedFilesToTransfer", estimatedFilesToTransfer())
                .add("EstimatedBytesToTransfer", estimatedBytesToTransfer()).add("FilesTransferred", filesTransferred())
                .add("BytesWritten", bytesWritten()).add("BytesTransferred", bytesTransferred()).add("Result", result()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskExecutionArn":
            return Optional.ofNullable(clazz.cast(taskExecutionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EstimatedFilesToTransfer":
            return Optional.ofNullable(clazz.cast(estimatedFilesToTransfer()));
        case "EstimatedBytesToTransfer":
            return Optional.ofNullable(clazz.cast(estimatedBytesToTransfer()));
        case "FilesTransferred":
            return Optional.ofNullable(clazz.cast(filesTransferred()));
        case "BytesWritten":
            return Optional.ofNullable(clazz.cast(bytesWritten()));
        case "BytesTransferred":
            return Optional.ofNullable(clazz.cast(bytesTransferred()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskExecutionResponse, T> g) {
        return obj -> g.apply((DescribeTaskExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTaskExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is
         * hierarchical and includes <code>TaskArn</code> for the task that was executed.
         * </p>
         * <p>
         * For example, a <code>TaskExecution</code> value with the ARN
         * <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
         * executed the task with the ARN
         * <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
         * </p>
         * 
         * @param taskExecutionArn
         *        The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code>
         *        is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
         *        <p>
         *        For example, a <code>TaskExecution</code> value with the ARN
         *        <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
         *        executed the task with the ARN
         *        <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionArn(String taskExecutionArn);

        /**
         * <p>
         * The status of the task execution.
         * </p>
         * <p>
         * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS
         * DataSync User Guide.</i>
         * </p>
         * 
         * @param status
         *        The status of the task execution. </p>
         *        <p>
         *        For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS
         *        DataSync User Guide.</i>
         * @see TaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task execution.
         * </p>
         * <p>
         * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS
         * DataSync User Guide.</i>
         * </p>
         * 
         * @param status
         *        The status of the task execution. </p>
         *        <p>
         *        For detailed information about task execution statuses, see Understanding Task Statuses in the <i>AWS
         *        DataSync User Guide.</i>
         * @see TaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskExecutionStatus
         */
        Builder status(TaskExecutionStatus status);

        /**
         * Sets the value of the Options property for this object.
         *
         * @param options
         *        The new value for the Options property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Options options);

        /**
         * Sets the value of the Options property for this object.
         *
         * This is a convenience that creates an instance of the {@link Options.Builder} avoiding the need to create one
         * manually via {@link Options#builder()}.
         *
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #options(Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Options)
         */
        default Builder options(Consumer<Options.Builder> options) {
            return options(Options.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single
         * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe),
         * for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that determines which files to exclude from a task. The list should contain a
         *        single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
         *        is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<FilterRule> excludes);

        /**
         * <p>
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single
         * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe),
         * for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that determines which files to exclude from a task. The list should contain a
         *        single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
         *        is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(FilterRule... excludes);

        /**
         * <p>
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single
         * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe),
         * for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilterRule>.Builder} avoiding the need to
         * create one manually via {@link List<FilterRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilterRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #excludes(List<FilterRule>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link List<FilterRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(List<FilterRule>)
         */
        Builder excludes(Consumer<FilterRule.Builder>... excludes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The list should contain a
         * single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a
         * pipe), for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param includes
         *        A list of filter rules that determines which files to include when running a task. The list should
         *        contain a single filter string that consists of the patterns to include. The patterns are delimited by
         *        "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The list should contain a
         * single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a
         * pipe), for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param includes
         *        A list of filter rules that determines which files to include when running a task. The list should
         *        contain a single filter string that consists of the patterns to include. The patterns are delimited by
         *        "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The list should contain a
         * single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a
         * pipe), for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilterRule>.Builder} avoiding the need to
         * create one manually via {@link List<FilterRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilterRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link List<FilterRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(List<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        /**
         * <p>
         * The time that the task execution was started.
         * </p>
         * 
         * @param startTime
         *        The time that the task execution was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The expected number of files that is to be transferred over the network. This value is calculated during the
         * PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred.
         * It's calculated based on comparing the content of the source and destination locations and finding the delta
         * that needs to be transferred.
         * </p>
         * 
         * @param estimatedFilesToTransfer
         *        The expected number of files that is to be transferred over the network. This value is calculated
         *        during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files
         *        to be transferred. It's calculated based on comparing the content of the source and destination
         *        locations and finding the delta that needs to be transferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedFilesToTransfer(Long estimatedFilesToTransfer);

        /**
         * <p>
         * The estimated physical number of bytes that is to be transferred over the network.
         * </p>
         * 
         * @param estimatedBytesToTransfer
         *        The estimated physical number of bytes that is to be transferred over the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedBytesToTransfer(Long estimatedBytesToTransfer);

        /**
         * <p>
         * The actual number of files that was transferred over the network. This value is calculated and updated on an
         * ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source
         * and sent over the network.
         * </p>
         * <p>
         * If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This
         * value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is
         * implementation-specific for some location types, so don't use it as an indicator for a correct file number or
         * to monitor your task execution.
         * </p>
         * 
         * @param filesTransferred
         *        The actual number of files that was transferred over the network. This value is calculated and updated
         *        on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read
         *        from the source and sent over the network. </p>
         *        <p>
         *        If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>
         *        . This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This
         *        element is implementation-specific for some location types, so don't use it as an indicator for a
         *        correct file number or to monitor your task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesTransferred(Long filesTransferred);

        /**
         * <p>
         * The number of logical bytes written to the destination AWS storage resource.
         * </p>
         * 
         * @param bytesWritten
         *        The number of logical bytes written to the destination AWS storage resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesWritten(Long bytesWritten);

        /**
         * <p>
         * The physical number of bytes transferred over the network.
         * </p>
         * 
         * @param bytesTransferred
         *        The physical number of bytes transferred over the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesTransferred(Long bytesTransferred);

        /**
         * <p>
         * The result of the task execution.
         * </p>
         * 
         * @param result
         *        The result of the task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(TaskExecutionResultDetail result);

        /**
         * <p>
         * The result of the task execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskExecutionResultDetail.Builder} avoiding the
         * need to create one manually via {@link TaskExecutionResultDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskExecutionResultDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #result(TaskExecutionResultDetail)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link TaskExecutionResultDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(TaskExecutionResultDetail)
         */
        default Builder result(Consumer<TaskExecutionResultDetail.Builder> result) {
            return result(TaskExecutionResultDetail.builder().applyMutation(result).build());
        }
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String taskExecutionArn;

        private String status;

        private Options options;

        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Long estimatedFilesToTransfer;

        private Long estimatedBytesToTransfer;

        private Long filesTransferred;

        private Long bytesWritten;

        private Long bytesTransferred;

        private TaskExecutionResultDetail result;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskExecutionResponse model) {
            super(model);
            taskExecutionArn(model.taskExecutionArn);
            status(model.status);
            options(model.options);
            excludes(model.excludes);
            includes(model.includes);
            startTime(model.startTime);
            estimatedFilesToTransfer(model.estimatedFilesToTransfer);
            estimatedBytesToTransfer(model.estimatedBytesToTransfer);
            filesTransferred(model.filesTransferred);
            bytesWritten(model.bytesWritten);
            bytesTransferred(model.bytesTransferred);
            result(model.result);
        }

        public final String getTaskExecutionArn() {
            return taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<FilterRule.Builder> getExcludes() {
            return excludes != null ? excludes.stream().map(FilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        public final Collection<FilterRule.Builder> getIncludes() {
            return includes != null ? includes.stream().map(FilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Long getEstimatedFilesToTransfer() {
            return estimatedFilesToTransfer;
        }

        @Override
        public final Builder estimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
            return this;
        }

        public final void setEstimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
        }

        public final Long getEstimatedBytesToTransfer() {
            return estimatedBytesToTransfer;
        }

        @Override
        public final Builder estimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
            return this;
        }

        public final void setEstimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
        }

        public final Long getFilesTransferred() {
            return filesTransferred;
        }

        @Override
        public final Builder filesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
            return this;
        }

        public final void setFilesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
        }

        public final Long getBytesWritten() {
            return bytesWritten;
        }

        @Override
        public final Builder bytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public final void setBytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        public final Long getBytesTransferred() {
            return bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        public final TaskExecutionResultDetail.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        @Override
        public final Builder result(TaskExecutionResultDetail result) {
            this.result = result;
            return this;
        }

        public final void setResult(TaskExecutionResultDetail.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public DescribeTaskExecutionResponse build() {
            return new DescribeTaskExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
