/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationFsxWindowsResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationFsxWindowsResponse.Builder, DescribeLocationFsxWindowsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationFsxWindowsResponse::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationFsxWindowsResponse::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLocationFsxWindowsResponse::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeLocationFsxWindowsResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationFsxWindowsResponse::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationFsxWindowsResponse::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, SECURITY_GROUP_ARNS_FIELD, CREATION_TIME_FIELD, USER_FIELD, DOMAIN_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final List<String> securityGroupArns;

    private final Instant creationTime;

    private final String user;

    private final String domain;

    private DescribeLocationFsxWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.securityGroupArns = builder.securityGroupArns;
        this.creationTime = builder.creationTime;
        this.user = builder.user;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the FSx for Windows location that was described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the FSx for Windows location that was described.
     */
    public String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the FSx for Windows location that was described.
     * </p>
     * 
     * @return The URL of the FSx for Windows location that was described.
     */
    public String locationUri() {
        return locationUri;
    }

    /**
     * Returns true if the SecurityGroupArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupArns() {
        return securityGroupArns != null && !(securityGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows file
     *         system.
     */
    public List<String> securityGroupArns() {
        return securityGroupArns;
    }

    /**
     * <p>
     * The time that the FSx for Windows location was created.
     * </p>
     * 
     * @return The time that the FSx for Windows location was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The user who has the permissions to access files and folders in the FSx for Windows file system.
     * </p>
     * 
     * @return The user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    public String user() {
        return user;
    }

    /**
     * <p>
     * The name of the Windows domain that the FSx for Windows server belongs to.
     * </p>
     * 
     * @return The name of the Windows domain that the FSx for Windows server belongs to.
     */
    public String domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupArns());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationFsxWindowsResponse)) {
            return false;
        }
        DescribeLocationFsxWindowsResponse other = (DescribeLocationFsxWindowsResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(securityGroupArns(), other.securityGroupArns())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(user(), other.user())
                && Objects.equals(domain(), other.domain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLocationFsxWindowsResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("SecurityGroupArns", securityGroupArns())
                .add("CreationTime", creationTime()).add("User", user()).add("Domain", domain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationFsxWindowsResponse, T> g) {
        return obj -> g.apply((DescribeLocationFsxWindowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocationFsxWindowsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the FSx for Windows location that was described.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the FSx for Windows location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the FSx for Windows location that was described.
         * </p>
         * 
         * @param locationUri
         *        The URL of the FSx for Windows location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows file
         * system.
         * </p>
         * 
         * @param securityGroupArns
         *        The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows
         *        file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows file
         * system.
         * </p>
         * 
         * @param securityGroupArns
         *        The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows
         *        file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);

        /**
         * <p>
         * The time that the FSx for Windows location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the FSx for Windows location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The user who has the permissions to access files and folders in the FSx for Windows file system.
         * </p>
         * 
         * @param user
         *        The user who has the permissions to access files and folders in the FSx for Windows file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The name of the Windows domain that the FSx for Windows server belongs to.
         * </p>
         * 
         * @param domain
         *        The name of the Windows domain that the FSx for Windows server belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private String user;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationFsxWindowsResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            securityGroupArns(model.securityGroupArns);
            creationTime(model.creationTime);
            user(model.user);
            domain(model.domain);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final Collection<String> getSecurityGroupArns() {
            return securityGroupArns;
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getUser() {
            return user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public DescribeLocationFsxWindowsResponse build() {
            return new DescribeLocationFsxWindowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
