/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeLocationS3Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationS3Response extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationS3Response.Builder, DescribeLocationS3Response> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationS3Response::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationS3Response::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> S3_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocationS3Response::s3StorageClassAsString)).setter(setter(Builder::s3StorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageClass").build()).build();

    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeLocationS3Response::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeLocationS3Response::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, S3_STORAGE_CLASS_FIELD, S3_CONFIG_FIELD, CREATION_TIME_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final String s3StorageClass;

    private final S3Config s3Config;

    private final Instant creationTime;

    private DescribeLocationS3Response(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.s3StorageClass = builder.s3StorageClass;
        this.s3Config = builder.s3Config;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon S3 bucket location.
     */
    public String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the Amazon S3 location that was described.
     * </p>
     * 
     * @return The URL of the Amazon S3 location that was described.
     */
    public String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     * destination. For more information about S3 storage classes, see <a
     * href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon Simple Storage
     * Service Developer Guide</i>. Some storage classes have behaviors that can affect your S3 storage cost. For
     * detailed information, see <a>using-storage-classes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3StorageClass}
     * will return {@link S3StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3StorageClassAsString}.
     * </p>
     * 
     * @return The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     *         destination. For more information about S3 storage classes, see <a
     *         href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon Simple
     *         Storage Service Developer Guide</i>. Some storage classes have behaviors that can affect your S3 storage
     *         cost. For detailed information, see <a>using-storage-classes</a>.
     * @see S3StorageClass
     */
    public S3StorageClass s3StorageClass() {
        return S3StorageClass.fromValue(s3StorageClass);
    }

    /**
     * <p>
     * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     * destination. For more information about S3 storage classes, see <a
     * href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon Simple Storage
     * Service Developer Guide</i>. Some storage classes have behaviors that can affect your S3 storage cost. For
     * detailed information, see <a>using-storage-classes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3StorageClass}
     * will return {@link S3StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3StorageClassAsString}.
     * </p>
     * 
     * @return The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     *         destination. For more information about S3 storage classes, see <a
     *         href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon Simple
     *         Storage Service Developer Guide</i>. Some storage classes have behaviors that can affect your S3 storage
     *         cost. For detailed information, see <a>using-storage-classes</a>.
     * @see S3StorageClass
     */
    public String s3StorageClassAsString() {
        return s3StorageClass;
    }

    /**
     * Returns the value of the S3Config property for this object.
     * 
     * @return The value of the S3Config property for this object.
     */
    public S3Config s3Config() {
        return s3Config;
    }

    /**
     * <p>
     * The time that the Amazon S3 bucket location was created.
     * </p>
     * 
     * @return The time that the Amazon S3 bucket location was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(s3StorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationS3Response)) {
            return false;
        }
        DescribeLocationS3Response other = (DescribeLocationS3Response) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(s3StorageClassAsString(), other.s3StorageClassAsString())
                && Objects.equals(s3Config(), other.s3Config()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLocationS3Response").add("LocationArn", locationArn()).add("LocationUri", locationUri())
                .add("S3StorageClass", s3StorageClassAsString()).add("S3Config", s3Config()).add("CreationTime", creationTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "S3StorageClass":
            return Optional.ofNullable(clazz.cast(s3StorageClassAsString()));
        case "S3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationS3Response, T> g) {
        return obj -> g.apply((DescribeLocationS3Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationS3Response> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket location.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the Amazon S3 bucket location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the Amazon S3 location that was described.
         * </p>
         * 
         * @param locationUri
         *        The URL of the Amazon S3 location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         * destination. For more information about S3 storage classes, see <a
         * href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon Simple
         * Storage Service Developer Guide</i>. Some storage classes have behaviors that can affect your S3 storage
         * cost. For detailed information, see <a>using-storage-classes</a>.
         * </p>
         * 
         * @param s3StorageClass
         *        The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         *        destination. For more information about S3 storage classes, see <a
         *        href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon
         *        Simple Storage Service Developer Guide</i>. Some storage classes have behaviors that can affect your
         *        S3 storage cost. For detailed information, see <a>using-storage-classes</a>.
         * @see S3StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3StorageClass
         */
        Builder s3StorageClass(String s3StorageClass);

        /**
         * <p>
         * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         * destination. For more information about S3 storage classes, see <a
         * href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon Simple
         * Storage Service Developer Guide</i>. Some storage classes have behaviors that can affect your S3 storage
         * cost. For detailed information, see <a>using-storage-classes</a>.
         * </p>
         * 
         * @param s3StorageClass
         *        The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         *        destination. For more information about S3 storage classes, see <a
         *        href="https://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> in the <i>Amazon
         *        Simple Storage Service Developer Guide</i>. Some storage classes have behaviors that can affect your
         *        S3 storage cost. For detailed information, see <a>using-storage-classes</a>.
         * @see S3StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3StorageClass
         */
        Builder s3StorageClass(S3StorageClass s3StorageClass);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * @param s3Config
         *        The new value for the S3Config property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Config.Builder} avoiding the need to create
         * one manually via {@link S3Config#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        /**
         * <p>
         * The time that the Amazon S3 bucket location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the Amazon S3 bucket location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private String s3StorageClass;

        private S3Config s3Config;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationS3Response model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            s3StorageClass(model.s3StorageClass);
            s3Config(model.s3Config);
            creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final String getS3StorageClass() {
            return s3StorageClass;
        }

        @Override
        public final Builder s3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        @Override
        public final Builder s3StorageClass(S3StorageClass s3StorageClass) {
            this.s3StorageClass(s3StorageClass == null ? null : s3StorageClass.toString());
            return this;
        }

        public final void setS3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeLocationS3Response build() {
            return new DescribeLocationS3Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
