/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateLocationObjectStorageRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationObjectStorageRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationObjectStorageRequest.Builder, CreateLocationObjectStorageRequest> {
    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageRequest::serverHostname)).setter(setter(Builder::serverHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()).build();

    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateLocationObjectStorageRequest::serverPort)).setter(setter(Builder::serverPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()).build();

    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageRequest::serverProtocolAsString)).setter(setter(Builder::serverProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageRequest::subdirectory)).setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageRequest::accessKey)).setter(setter(Builder::accessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()).build();

    private static final SdkField<String> SECRET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageRequest::secretKey)).setter(setter(Builder::secretKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretKey").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateLocationObjectStorageRequest::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .getter(getter(CreateLocationObjectStorageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_HOSTNAME_FIELD,
            SERVER_PORT_FIELD, SERVER_PROTOCOL_FIELD, SUBDIRECTORY_FIELD, BUCKET_NAME_FIELD, ACCESS_KEY_FIELD, SECRET_KEY_FIELD,
            AGENT_ARNS_FIELD, TAGS_FIELD));

    private final String serverHostname;

    private final Integer serverPort;

    private final String serverProtocol;

    private final String subdirectory;

    private final String bucketName;

    private final String accessKey;

    private final String secretKey;

    private final List<String> agentArns;

    private final List<TagListEntry> tags;

    private CreateLocationObjectStorageRequest(BuilderImpl builder) {
        super(builder);
        this.serverHostname = builder.serverHostname;
        this.serverPort = builder.serverPort;
        this.serverProtocol = builder.serverProtocol;
        this.subdirectory = builder.subdirectory;
        this.bucketName = builder.bucketName;
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.agentArns = builder.agentArns;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS)
     * name of the object storage server. An agent uses this host name to mount the object storage server in a network.
     * </p>
     * 
     * @return The name of the self-managed object storage server. This value is the IP address or Domain Name Service
     *         (DNS) name of the object storage server. An agent uses this host name to mount the object storage server
     *         in a network.
     */
    public String serverHostname() {
        return serverHostname;
    }

    /**
     * <p>
     * The port that your self-managed object storage server accepts inbound network traffic on. The server port is set
     * by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage
     * server requires one.
     * </p>
     * 
     * @return The port that your self-managed object storage server accepts inbound network traffic on. The server port
     *         is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed
     *         object storage server requires one.
     */
    public Integer serverPort() {
        return serverPort;
    }

    /**
     * <p>
     * The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ObjectStorageServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
     * @see ObjectStorageServerProtocol
     */
    public ObjectStorageServerProtocol serverProtocol() {
        return ObjectStorageServerProtocol.fromValue(serverProtocol);
    }

    /**
     * <p>
     * The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ObjectStorageServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
     * @see ObjectStorageServerProtocol
     */
    public String serverProtocolAsString() {
        return serverProtocol;
    }

    /**
     * <p>
     * The subdirectory in the self-managed object storage server that is used to read data from.
     * </p>
     * 
     * @return The subdirectory in the self-managed object storage server that is used to read data from.
     */
    public String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * The bucket on the self-managed object storage server that is used to read data from.
     * </p>
     * 
     * @return The bucket on the self-managed object storage server that is used to read data from.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * Optional. The access key is used if credentials are required to access the self-managed object storage server.
     * </p>
     * 
     * @return Optional. The access key is used if credentials are required to access the self-managed object storage
     *         server.
     */
    public String accessKey() {
        return accessKey;
    }

    /**
     * <p>
     * Optional. The secret key is used if credentials are required to access the self-managed object storage server.
     * </p>
     * 
     * @return Optional. The secret key is used if credentials are required to access the self-managed object storage
     *         server.
     */
    public String secretKey() {
        return secretKey;
    }

    /**
     * Returns true if the AgentArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgentArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
     *         location.
     */
    public List<String> agentArns() {
        return agentArns;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
     * string. We recommend using tags to name your resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair that represents the tag that you want to add to the location. The value can be an
     *         empty string. We recommend using tags to name your resources.
     */
    public List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(serverPort());
        hashCode = 31 * hashCode + Objects.hashCode(serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(secretKey());
        hashCode = 31 * hashCode + Objects.hashCode(agentArns());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationObjectStorageRequest)) {
            return false;
        }
        CreateLocationObjectStorageRequest other = (CreateLocationObjectStorageRequest) obj;
        return Objects.equals(serverHostname(), other.serverHostname()) && Objects.equals(serverPort(), other.serverPort())
                && Objects.equals(serverProtocolAsString(), other.serverProtocolAsString())
                && Objects.equals(subdirectory(), other.subdirectory()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(accessKey(), other.accessKey()) && Objects.equals(secretKey(), other.secretKey())
                && Objects.equals(agentArns(), other.agentArns()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLocationObjectStorageRequest").add("ServerHostname", serverHostname())
                .add("ServerPort", serverPort()).add("ServerProtocol", serverProtocolAsString())
                .add("Subdirectory", subdirectory()).add("BucketName", bucketName()).add("AccessKey", accessKey())
                .add("SecretKey", secretKey() == null ? null : "*** Sensitive Data Redacted ***").add("AgentArns", agentArns())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerHostname":
            return Optional.ofNullable(clazz.cast(serverHostname()));
        case "ServerPort":
            return Optional.ofNullable(clazz.cast(serverPort()));
        case "ServerProtocol":
            return Optional.ofNullable(clazz.cast(serverProtocolAsString()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "AccessKey":
            return Optional.ofNullable(clazz.cast(accessKey()));
        case "SecretKey":
            return Optional.ofNullable(clazz.cast(secretKey()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationObjectStorageRequest, T> g) {
        return obj -> g.apply((CreateLocationObjectStorageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLocationObjectStorageRequest> {
        /**
         * <p>
         * The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS)
         * name of the object storage server. An agent uses this host name to mount the object storage server in a
         * network.
         * </p>
         * 
         * @param serverHostname
         *        The name of the self-managed object storage server. This value is the IP address or Domain Name
         *        Service (DNS) name of the object storage server. An agent uses this host name to mount the object
         *        storage server in a network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverHostname(String serverHostname);

        /**
         * <p>
         * The port that your self-managed object storage server accepts inbound network traffic on. The server port is
         * set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object
         * storage server requires one.
         * </p>
         * 
         * @param serverPort
         *        The port that your self-managed object storage server accepts inbound network traffic on. The server
         *        port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your
         *        self-managed object storage server requires one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPort(Integer serverPort);

        /**
         * <p>
         * The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
         * </p>
         * 
         * @param serverProtocol
         *        The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
         * @see ObjectStorageServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageServerProtocol
         */
        Builder serverProtocol(String serverProtocol);

        /**
         * <p>
         * The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
         * </p>
         * 
         * @param serverProtocol
         *        The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.
         * @see ObjectStorageServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageServerProtocol
         */
        Builder serverProtocol(ObjectStorageServerProtocol serverProtocol);

        /**
         * <p>
         * The subdirectory in the self-managed object storage server that is used to read data from.
         * </p>
         * 
         * @param subdirectory
         *        The subdirectory in the self-managed object storage server that is used to read data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * The bucket on the self-managed object storage server that is used to read data from.
         * </p>
         * 
         * @param bucketName
         *        The bucket on the self-managed object storage server that is used to read data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * Optional. The access key is used if credentials are required to access the self-managed object storage
         * server.
         * </p>
         * 
         * @param accessKey
         *        Optional. The access key is used if credentials are required to access the self-managed object storage
         *        server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKey(String accessKey);

        /**
         * <p>
         * Optional. The secret key is used if credentials are required to access the self-managed object storage
         * server.
         * </p>
         * 
         * @param secretKey
         *        Optional. The secret key is used if credentials are required to access the self-managed object storage
         *        server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretKey(String secretKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
         * </p>
         * 
         * @param agentArns
         *        The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
         * </p>
         * 
         * @param agentArns
         *        The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
         * string. We recommend using tags to name your resources.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents the tag that you want to add to the location. The value can be an
         *        empty string. We recommend using tags to name your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
         * string. We recommend using tags to name your resources.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents the tag that you want to add to the location. The value can be an
         *        empty string. We recommend using tags to name your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
         * string. We recommend using tags to name your resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagListEntry>.Builder} avoiding the need to
         * create one manually via {@link List<TagListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String serverHostname;

        private Integer serverPort;

        private String serverProtocol;

        private String subdirectory;

        private String bucketName;

        private String accessKey;

        private String secretKey;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationObjectStorageRequest model) {
            super(model);
            serverHostname(model.serverHostname);
            serverPort(model.serverPort);
            serverProtocol(model.serverProtocol);
            subdirectory(model.subdirectory);
            bucketName(model.bucketName);
            accessKey(model.accessKey);
            secretKey(model.secretKey);
            agentArns(model.agentArns);
            tags(model.tags);
        }

        public final String getServerHostname() {
            return serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        public final Integer getServerPort() {
            return serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        public final String getServerProtocol() {
            return serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(ObjectStorageServerProtocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getAccessKey() {
            return accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public final String getSecretKey() {
            return secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public final Collection<String> getAgentArns() {
            return agentArns;
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        public final Collection<TagListEntry.Builder> getTags() {
            return tags != null ? tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationObjectStorageRequest build() {
            return new CreateLocationObjectStorageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
