/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateLocationObjectStorageResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationObjectStorageResponse extends DataSyncResponse implements
        ToCopyableBuilder<CreateLocationObjectStorageResponse.Builder, CreateLocationObjectStorageResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationObjectStorageResponse::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD));

    private final String locationArn;

    private CreateLocationObjectStorageResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
     *         location.
     */
    public String locationArn() {
        return locationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationObjectStorageResponse)) {
            return false;
        }
        CreateLocationObjectStorageResponse other = (CreateLocationObjectStorageResponse) obj;
        return Objects.equals(locationArn(), other.locationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLocationObjectStorageResponse").add("LocationArn", locationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationObjectStorageResponse, T> g) {
        return obj -> g.apply((CreateLocationObjectStorageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLocationObjectStorageResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationObjectStorageResponse model) {
            super(model);
            locationArn(model.locationArn);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public CreateLocationObjectStorageResponse build() {
            return new CreateLocationObjectStorageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
