/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateAgentResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentResponse extends DataSyncResponse implements
        ToCopyableBuilder<CreateAgentResponse.Builder, CreateAgentResponse> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentArn").getter(getter(CreateAgentResponse::agentArn)).setter(setter(Builder::agentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD));

    private final String agentArn;

    private CreateAgentResponse(BuilderImpl builder) {
        super(builder);
        this.agentArn = builder.agentArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of agents
     * for your account and AWS Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list
     *         of agents for your account and AWS Region.
     */
    public final String agentArn() {
        return agentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentResponse)) {
            return false;
        }
        CreateAgentResponse other = (CreateAgentResponse) obj;
        return Objects.equals(agentArn(), other.agentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentResponse").add("AgentArn", agentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentArn":
            return Optional.ofNullable(clazz.cast(agentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentResponse, T> g) {
        return obj -> g.apply((CreateAgentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAgentResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of
         * agents for your account and AWS Region.
         * </p>
         * 
         * @param agentArn
         *        The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a
         *        list of agents for your account and AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArn(String agentArn);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String agentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentResponse model) {
            super(model);
            agentArn(model.agentArn);
        }

        public final String getAgentArn() {
            return agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public CreateAgentResponse build() {
            return new CreateAgentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
