/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListTasksResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTasksResponse extends DataSyncResponse implements
        ToCopyableBuilder<ListTasksResponse.Builder, ListTasksResponse> {
    private static final SdkField<List<TaskListEntry>> TASKS_FIELD = SdkField
            .<List<TaskListEntry>> builder(MarshallingType.LIST)
            .memberName("Tasks")
            .getter(getter(ListTasksResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TaskListEntry> tasks;

    private final String nextToken;

    private ListTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Tasks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the tasks that are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all the tasks that are returned.
     */
    public final List<TaskListEntry> tasks() {
        return tasks;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin returning the next list of tasks.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin returning the next list of tasks.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTasksResponse)) {
            return false;
        }
        ListTasksResponse other = (ListTasksResponse) obj;
        return hasTasks() == other.hasTasks() && Objects.equals(tasks(), other.tasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTasksResponse").add("Tasks", hasTasks() ? tasks() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTasksResponse, T> g) {
        return obj -> g.apply((ListTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTasksResponse> {
        /**
         * <p>
         * A list of all the tasks that are returned.
         * </p>
         * 
         * @param tasks
         *        A list of all the tasks that are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<TaskListEntry> tasks);

        /**
         * <p>
         * A list of all the tasks that are returned.
         * </p>
         * 
         * @param tasks
         *        A list of all the tasks that are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(TaskListEntry... tasks);

        /**
         * <p>
         * A list of all the tasks that are returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TaskListEntry>.Builder} avoiding the need
         * to create one manually via {@link List<TaskListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaskListEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #tasks(List<TaskListEntry>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on {@link List<TaskListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(List<TaskListEntry>)
         */
        Builder tasks(Consumer<TaskListEntry.Builder>... tasks);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin returning the next list of tasks.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates the position at which to begin returning the next list of tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private List<TaskListEntry> tasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTasksResponse model) {
            super(model);
            tasks(model.tasks);
            nextToken(model.nextToken);
        }

        public final List<TaskListEntry.Builder> getTasks() {
            List<TaskListEntry.Builder> result = TaskListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tasks(Collection<TaskListEntry> tasks) {
            this.tasks = TaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(TaskListEntry... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<TaskListEntry.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> TaskListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<TaskListEntry.BuilderImpl> tasks) {
            this.tasks = TaskListCopier.copyFromBuilder(tasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTasksResponse build() {
            return new ListTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
