/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateAgentRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateAgentRequest.Builder, CreateAgentRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationKey").getter(getter(CreateAgentRequest::activationKey)).setter(setter(Builder::activationKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()).build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentName").getter(getter(CreateAgentRequest::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentName").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAgentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(CreateAgentRequest::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetArns")
            .getter(getter(CreateAgentRequest::subnetArns))
            .setter(setter(Builder::subnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupArns")
            .getter(getter(CreateAgentRequest::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD,
            AGENT_NAME_FIELD, TAGS_FIELD, VPC_ENDPOINT_ID_FIELD, SUBNET_ARNS_FIELD, SECURITY_GROUP_ARNS_FIELD));

    private final String activationKey;

    private final String agentName;

    private final List<TagListEntry> tags;

    private final String vpcEndpointId;

    private final List<String> subnetArns;

    private final List<String> securityGroupArns;

    private CreateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.agentName = builder.agentName;
        this.tags = builder.tags;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.subnetArns = builder.subnetArns;
        this.securityGroupArns = builder.securityGroupArns;
    }

    /**
     * <p>
     * Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects
     * that enable you to get the agent IP address (port 80). Alternatively, you can get it from the AWS DataSync
     * console.
     * </p>
     * <p>
     * The redirect URL returned in the response provides you the activation key for your agent in the query string
     * parameter <code>activationKey</code>. It might also include other activation-related parameters; however, these
     * are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.
     * </p>
     * <p>
     * For more information, see Activating an Agent in the <i>AWS DataSync User Guide.</i>
     * </p>
     * 
     * @return Your agent activation key. You can get the activation key either by sending an HTTP GET request with
     *         redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the
     *         AWS DataSync console.</p>
     *         <p>
     *         The redirect URL returned in the response provides you the activation key for your agent in the query
     *         string parameter <code>activationKey</code>. It might also include other activation-related parameters;
     *         however, these are merely defaults. The arguments you pass to this API call determine the actual
     *         configuration of your agent.
     *         </p>
     *         <p>
     *         For more information, see Activating an Agent in the <i>AWS DataSync User Guide.</i>
     */
    public final String activationKey() {
        return activationKey;
    }

    /**
     * <p>
     * The name you configured for your agent. This value is a text reference that is used to identify the agent in the
     * console.
     * </p>
     * 
     * @return The name you configured for your agent. This value is a text reference that is used to identify the agent
     *         in the console.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty
     * string. This value helps you manage, filter, and search for your agents.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair that represents the tag that you want to associate with the agent. The value can be an
     *         empty string. This value helps you manage, filter, and search for your agents.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @.
     *         </p>
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC
     * endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service">Creating a
     * VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.
     * </p>
     * <p>
     * VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.
     * </p>
     * 
     * @return The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side
     *         VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service"
     *         >Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>
     *         <p>
     *         VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * Returns true if the SubnetArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnetArns() {
        return subnetArns != null && !(subnetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each
     * data transfer task. The agent that runs a task must be private. When you start a task that is associated with an
     * agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this
     * case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the
     * agent must be able to route to all these four network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces
     *         for each data transfer task. The agent that runs a task must be private. When you start a task that is
     *         associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the
     *         task is also private. In this case, DataSync creates four network interfaces for each task in your
     *         subnet. For a data transfer to work, the agent must be able to route to all these four network
     *         interfaces.
     */
    public final List<String> subnetArns() {
        return subnetArns;
    }

    /**
     * Returns true if the SecurityGroupArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupArns() {
        return securityGroupArns != null && !(securityGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the security groups used to protect your data transfer task subnets. See
     * <a>CreateAgentRequest$SubnetArns</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARNs of the security groups used to protect your data transfer task subnets. See
     *         <a>CreateAgentRequest$SubnetArns</a>.
     */
    public final List<String> securityGroupArns() {
        return securityGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetArns() ? subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupArns() ? securityGroupArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRequest)) {
            return false;
        }
        CreateAgentRequest other = (CreateAgentRequest) obj;
        return Objects.equals(activationKey(), other.activationKey()) && Objects.equals(agentName(), other.agentName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId()) && hasSubnetArns() == other.hasSubnetArns()
                && Objects.equals(subnetArns(), other.subnetArns()) && hasSecurityGroupArns() == other.hasSecurityGroupArns()
                && Objects.equals(securityGroupArns(), other.securityGroupArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentRequest").add("ActivationKey", activationKey()).add("AgentName", agentName())
                .add("Tags", hasTags() ? tags() : null).add("VpcEndpointId", vpcEndpointId())
                .add("SubnetArns", hasSubnetArns() ? subnetArns() : null)
                .add("SecurityGroupArns", hasSecurityGroupArns() ? securityGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationKey":
            return Optional.ofNullable(clazz.cast(activationKey()));
        case "AgentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "SubnetArns":
            return Optional.ofNullable(clazz.cast(subnetArns()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRequest, T> g) {
        return obj -> g.apply((CreateAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAgentRequest> {
        /**
         * <p>
         * Your agent activation key. You can get the activation key either by sending an HTTP GET request with
         * redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the AWS
         * DataSync console.
         * </p>
         * <p>
         * The redirect URL returned in the response provides you the activation key for your agent in the query string
         * parameter <code>activationKey</code>. It might also include other activation-related parameters; however,
         * these are merely defaults. The arguments you pass to this API call determine the actual configuration of your
         * agent.
         * </p>
         * <p>
         * For more information, see Activating an Agent in the <i>AWS DataSync User Guide.</i>
         * </p>
         * 
         * @param activationKey
         *        Your agent activation key. You can get the activation key either by sending an HTTP GET request with
         *        redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from
         *        the AWS DataSync console.</p>
         *        <p>
         *        The redirect URL returned in the response provides you the activation key for your agent in the query
         *        string parameter <code>activationKey</code>. It might also include other activation-related
         *        parameters; however, these are merely defaults. The arguments you pass to this API call determine the
         *        actual configuration of your agent.
         *        </p>
         *        <p>
         *        For more information, see Activating an Agent in the <i>AWS DataSync User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationKey(String activationKey);

        /**
         * <p>
         * The name you configured for your agent. This value is a text reference that is used to identify the agent in
         * the console.
         * </p>
         * 
         * @param agentName
         *        The name you configured for your agent. This value is a text reference that is used to identify the
         *        agent in the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to associate with the agent. The value can be an
         * empty string. This value helps you manage, filter, and search for your agents.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @.
         * </p>
         * </note>
         * 
         * @param tags
         *        The key-value pair that represents the tag that you want to associate with the agent. The value can be
         *        an empty string. This value helps you manage, filter, and search for your agents.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to associate with the agent. The value can be an
         * empty string. This value helps you manage, filter, and search for your agents.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @.
         * </p>
         * </note>
         * 
         * @param tags
         *        The key-value pair that represents the tag that you want to associate with the agent. The value can be
         *        an empty string. This value helps you manage, filter, and search for your agents.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to associate with the agent. The value can be an
         * empty string. This value helps you manage, filter, and search for your agents.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<TagListEntry>.Builder} avoiding the
         * need to create one manually via {@link List<TagListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC
         * endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service"
         * >Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.
         * </p>
         * <p>
         * VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the
         *        client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see
         *        <a href=
         *        "https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service"
         *        >Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>
         *        <p>
         *        VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for
         * each data transfer task. The agent that runs a task must be private. When you start a task that is associated
         * with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also
         * private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data
         * transfer to work, the agent must be able to route to all these four network interfaces.
         * </p>
         * 
         * @param subnetArns
         *        The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network
         *        interfaces for each data transfer task. The agent that runs a task must be private. When you start a
         *        task that is associated with an agent created in a VPC, or one that has access to an IP address in a
         *        VPC, then the task is also private. In this case, DataSync creates four network interfaces for each
         *        task in your subnet. For a data transfer to work, the agent must be able to route to all these four
         *        network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(Collection<String> subnetArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for
         * each data transfer task. The agent that runs a task must be private. When you start a task that is associated
         * with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also
         * private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data
         * transfer to work, the agent must be able to route to all these four network interfaces.
         * </p>
         * 
         * @param subnetArns
         *        The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network
         *        interfaces for each data transfer task. The agent that runs a task must be private. When you start a
         *        task that is associated with an agent created in a VPC, or one that has access to an IP address in a
         *        VPC, then the task is also private. In this case, DataSync creates four network interfaces for each
         *        task in your subnet. For a data transfer to work, the agent must be able to route to all these four
         *        network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(String... subnetArns);

        /**
         * <p>
         * The ARNs of the security groups used to protect your data transfer task subnets. See
         * <a>CreateAgentRequest$SubnetArns</a>.
         * </p>
         * 
         * @param securityGroupArns
         *        The ARNs of the security groups used to protect your data transfer task subnets. See
         *        <a>CreateAgentRequest$SubnetArns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * <p>
         * The ARNs of the security groups used to protect your data transfer task subnets. See
         * <a>CreateAgentRequest$SubnetArns</a>.
         * </p>
         * 
         * @param securityGroupArns
         *        The ARNs of the security groups used to protect your data transfer task subnets. See
         *        <a>CreateAgentRequest$SubnetArns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String activationKey;

        private String agentName;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcEndpointId;

        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRequest model) {
            super(model);
            activationKey(model.activationKey);
            agentName(model.agentName);
            tags(model.tags);
            vpcEndpointId(model.vpcEndpointId);
            subnetArns(model.subnetArns);
            securityGroupArns(model.securityGroupArns);
        }

        public final String getActivationKey() {
            return activationKey;
        }

        @Override
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        public final String getAgentName() {
            return agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final Collection<String> getSubnetArns() {
            if (subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetArns;
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String... subnetArns) {
            subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
        }

        public final Collection<String> getSecurityGroupArns() {
            if (securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupArns;
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRequest build() {
            return new CreateAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
