/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages the file system's namespace. The
 * NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the
 * information to map blocks of data to the DataNodes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HdfsNameNode implements SdkPojo, Serializable, ToCopyableBuilder<HdfsNameNode.Builder, HdfsNameNode> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(HdfsNameNode::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(HdfsNameNode::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private final Integer port;

    private HdfsNameNode(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
    }

    /**
     * <p>
     * The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name
     * of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the
     * network.
     * </p>
     * 
     * @return The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service
     *         (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with
     *         the NameNode in the network.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The port that the NameNode uses to listen to client requests.
     * </p>
     * 
     * @return The port that the NameNode uses to listen to client requests.
     */
    public final Integer port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HdfsNameNode)) {
            return false;
        }
        HdfsNameNode other = (HdfsNameNode) obj;
        return Objects.equals(hostname(), other.hostname()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HdfsNameNode").add("Hostname", hostname()).add("Port", port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HdfsNameNode, T> g) {
        return obj -> g.apply((HdfsNameNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HdfsNameNode> {
        /**
         * <p>
         * The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS)
         * name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the
         * NameNode in the network.
         * </p>
         * 
         * @param hostname
         *        The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service
         *        (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate
         *        with the NameNode in the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The port that the NameNode uses to listen to client requests.
         * </p>
         * 
         * @param port
         *        The port that the NameNode uses to listen to client requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(HdfsNameNode model) {
            hostname(model.hostname);
            port(model.port);
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        @Transient
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public HdfsNameNode build() {
            return new HdfsNameNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
