/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationFsxLustreRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationFsxLustreRequest.Builder, CreateLocationFsxLustreRequest> {
    private static final SdkField<String> FSX_FILESYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FsxFilesystemArn").getter(getter(CreateLocationFsxLustreRequest::fsxFilesystemArn))
            .setter(setter(Builder::fsxFilesystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxFilesystemArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupArns")
            .getter(getter(CreateLocationFsxLustreRequest::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(CreateLocationFsxLustreRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLocationFsxLustreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FSX_FILESYSTEM_ARN_FIELD,
            SECURITY_GROUP_ARNS_FIELD, SUBDIRECTORY_FIELD, TAGS_FIELD));

    private final String fsxFilesystemArn;

    private final List<String> securityGroupArns;

    private final String subdirectory;

    private final List<TagListEntry> tags;

    private CreateLocationFsxLustreRequest(BuilderImpl builder) {
        super(builder);
        this.fsxFilesystemArn = builder.fsxFilesystemArn;
        this.securityGroupArns = builder.securityGroupArns;
        this.subdirectory = builder.subdirectory;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the FSx for Lustre file system.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the FSx for Lustre file system.
     */
    public final String fsxFilesystemArn() {
        return fsxFilesystemArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupArns() {
        return securityGroupArns != null && !(securityGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file
     * system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre
     *         file system.
     */
    public final List<String> securityGroupArns() {
        return securityGroupArns;
    }

    /**
     * <p>
     * A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to read data
     * from the FSx for Lustre source location or write data to the FSx for Lustre destination.
     * </p>
     * 
     * @return A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to
     *         read data from the FSx for Lustre source location or write data to the FSx for Lustre destination.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string.
     * This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for
     * your location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
     *         string. This value helps you manage, filter, and search for your resources. We recommend that you create
     *         a name tag for your location.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fsxFilesystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupArns() ? securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationFsxLustreRequest)) {
            return false;
        }
        CreateLocationFsxLustreRequest other = (CreateLocationFsxLustreRequest) obj;
        return Objects.equals(fsxFilesystemArn(), other.fsxFilesystemArn())
                && hasSecurityGroupArns() == other.hasSecurityGroupArns()
                && Objects.equals(securityGroupArns(), other.securityGroupArns())
                && Objects.equals(subdirectory(), other.subdirectory()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocationFsxLustreRequest").add("FsxFilesystemArn", fsxFilesystemArn())
                .add("SecurityGroupArns", hasSecurityGroupArns() ? securityGroupArns() : null)
                .add("Subdirectory", subdirectory()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FsxFilesystemArn":
            return Optional.ofNullable(clazz.cast(fsxFilesystemArn()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationFsxLustreRequest, T> g) {
        return obj -> g.apply((CreateLocationFsxLustreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationFsxLustreRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the FSx for Lustre file system.
         * </p>
         * 
         * @param fsxFilesystemArn
         *        The Amazon Resource Name (ARN) for the FSx for Lustre file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsxFilesystemArn(String fsxFilesystemArn);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file
         * system.
         * </p>
         * 
         * @param securityGroupArns
         *        The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre
         *        file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file
         * system.
         * </p>
         * 
         * @param securityGroupArns
         *        The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre
         *        file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);

        /**
         * <p>
         * A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to read
         * data from the FSx for Lustre source location or write data to the FSx for Lustre destination.
         * </p>
         * 
         * @param subdirectory
         *        A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to
         *        read data from the FSx for Lustre source location or write data to the FSx for Lustre destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
         * string. This value helps you manage, filter, and search for your resources. We recommend that you create a
         * name tag for your location.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents a tag that you want to add to the resource. The value can be an
         *        empty string. This value helps you manage, filter, and search for your resources. We recommend that
         *        you create a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
         * string. This value helps you manage, filter, and search for your resources. We recommend that you create a
         * name tag for your location.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents a tag that you want to add to the resource. The value can be an
         *        empty string. This value helps you manage, filter, and search for your resources. We recommend that
         *        you create a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * The key-value pair that represents a tag that you want to add to the resource. The value can be an empty
         * string. This value helps you manage, filter, and search for your resources. We recommend that you create a
         * name tag for your location.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagListEntry>.Builder} avoiding the need to
         * create one manually via {@link List<TagListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String fsxFilesystemArn;

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private String subdirectory;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationFsxLustreRequest model) {
            super(model);
            fsxFilesystemArn(model.fsxFilesystemArn);
            securityGroupArns(model.securityGroupArns);
            subdirectory(model.subdirectory);
            tags(model.tags);
        }

        public final String getFsxFilesystemArn() {
            return fsxFilesystemArn;
        }

        public final void setFsxFilesystemArn(String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
        }

        @Override
        @Transient
        public final Builder fsxFilesystemArn(String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        @Transient
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        @Transient
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationFsxLustreRequest build() {
            return new CreateLocationFsxLustreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
