/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListLocationsRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLocationsRequest extends DataSyncRequest implements
        ToCopyableBuilder<ListLocationsRequest.Builder, ListLocationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLocationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLocationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<LocationFilter>> FILTERS_FIELD = SdkField
            .<List<LocationFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListLocationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<LocationFilter> filters;

    private ListLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The maximum number of locations to return.
     * </p>
     * 
     * @return The maximum number of locations to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin the next list of locations.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin the next list of locations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For example,
     * to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with filter name
     * <code>LocationType S3</code> and <code>Operator Equals</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For
     *         example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with
     *         filter name <code>LocationType S3</code> and <code>Operator Equals</code>.
     */
    public final List<LocationFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocationsRequest)) {
            return false;
        }
        ListLocationsRequest other = (ListLocationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLocationsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLocationsRequest, T> g) {
        return obj -> g.apply((ListLocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLocationsRequest> {
        /**
         * <p>
         * The maximum number of locations to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of locations to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin the next list of locations.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates the position at which to begin the next list of locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For
         * example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with
         * filter name <code>LocationType S3</code> and <code>Operator Equals</code>.
         * </p>
         * 
         * @param filters
         *        You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>.
         *        For example, to retrieve all tasks on a specific source location, you can use
         *        <code>ListLocations</code> with filter name <code>LocationType S3</code> and
         *        <code>Operator Equals</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<LocationFilter> filters);

        /**
         * <p>
         * You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For
         * example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with
         * filter name <code>LocationType S3</code> and <code>Operator Equals</code>.
         * </p>
         * 
         * @param filters
         *        You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>.
         *        For example, to retrieve all tasks on a specific source location, you can use
         *        <code>ListLocations</code> with filter name <code>LocationType S3</code> and
         *        <code>Operator Equals</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(LocationFilter... filters);

        /**
         * <p>
         * You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For
         * example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with
         * filter name <code>LocationType S3</code> and <code>Operator Equals</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LocationFilter>.Builder} avoiding
         * the need to create one manually via {@link List<LocationFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocationFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<LocationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<LocationFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<LocationFilter>)
         */
        Builder filters(Consumer<LocationFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<LocationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLocationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LocationFilter.Builder> getFilters() {
            List<LocationFilter.Builder> result = LocationFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<LocationFilter.BuilderImpl> filters) {
            this.filters = LocationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<LocationFilter> filters) {
            this.filters = LocationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(LocationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<LocationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> LocationFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLocationsRequest build() {
            return new ListLocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
