/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the Network File System (NFS) protocol that DataSync uses to access your Amazon FSx for OpenZFS file
 * system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FsxProtocolNfs implements SdkPojo, Serializable, ToCopyableBuilder<FsxProtocolNfs.Builder, FsxProtocolNfs> {
    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<NfsMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(FsxProtocolNfs::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(NfsMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NfsMountOptions mountOptions;

    private FsxProtocolNfs(BuilderImpl builder) {
        this.mountOptions = builder.mountOptions;
    }

    /**
     * Returns the value of the MountOptions property for this object.
     * 
     * @return The value of the MountOptions property for this object.
     */
    public final NfsMountOptions mountOptions() {
        return mountOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxProtocolNfs)) {
            return false;
        }
        FsxProtocolNfs other = (FsxProtocolNfs) obj;
        return Objects.equals(mountOptions(), other.mountOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FsxProtocolNfs").add("MountOptions", mountOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FsxProtocolNfs, T> g) {
        return obj -> g.apply((FsxProtocolNfs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FsxProtocolNfs> {
        /**
         * Sets the value of the MountOptions property for this object.
         *
         * @param mountOptions
         *        The new value for the MountOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(NfsMountOptions mountOptions);

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NfsMountOptions.Builder} avoiding the
         * need to create one manually via {@link NfsMountOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link NfsMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(NfsMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link NfsMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(NfsMountOptions)
         */
        default Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return mountOptions(NfsMountOptions.builder().applyMutation(mountOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NfsMountOptions mountOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxProtocolNfs model) {
            mountOptions(model.mountOptions);
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        @Override
        public FsxProtocolNfs build() {
            return new FsxProtocolNfs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
