/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the schedule you want your task to use for repeated executions. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for
 * Rules</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskSchedule implements SdkPojo, Serializable, ToCopyableBuilder<TaskSchedule.Builder, TaskSchedule> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(TaskSchedule::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private TaskSchedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
    }

    /**
     * <p>
     * A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination
     * location.
     * </p>
     * 
     * @return A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a
     *         destination location.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSchedule)) {
            return false;
        }
        TaskSchedule other = (TaskSchedule) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskSchedule").add("ScheduleExpression", scheduleExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskSchedule, T> g) {
        return obj -> g.apply((TaskSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskSchedule> {
        /**
         * <p>
         * A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a
         * destination location.
         * </p>
         * 
         * @param scheduleExpression
         *        A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a
         *        destination location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSchedule model) {
            scheduleExpression(model.scheduleExpression);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        @Transient
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        @Override
        public TaskSchedule build() {
            return new TaskSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
