/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your Amazon FSx for
 * NetApp ONTAP file system. For more information, see <a href=
 * "https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access"
 * >Accessing FSx for ONTAP file systems</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FsxProtocolSmb implements SdkPojo, Serializable, ToCopyableBuilder<FsxProtocolSmb.Builder, FsxProtocolSmb> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(FsxProtocolSmb::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<SmbMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<SmbMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(FsxProtocolSmb::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(SmbMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(FsxProtocolSmb::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(FsxProtocolSmb::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            MOUNT_OPTIONS_FIELD, PASSWORD_FIELD, USER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final SmbMountOptions mountOptions;

    private final String password;

    private final String user;

    private FsxProtocolSmb(BuilderImpl builder) {
        this.domain = builder.domain;
        this.mountOptions = builder.mountOptions;
        this.password = builder.password;
        this.user = builder.user;
    }

    /**
     * <p>
     * Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage virtual
     * machine (SVM) belongs to.
     * </p>
     * 
     * @return Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage
     *         virtual machine (SVM) belongs to.
     */
    public final String domain() {
        return domain;
    }

    /**
     * Returns the value of the MountOptions property for this object.
     * 
     * @return The value of the MountOptions property for this object.
     */
    public final SmbMountOptions mountOptions() {
        return mountOptions;
    }

    /**
     * <p>
     * Specifies the password of a user who has permission to access your SVM.
     * </p>
     * 
     * @return Specifies the password of a user who has permission to access your SVM.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * Specifies a user name that can mount the location and access the files, folders, and metadata that you need in
     * the SVM.
     * </p>
     * <p>
     * If you provide a user in your Active Directory, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you're using Directory Service for Microsoft Active Directory, the user must be a member of the Amazon Web
     * Services Delegated FSx Administrators group.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you're using a self-managed Active Directory, the user must be a member of either the Domain Admins group or a
     * custom group that you specified for file system administration when you created your file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Make sure that the user has the permissions it needs to copy the data you want:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SE_TCB_NAME</code>: Required to set object ownership and file metadata. With this privilege, you also can
     * copy NTFS discretionary access lists (DACLs).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SE_SECURITY_NAME</code>: May be needed to copy NTFS system access control lists (SACLs). This operation
     * specifically requires the Windows privilege, which is granted to members of the Domain Admins group. If you
     * configure your task to copy SACLs, make sure that the user has the required privileges. For information about
     * copying SACLs, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions"
     * >Ownership and permissions-related options</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies a user name that can mount the location and access the files, folders, and metadata that you
     *         need in the SVM.</p>
     *         <p>
     *         If you provide a user in your Active Directory, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you're using Directory Service for Microsoft Active Directory, the user must be a member of the Amazon
     *         Web Services Delegated FSx Administrators group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you're using a self-managed Active Directory, the user must be a member of either the Domain Admins
     *         group or a custom group that you specified for file system administration when you created your file
     *         system.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Make sure that the user has the permissions it needs to copy the data you want:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SE_TCB_NAME</code>: Required to set object ownership and file metadata. With this privilege, you
     *         also can copy NTFS discretionary access lists (DACLs).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SE_SECURITY_NAME</code>: May be needed to copy NTFS system access control lists (SACLs). This
     *         operation specifically requires the Windows privilege, which is granted to members of the Domain Admins
     *         group. If you configure your task to copy SACLs, make sure that the user has the required privileges. For
     *         information about copying SACLs, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions"
     *         >Ownership and permissions-related options</a>.
     *         </p>
     *         </li>
     */
    public final String user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxProtocolSmb)) {
            return false;
        }
        FsxProtocolSmb other = (FsxProtocolSmb) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(mountOptions(), other.mountOptions())
                && Objects.equals(password(), other.password()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FsxProtocolSmb").add("Domain", domain()).add("MountOptions", mountOptions())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FsxProtocolSmb, T> g) {
        return obj -> g.apply((FsxProtocolSmb) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FsxProtocolSmb> {
        /**
         * <p>
         * Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage virtual
         * machine (SVM) belongs to.
         * </p>
         * 
         * @param domain
         *        Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage
         *        virtual machine (SVM) belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * @param mountOptions
         *        The new value for the MountOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(SmbMountOptions mountOptions);

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SmbMountOptions.Builder} avoiding the
         * need to create one manually via {@link SmbMountOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmbMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(SmbMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link SmbMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(SmbMountOptions)
         */
        default Builder mountOptions(Consumer<SmbMountOptions.Builder> mountOptions) {
            return mountOptions(SmbMountOptions.builder().applyMutation(mountOptions).build());
        }

        /**
         * <p>
         * Specifies the password of a user who has permission to access your SVM.
         * </p>
         * 
         * @param password
         *        Specifies the password of a user who has permission to access your SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * Specifies a user name that can mount the location and access the files, folders, and metadata that you need
         * in the SVM.
         * </p>
         * <p>
         * If you provide a user in your Active Directory, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you're using Directory Service for Microsoft Active Directory, the user must be a member of the Amazon Web
         * Services Delegated FSx Administrators group.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you're using a self-managed Active Directory, the user must be a member of either the Domain Admins group
         * or a custom group that you specified for file system administration when you created your file system.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Make sure that the user has the permissions it needs to copy the data you want:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SE_TCB_NAME</code>: Required to set object ownership and file metadata. With this privilege, you also
         * can copy NTFS discretionary access lists (DACLs).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SE_SECURITY_NAME</code>: May be needed to copy NTFS system access control lists (SACLs). This operation
         * specifically requires the Windows privilege, which is granted to members of the Domain Admins group. If you
         * configure your task to copy SACLs, make sure that the user has the required privileges. For information about
         * copying SACLs, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions"
         * >Ownership and permissions-related options</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param user
         *        Specifies a user name that can mount the location and access the files, folders, and metadata that you
         *        need in the SVM.</p>
         *        <p>
         *        If you provide a user in your Active Directory, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you're using Directory Service for Microsoft Active Directory, the user must be a member of the
         *        Amazon Web Services Delegated FSx Administrators group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you're using a self-managed Active Directory, the user must be a member of either the Domain Admins
         *        group or a custom group that you specified for file system administration when you created your file
         *        system.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Make sure that the user has the permissions it needs to copy the data you want:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SE_TCB_NAME</code>: Required to set object ownership and file metadata. With this privilege, you
         *        also can copy NTFS discretionary access lists (DACLs).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SE_SECURITY_NAME</code>: May be needed to copy NTFS system access control lists (SACLs). This
         *        operation specifically requires the Windows privilege, which is granted to members of the Domain
         *        Admins group. If you configure your task to copy SACLs, make sure that the user has the required
         *        privileges. For information about copying SACLs, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions"
         *        >Ownership and permissions-related options</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private SmbMountOptions mountOptions;

        private String password;

        private String user;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxProtocolSmb model) {
            domain(model.domain);
            mountOptions(model.mountOptions);
            password(model.password);
            user(model.user);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final SmbMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(SmbMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(SmbMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        @Override
        public FsxProtocolSmb build() {
            return new FsxProtocolSmb(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
