/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeLocationS3Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationS3Response extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationS3Response.Builder, DescribeLocationS3Response> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationS3Response::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationS3Response::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> S3_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3StorageClass").getter(getter(DescribeLocationS3Response::s3StorageClassAsString))
            .setter(setter(Builder::s3StorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageClass").build()).build();

    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("S3Config").getter(getter(DescribeLocationS3Response::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(DescribeLocationS3Response::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationS3Response::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, S3_STORAGE_CLASS_FIELD, S3_CONFIG_FIELD, AGENT_ARNS_FIELD, CREATION_TIME_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final String s3StorageClass;

    private final S3Config s3Config;

    private final List<String> agentArns;

    private final Instant creationTime;

    private DescribeLocationS3Response(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.s3StorageClass = builder.s3StorageClass;
        this.s3Config = builder.s3Config;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the Amazon S3 location that was described.
     * </p>
     * 
     * @return The URL of the Amazon S3 location that was described.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     * destination. For more information about S3 storage classes, see <a
     * href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have
     * behaviors that can affect your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     * >Considerations when working with S3 storage classes in DataSync</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3StorageClass}
     * will return {@link S3StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3StorageClassAsString}.
     * </p>
     * 
     * @return The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     *         destination. For more information about S3 storage classes, see <a
     *         href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have
     *         behaviors that can affect your S3 storage cost. For detailed information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     *         >Considerations when working with S3 storage classes in DataSync</a>.
     * @see S3StorageClass
     */
    public final S3StorageClass s3StorageClass() {
        return S3StorageClass.fromValue(s3StorageClass);
    }

    /**
     * <p>
     * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     * destination. For more information about S3 storage classes, see <a
     * href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have
     * behaviors that can affect your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     * >Considerations when working with S3 storage classes in DataSync</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3StorageClass}
     * will return {@link S3StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3StorageClassAsString}.
     * </p>
     * 
     * @return The Amazon S3 storage class that you chose to store your files in when this location is used as a task
     *         destination. For more information about S3 storage classes, see <a
     *         href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have
     *         behaviors that can affect your S3 storage cost. For detailed information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     *         >Considerations when working with S3 storage classes in DataSync</a>.
     * @see S3StorageClass
     */
    public final String s3StorageClassAsString() {
        return s3StorageClass;
    }

    /**
     * Returns the value of the S3Config property for this object.
     * 
     * @return The value of the S3Config property for this object.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents
     * deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services
     * Outpost, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your
     * DataSync agent on Outposts</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentArns} method.
     * </p>
     * 
     * @return If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2
     *         agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web
     *         Services Outpost, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy
     *         your DataSync agent on Outposts</a>.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    /**
     * <p>
     * The time that the Amazon S3 bucket location was created.
     * </p>
     * 
     * @return The time that the Amazon S3 bucket location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(s3StorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationS3Response)) {
            return false;
        }
        DescribeLocationS3Response other = (DescribeLocationS3Response) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(s3StorageClassAsString(), other.s3StorageClassAsString())
                && Objects.equals(s3Config(), other.s3Config()) && hasAgentArns() == other.hasAgentArns()
                && Objects.equals(agentArns(), other.agentArns()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationS3Response").add("LocationArn", locationArn()).add("LocationUri", locationUri())
                .add("S3StorageClass", s3StorageClassAsString()).add("S3Config", s3Config())
                .add("AgentArns", hasAgentArns() ? agentArns() : null).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "S3StorageClass":
            return Optional.ofNullable(clazz.cast(s3StorageClassAsString()));
        case "S3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationS3Response, T> g) {
        return obj -> g.apply((DescribeLocationS3Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationS3Response> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the Amazon S3 location that was described.
         * </p>
         * 
         * @param locationUri
         *        The URL of the Amazon S3 location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         * destination. For more information about S3 storage classes, see <a
         * href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have
         * behaviors that can affect your S3 storage cost. For detailed information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         * >Considerations when working with S3 storage classes in DataSync</a>.
         * </p>
         * 
         * @param s3StorageClass
         *        The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         *        destination. For more information about S3 storage classes, see <a
         *        href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes
         *        have behaviors that can affect your S3 storage cost. For detailed information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         *        >Considerations when working with S3 storage classes in DataSync</a>.
         * @see S3StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3StorageClass
         */
        Builder s3StorageClass(String s3StorageClass);

        /**
         * <p>
         * The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         * destination. For more information about S3 storage classes, see <a
         * href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have
         * behaviors that can affect your S3 storage cost. For detailed information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         * >Considerations when working with S3 storage classes in DataSync</a>.
         * </p>
         * 
         * @param s3StorageClass
         *        The Amazon S3 storage class that you chose to store your files in when this location is used as a task
         *        destination. For more information about S3 storage classes, see <a
         *        href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes
         *        have behaviors that can affect your S3 storage cost. For detailed information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         *        >Considerations when working with S3 storage classes in DataSync</a>.
         * @see S3StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3StorageClass
         */
        Builder s3StorageClass(S3StorageClass s3StorageClass);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * @param s3Config
         *        The new value for the S3Config property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Config.Builder} avoiding the need to create
         * one manually via {@link S3Config#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        /**
         * <p>
         * If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2
         * agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web
         * Services Outpost, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your
         * DataSync agent on Outposts</a>.
         * </p>
         * 
         * @param agentArns
         *        If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the
         *        EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an
         *        Amazon Web Services Outpost, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy
         *        your DataSync agent on Outposts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2
         * agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web
         * Services Outpost, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your
         * DataSync agent on Outposts</a>.
         * </p>
         * 
         * @param agentArns
         *        If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the
         *        EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an
         *        Amazon Web Services Outpost, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy
         *        your DataSync agent on Outposts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * The time that the Amazon S3 bucket location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the Amazon S3 bucket location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private String s3StorageClass;

        private S3Config s3Config;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationS3Response model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            s3StorageClass(model.s3StorageClass);
            s3Config(model.s3Config);
            agentArns(model.agentArns);
            creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        @Transient
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        @Transient
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getS3StorageClass() {
            return s3StorageClass;
        }

        public final void setS3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
        }

        @Override
        @Transient
        public final Builder s3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        @Override
        @Transient
        public final Builder s3StorageClass(S3StorageClass s3StorageClass) {
            this.s3StorageClass(s3StorageClass == null ? null : s3StorageClass.toString());
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        @Transient
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationS3Response build() {
            return new DescribeLocationS3Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
