/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListLocationsResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLocationsResponse extends DataSyncResponse implements
        ToCopyableBuilder<ListLocationsResponse.Builder, ListLocationsResponse> {
    private static final SdkField<List<LocationListEntry>> LOCATIONS_FIELD = SdkField
            .<List<LocationListEntry>> builder(MarshallingType.LIST)
            .memberName("Locations")
            .getter(getter(ListLocationsResponse::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLocationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LocationListEntry> locations;

    private final String nextToken;

    private ListLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.locations = builder.locations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Locations property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains a list of locations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains a list of locations.
     */
    public final List<LocationListEntry> locations() {
        return locations;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin returning the next list of locations.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin returning the next list of locations.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocationsResponse)) {
            return false;
        }
        ListLocationsResponse other = (ListLocationsResponse) obj;
        return hasLocations() == other.hasLocations() && Objects.equals(locations(), other.locations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLocationsResponse").add("Locations", hasLocations() ? locations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Locations":
            return Optional.ofNullable(clazz.cast(locations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLocationsResponse, T> g) {
        return obj -> g.apply((ListLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLocationsResponse> {
        /**
         * <p>
         * An array that contains a list of locations.
         * </p>
         * 
         * @param locations
         *        An array that contains a list of locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<LocationListEntry> locations);

        /**
         * <p>
         * An array that contains a list of locations.
         * </p>
         * 
         * @param locations
         *        An array that contains a list of locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(LocationListEntry... locations);

        /**
         * <p>
         * An array that contains a list of locations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocationListEntry>.Builder} avoiding the
         * need to create one manually via {@link List<LocationListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocationListEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #locations(List<LocationListEntry>)}.
         * 
         * @param locations
         *        a consumer that will call methods on {@link List<LocationListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(List<LocationListEntry>)
         */
        Builder locations(Consumer<LocationListEntry.Builder>... locations);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin returning the next list of locations.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates the position at which to begin returning the next list of locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private List<LocationListEntry> locations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLocationsResponse model) {
            super(model);
            locations(model.locations);
            nextToken(model.nextToken);
        }

        public final List<LocationListEntry.Builder> getLocations() {
            List<LocationListEntry.Builder> result = LocationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder locations(Collection<LocationListEntry> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationListEntry... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationListEntry.Builder>... locations) {
            locations(Stream.of(locations).map(c -> LocationListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLocations(Collection<LocationListEntry.BuilderImpl> locations) {
            this.locations = LocationListCopier.copyFromBuilder(locations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLocationsResponse build() {
            return new ListLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
