/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateTaskResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTaskRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateTaskRequest.Builder, UpdateTaskRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(UpdateTaskRequest::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<Options> OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(UpdateTaskRequest::options)).setter(setter(Builder::options))
            .constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Excludes")
            .getter(getter(UpdateTaskRequest::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TaskSchedule> SCHEDULE_FIELD = SdkField.<TaskSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(UpdateTaskRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(TaskSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(UpdateTaskRequest::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Includes")
            .getter(getter(UpdateTaskRequest::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, OPTIONS_FIELD,
            EXCLUDES_FIELD, SCHEDULE_FIELD, NAME_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, INCLUDES_FIELD));

    private final String taskArn;

    private final Options options;

    private final List<FilterRule> excludes;

    private final TaskSchedule schedule;

    private final String name;

    private final String cloudWatchLogGroupArn;

    private final List<FilterRule> includes;

    private UpdateTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.schedule = builder.schedule;
        this.name = builder.name;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.includes = builder.includes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource name of the task to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource name of the task to update.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * Returns the value of the Options property for this object.
     * 
     * @return The value of the Options property for this object.
     */
    public final Options options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that determines which files to exclude from a task. The list should contain a single
     * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for
     * example: <code>"/folder1|/folder2"</code>
     * </p>
     * <p>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return A list of filter rules that determines which files to exclude from a task. The list should contain a
     *         single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
     *         is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
     *         <p>
     */
    public final List<FilterRule> excludes() {
        return excludes;
    }

    /**
     * <p>
     * Specifies a schedule used to periodically transfer files from a source to a destination location. You can
     * configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day
     * or hour you want the task to execute. The time you specify is UTC time. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.
     * </p>
     * 
     * @return Specifies a schedule used to periodically transfer files from a source to a destination location. You can
     *         configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in
     *         the day or hour you want the task to execute. The time you specify is UTC time. For more information, see
     *         <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your
     *         task</a>.
     */
    public final TaskSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The name of the task to update.
     * </p>
     * 
     * @return The name of the task to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource name of the CloudWatch LogGroup.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource name of the CloudWatch LogGroup.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that determines which files to include when running a task. The pattern should contain a
     * single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a
     * pipe). For example: <code>"/folder1|/folder2</code>"
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return A list of filter rules that determines which files to include when running a task. The pattern should
     *         contain a single filter string that consists of the patterns to include. The patterns are delimited by
     *         "|" (that is, a pipe). For example: <code>"/folder1|/folder2</code>"
     */
    public final List<FilterRule> includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskRequest)) {
            return false;
        }
        UpdateTaskRequest other = (UpdateTaskRequest) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(options(), other.options())
                && hasExcludes() == other.hasExcludes() && Objects.equals(excludes(), other.excludes())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(name(), other.name())
                && Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && hasIncludes() == other.hasIncludes()
                && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTaskRequest").add("TaskArn", taskArn()).add("Options", options())
                .add("Excludes", hasExcludes() ? excludes() : null).add("Schedule", schedule()).add("Name", name())
                .add("CloudWatchLogGroupArn", cloudWatchLogGroupArn()).add("Includes", hasIncludes() ? includes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskRequest, T> g) {
        return obj -> g.apply((UpdateTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTaskRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource name of the task to update.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the resource name of the task to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * Sets the value of the Options property for this object.
         *
         * @param options
         *        The new value for the Options property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Options options);

        /**
         * Sets the value of the Options property for this object.
         *
         * This is a convenience that creates an instance of the {@link Options.Builder} avoiding the need to create one
         * manually via {@link Options#builder()}.
         *
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #options(Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Options)
         */
        default Builder options(Consumer<Options.Builder> options) {
            return options(Options.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single
         * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe),
         * for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that determines which files to exclude from a task. The list should contain a
         *        single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
         *        is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<FilterRule> excludes);

        /**
         * <p>
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single
         * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe),
         * for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that determines which files to exclude from a task. The list should contain a
         *        single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
         *        is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(FilterRule... excludes);

        /**
         * <p>
         * A list of filter rules that determines which files to exclude from a task. The list should contain a single
         * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe),
         * for example: <code>"/folder1|/folder2"</code>
         * </p>
         * <p>
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilterRule>.Builder} avoiding the need to
         * create one manually via {@link List<FilterRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilterRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #excludes(List<FilterRule>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link List<FilterRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(List<FilterRule>)
         */
        Builder excludes(Consumer<FilterRule.Builder>... excludes);

        /**
         * <p>
         * Specifies a schedule used to periodically transfer files from a source to a destination location. You can
         * configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the
         * day or hour you want the task to execute. The time you specify is UTC time. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.
         * </p>
         * 
         * @param schedule
         *        Specifies a schedule used to periodically transfer files from a source to a destination location. You
         *        can configure your task to execute hourly, daily, weekly or on specific days of the week. You control
         *        when in the day or hour you want the task to execute. The time you specify is UTC time. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your
         *        task</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(TaskSchedule schedule);

        /**
         * <p>
         * Specifies a schedule used to periodically transfer files from a source to a destination location. You can
         * configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the
         * day or hour you want the task to execute. The time you specify is UTC time. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskSchedule.Builder} avoiding the need to
         * create one manually via {@link TaskSchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(TaskSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link TaskSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(TaskSchedule)
         */
        default Builder schedule(Consumer<TaskSchedule.Builder> schedule) {
            return schedule(TaskSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The name of the task to update.
         * </p>
         * 
         * @param name
         *        The name of the task to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource name of the CloudWatch LogGroup.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        The Amazon Resource Name (ARN) of the resource name of the CloudWatch LogGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The pattern should contain
         * a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is,
         * a pipe). For example: <code>"/folder1|/folder2</code>"
         * </p>
         * 
         * @param includes
         *        A list of filter rules that determines which files to include when running a task. The pattern should
         *        contain a single filter string that consists of the patterns to include. The patterns are delimited by
         *        "|" (that is, a pipe). For example: <code>"/folder1|/folder2</code>"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The pattern should contain
         * a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is,
         * a pipe). For example: <code>"/folder1|/folder2</code>"
         * </p>
         * 
         * @param includes
         *        A list of filter rules that determines which files to include when running a task. The pattern should
         *        contain a single filter string that consists of the patterns to include. The patterns are delimited by
         *        "|" (that is, a pipe). For example: <code>"/folder1|/folder2</code>"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * A list of filter rules that determines which files to include when running a task. The pattern should contain
         * a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is,
         * a pipe). For example: <code>"/folder1|/folder2</code>"
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilterRule>.Builder} avoiding the need to
         * create one manually via {@link List<FilterRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilterRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link List<FilterRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(List<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String taskArn;

        private Options options;

        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();

        private TaskSchedule schedule;

        private String name;

        private String cloudWatchLogGroupArn;

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskRequest model) {
            super(model);
            taskArn(model.taskArn);
            options(model.options);
            excludes(model.excludes);
            schedule(model.schedule);
            name(model.name);
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            includes(model.includes);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        @Transient
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        @Transient
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludes(FilterRule... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TaskSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(TaskSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        @Transient
        public final Builder schedule(TaskSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        @Transient
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskRequest build() {
            return new UpdateTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
