/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnPremConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnPremConfig> {
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(OnPremConfig.getter(OnPremConfig::agentArns)).setter(OnPremConfig.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> agentArns;

    private OnPremConfig(BuilderImpl builder) {
        this.agentArns = builder.agentArns;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnPremConfig)) {
            return false;
        }
        OnPremConfig other = (OnPremConfig)obj;
        return this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns());
    }

    public final String toString() {
        return ToString.builder((String)"OnPremConfig").add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnPremConfig, T> g) {
        return obj -> g.apply((OnPremConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OnPremConfig model) {
            this.agentArns(model.agentArns);
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        @Transient
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public OnPremConfig build() {
            return new OnPremConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnPremConfig> {
        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);
    }
}

