/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeLocationEfsResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationEfsResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationEfsResponse.Builder, DescribeLocationEfsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationEfsResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationEfsResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<Ec2Config> EC2_CONFIG_FIELD = SdkField.<Ec2Config> builder(MarshallingType.SDK_POJO)
            .memberName("Ec2Config").getter(getter(DescribeLocationEfsResponse::ec2Config)).setter(setter(Builder::ec2Config))
            .constructor(Ec2Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2Config").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationEfsResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, EC2_CONFIG_FIELD, CREATION_TIME_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final Ec2Config ec2Config;

    private final Instant creationTime;

    private DescribeLocationEfsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.ec2Config = builder.ec2Config;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the EFS location that was described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the EFS location that was described.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the EFS location that was described.
     * </p>
     * 
     * @return The URL of the EFS location that was described.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * Returns the value of the Ec2Config property for this object.
     * 
     * @return The value of the Ec2Config property for this object.
     */
    public final Ec2Config ec2Config() {
        return ec2Config;
    }

    /**
     * <p>
     * The time that the EFS location was created.
     * </p>
     * 
     * @return The time that the EFS location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(ec2Config());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationEfsResponse)) {
            return false;
        }
        DescribeLocationEfsResponse other = (DescribeLocationEfsResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(ec2Config(), other.ec2Config()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationEfsResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("Ec2Config", ec2Config()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "Ec2Config":
            return Optional.ofNullable(clazz.cast(ec2Config()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationEfsResponse, T> g) {
        return obj -> g.apply((DescribeLocationEfsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationEfsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the EFS location that was described.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the EFS location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the EFS location that was described.
         * </p>
         * 
         * @param locationUri
         *        The URL of the EFS location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * Sets the value of the Ec2Config property for this object.
         *
         * @param ec2Config
         *        The new value for the Ec2Config property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Config(Ec2Config ec2Config);

        /**
         * Sets the value of the Ec2Config property for this object.
         *
         * This is a convenience that creates an instance of the {@link Ec2Config.Builder} avoiding the need to create
         * one manually via {@link Ec2Config#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ec2Config.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2Config(Ec2Config)}.
         * 
         * @param ec2Config
         *        a consumer that will call methods on {@link Ec2Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Config(Ec2Config)
         */
        default Builder ec2Config(Consumer<Ec2Config.Builder> ec2Config) {
            return ec2Config(Ec2Config.builder().applyMutation(ec2Config).build());
        }

        /**
         * <p>
         * The time that the EFS location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the EFS location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private Ec2Config ec2Config;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationEfsResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            ec2Config(model.ec2Config);
            creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final Ec2Config.Builder getEc2Config() {
            return ec2Config != null ? ec2Config.toBuilder() : null;
        }

        @Override
        public final Builder ec2Config(Ec2Config ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        public final void setEc2Config(Ec2Config.BuilderImpl ec2Config) {
            this.ec2Config = ec2Config != null ? ec2Config.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeLocationEfsResponse build() {
            return new DescribeLocationEfsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
