/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationObjectStorageRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationObjectStorageRequest.Builder, UpdateLocationObjectStorageRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationObjectStorageRequest::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServerPort").getter(getter(UpdateLocationObjectStorageRequest::serverPort))
            .setter(setter(Builder::serverPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()).build();

    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerProtocol").getter(getter(UpdateLocationObjectStorageRequest::serverProtocolAsString))
            .setter(setter(Builder::serverProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationObjectStorageRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessKey").getter(getter(UpdateLocationObjectStorageRequest::accessKey))
            .setter(setter(Builder::accessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()).build();

    private static final SdkField<String> SECRET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretKey").getter(getter(UpdateLocationObjectStorageRequest::secretKey))
            .setter(setter(Builder::secretKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretKey").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(UpdateLocationObjectStorageRequest::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            SERVER_PORT_FIELD, SERVER_PROTOCOL_FIELD, SUBDIRECTORY_FIELD, ACCESS_KEY_FIELD, SECRET_KEY_FIELD, AGENT_ARNS_FIELD));

    private final String locationArn;

    private final Integer serverPort;

    private final String serverProtocol;

    private final String subdirectory;

    private final String accessKey;

    private final String secretKey;

    private final List<String> agentArns;

    private UpdateLocationObjectStorageRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.serverPort = builder.serverPort;
        this.serverProtocol = builder.serverProtocol;
        this.subdirectory = builder.subdirectory;
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.agentArns = builder.agentArns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The port that your self-managed object storage server accepts inbound network traffic on. The server port is set
     * by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage
     * server requires one.
     * </p>
     * 
     * @return The port that your self-managed object storage server accepts inbound network traffic on. The server port
     *         is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed
     *         object storage server requires one.
     */
    public final Integer serverPort() {
        return serverPort;
    }

    /**
     * <p>
     * The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
     * <code>HTTPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ObjectStorageServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
     *         <code>HTTPS</code>.
     * @see ObjectStorageServerProtocol
     */
    public final ObjectStorageServerProtocol serverProtocol() {
        return ObjectStorageServerProtocol.fromValue(serverProtocol);
    }

    /**
     * <p>
     * The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
     * <code>HTTPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ObjectStorageServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
     *         <code>HTTPS</code>.
     * @see ObjectStorageServerProtocol
     */
    public final String serverProtocolAsString() {
        return serverProtocol;
    }

    /**
     * <p>
     * The subdirectory in the self-managed object storage server that is used to read data from.
     * </p>
     * 
     * @return The subdirectory in the self-managed object storage server that is used to read data from.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Optional. The access key is used if credentials are required to access the self-managed object storage server. If
     * your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and
     * <code>SecretKey</code> to provide the user name and password, respectively.
     * </p>
     * 
     * @return Optional. The access key is used if credentials are required to access the self-managed object storage
     *         server. If your object storage requires a user name and password to authenticate, use
     *         <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.
     */
    public final String accessKey() {
        return accessKey;
    }

    /**
     * <p>
     * Optional. The secret key is used if credentials are required to access the self-managed object storage server. If
     * your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and
     * <code>SecretKey</code> to provide the user name and password, respectively.
     * </p>
     * 
     * @return Optional. The secret key is used if credentials are required to access the self-managed object storage
     *         server. If your object storage requires a user name and password to authenticate, use
     *         <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.
     */
    public final String secretKey() {
        return secretKey;
    }

    /**
     * Returns true if the AgentArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgentArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
     *         location.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverPort());
        hashCode = 31 * hashCode + Objects.hashCode(serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(secretKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationObjectStorageRequest)) {
            return false;
        }
        UpdateLocationObjectStorageRequest other = (UpdateLocationObjectStorageRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(serverPort(), other.serverPort())
                && Objects.equals(serverProtocolAsString(), other.serverProtocolAsString())
                && Objects.equals(subdirectory(), other.subdirectory()) && Objects.equals(accessKey(), other.accessKey())
                && Objects.equals(secretKey(), other.secretKey()) && hasAgentArns() == other.hasAgentArns()
                && Objects.equals(agentArns(), other.agentArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationObjectStorageRequest").add("LocationArn", locationArn())
                .add("ServerPort", serverPort()).add("ServerProtocol", serverProtocolAsString())
                .add("Subdirectory", subdirectory()).add("AccessKey", accessKey())
                .add("SecretKey", secretKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AgentArns", hasAgentArns() ? agentArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "ServerPort":
            return Optional.ofNullable(clazz.cast(serverPort()));
        case "ServerProtocol":
            return Optional.ofNullable(clazz.cast(serverProtocolAsString()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "AccessKey":
            return Optional.ofNullable(clazz.cast(accessKey()));
        case "SecretKey":
            return Optional.ofNullable(clazz.cast(secretKey()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationObjectStorageRequest, T> g) {
        return obj -> g.apply((UpdateLocationObjectStorageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLocationObjectStorageRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The port that your self-managed object storage server accepts inbound network traffic on. The server port is
         * set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object
         * storage server requires one.
         * </p>
         * 
         * @param serverPort
         *        The port that your self-managed object storage server accepts inbound network traffic on. The server
         *        port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your
         *        self-managed object storage server requires one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPort(Integer serverPort);

        /**
         * <p>
         * The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
         * <code>HTTPS</code>.
         * </p>
         * 
         * @param serverProtocol
         *        The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
         *        <code>HTTPS</code>.
         * @see ObjectStorageServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageServerProtocol
         */
        Builder serverProtocol(String serverProtocol);

        /**
         * <p>
         * The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
         * <code>HTTPS</code>.
         * </p>
         * 
         * @param serverProtocol
         *        The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or
         *        <code>HTTPS</code>.
         * @see ObjectStorageServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageServerProtocol
         */
        Builder serverProtocol(ObjectStorageServerProtocol serverProtocol);

        /**
         * <p>
         * The subdirectory in the self-managed object storage server that is used to read data from.
         * </p>
         * 
         * @param subdirectory
         *        The subdirectory in the self-managed object storage server that is used to read data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Optional. The access key is used if credentials are required to access the self-managed object storage
         * server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code>
         * and <code>SecretKey</code> to provide the user name and password, respectively.
         * </p>
         * 
         * @param accessKey
         *        Optional. The access key is used if credentials are required to access the self-managed object storage
         *        server. If your object storage requires a user name and password to authenticate, use
         *        <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKey(String accessKey);

        /**
         * <p>
         * Optional. The secret key is used if credentials are required to access the self-managed object storage
         * server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code>
         * and <code>SecretKey</code> to provide the user name and password, respectively.
         * </p>
         * 
         * @param secretKey
         *        Optional. The secret key is used if credentials are required to access the self-managed object storage
         *        server. If your object storage requires a user name and password to authenticate, use
         *        <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretKey(String secretKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
         * </p>
         * 
         * @param agentArns
         *        The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.
         * </p>
         * 
         * @param agentArns
         *        The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private Integer serverPort;

        private String serverProtocol;

        private String subdirectory;

        private String accessKey;

        private String secretKey;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationObjectStorageRequest model) {
            super(model);
            locationArn(model.locationArn);
            serverPort(model.serverPort);
            serverProtocol(model.serverProtocol);
            subdirectory(model.subdirectory);
            accessKey(model.accessKey);
            secretKey(model.secretKey);
            agentArns(model.agentArns);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final Integer getServerPort() {
            return serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        public final String getServerProtocol() {
            return serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(ObjectStorageServerProtocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        public final String getAccessKey() {
            return accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public final String getSecretKey() {
            return secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationObjectStorageRequest build() {
            return new UpdateLocationObjectStorageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
