/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationFsxOntapRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationFsxOntapRequest.Builder, CreateLocationFsxOntapRequest> {
    private static final SdkField<FsxProtocol> PROTOCOL_FIELD = SdkField.<FsxProtocol> builder(MarshallingType.SDK_POJO)
            .memberName("Protocol").getter(getter(CreateLocationFsxOntapRequest::protocol)).setter(setter(Builder::protocol))
            .constructor(FsxProtocol::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupArns")
            .getter(getter(CreateLocationFsxOntapRequest::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineArn").getter(getter(CreateLocationFsxOntapRequest::storageVirtualMachineArn))
            .setter(setter(Builder::storageVirtualMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineArn").build())
            .build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(CreateLocationFsxOntapRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLocationFsxOntapRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            SECURITY_GROUP_ARNS_FIELD, STORAGE_VIRTUAL_MACHINE_ARN_FIELD, SUBDIRECTORY_FIELD, TAGS_FIELD));

    private final FsxProtocol protocol;

    private final List<String> securityGroupArns;

    private final String storageVirtualMachineArn;

    private final String subdirectory;

    private final List<TagListEntry> tags;

    private CreateLocationFsxOntapRequest(BuilderImpl builder) {
        super(builder);
        this.protocol = builder.protocol;
        this.securityGroupArns = builder.securityGroupArns;
        this.storageVirtualMachineArn = builder.storageVirtualMachineArn;
        this.subdirectory = builder.subdirectory;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the Protocol property for this object.
     * 
     * @return The value of the Protocol property for this object.
     */
    public final FsxProtocol protocol() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupArns() {
        return securityGroupArns != null && !(securityGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the Amazon EC2 security groups that provide access to your file system's preferred subnet.
     * </p>
     * <p>
     * The security groups must allow outbound traffic on the following ports (depending on the protocol you use):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Server Message Block (SMB)</b>: TCP port 445
     * </p>
     * </li>
     * </ul>
     * <p>
     * Your file system's security groups must also allow inbound traffic on the same ports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupArns} method.
     * </p>
     * 
     * @return Specifies the Amazon EC2 security groups that provide access to your file system's preferred subnet.</p>
     *         <p>
     *         The security groups must allow outbound traffic on the following ports (depending on the protocol you
     *         use):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Server Message Block (SMB)</b>: TCP port 445
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Your file system's security groups must also allow inbound traffic on the same ports.
     */
    public final List<String> securityGroupArns() {
        return securityGroupArns;
    }

    /**
     * <p>
     * Specifies the ARN of the storage virtual machine (SVM) on your file system where you're copying data to or from.
     * </p>
     * 
     * @return Specifies the ARN of the storage virtual machine (SVM) on your file system where you're copying data to
     *         or from.
     */
    public final String storageVirtualMachineArn() {
        return storageVirtualMachineArn;
    }

    /**
     * <p>
     * Specifies the junction path (also known as a mount point) in the SVM volume where you're copying data to or from
     * (for example, <code>/vol1</code>).
     * </p>
     * <note>
     * <p>
     * Don't specify a junction path in the SVM's root volume. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage
     * virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Specifies the junction path (also known as a mount point) in the SVM volume where you're copying data to
     *         or from (for example, <code>/vol1</code>).</p> <note>
     *         <p>
     *         Don't specify a junction path in the SVM's root volume. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP
     *         storage virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
     *         </p>
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     * recommend creating at least a name tag for your location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     *         recommend creating at least a name tag for your location.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupArns() ? securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationFsxOntapRequest)) {
            return false;
        }
        CreateLocationFsxOntapRequest other = (CreateLocationFsxOntapRequest) obj;
        return Objects.equals(protocol(), other.protocol()) && hasSecurityGroupArns() == other.hasSecurityGroupArns()
                && Objects.equals(securityGroupArns(), other.securityGroupArns())
                && Objects.equals(storageVirtualMachineArn(), other.storageVirtualMachineArn())
                && Objects.equals(subdirectory(), other.subdirectory()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocationFsxOntapRequest").add("Protocol", protocol())
                .add("SecurityGroupArns", hasSecurityGroupArns() ? securityGroupArns() : null)
                .add("StorageVirtualMachineArn", storageVirtualMachineArn()).add("Subdirectory", subdirectory())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        case "StorageVirtualMachineArn":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineArn()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationFsxOntapRequest, T> g) {
        return obj -> g.apply((CreateLocationFsxOntapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationFsxOntapRequest> {
        /**
         * Sets the value of the Protocol property for this object.
         *
         * @param protocol
         *        The new value for the Protocol property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(FsxProtocol protocol);

        /**
         * Sets the value of the Protocol property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FsxProtocol.Builder} avoiding the need to
         * create one manually via {@link FsxProtocol#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxProtocol.Builder#build()} is called immediately and its result
         * is passed to {@link #protocol(FsxProtocol)}.
         * 
         * @param protocol
         *        a consumer that will call methods on {@link FsxProtocol.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocol(FsxProtocol)
         */
        default Builder protocol(Consumer<FsxProtocol.Builder> protocol) {
            return protocol(FsxProtocol.builder().applyMutation(protocol).build());
        }

        /**
         * <p>
         * Specifies the Amazon EC2 security groups that provide access to your file system's preferred subnet.
         * </p>
         * <p>
         * The security groups must allow outbound traffic on the following ports (depending on the protocol you use):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Server Message Block (SMB)</b>: TCP port 445
         * </p>
         * </li>
         * </ul>
         * <p>
         * Your file system's security groups must also allow inbound traffic on the same ports.
         * </p>
         * 
         * @param securityGroupArns
         *        Specifies the Amazon EC2 security groups that provide access to your file system's preferred
         *        subnet.</p>
         *        <p>
         *        The security groups must allow outbound traffic on the following ports (depending on the protocol you
         *        use):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Server Message Block (SMB)</b>: TCP port 445
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Your file system's security groups must also allow inbound traffic on the same ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * <p>
         * Specifies the Amazon EC2 security groups that provide access to your file system's preferred subnet.
         * </p>
         * <p>
         * The security groups must allow outbound traffic on the following ports (depending on the protocol you use):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Server Message Block (SMB)</b>: TCP port 445
         * </p>
         * </li>
         * </ul>
         * <p>
         * Your file system's security groups must also allow inbound traffic on the same ports.
         * </p>
         * 
         * @param securityGroupArns
         *        Specifies the Amazon EC2 security groups that provide access to your file system's preferred
         *        subnet.</p>
         *        <p>
         *        The security groups must allow outbound traffic on the following ports (depending on the protocol you
         *        use):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Server Message Block (SMB)</b>: TCP port 445
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Your file system's security groups must also allow inbound traffic on the same ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);

        /**
         * <p>
         * Specifies the ARN of the storage virtual machine (SVM) on your file system where you're copying data to or
         * from.
         * </p>
         * 
         * @param storageVirtualMachineArn
         *        Specifies the ARN of the storage virtual machine (SVM) on your file system where you're copying data
         *        to or from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineArn(String storageVirtualMachineArn);

        /**
         * <p>
         * Specifies the junction path (also known as a mount point) in the SVM volume where you're copying data to or
         * from (for example, <code>/vol1</code>).
         * </p>
         * <note>
         * <p>
         * Don't specify a junction path in the SVM's root volume. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage
         * virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
         * </p>
         * </note>
         * 
         * @param subdirectory
         *        Specifies the junction path (also known as a mount point) in the SVM volume where you're copying data
         *        to or from (for example, <code>/vol1</code>).</p> <note>
         *        <p>
         *        Don't specify a junction path in the SVM's root volume. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP
         *        storage virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your location.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your location.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private FsxProtocol protocol;

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private String storageVirtualMachineArn;

        private String subdirectory;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationFsxOntapRequest model) {
            super(model);
            protocol(model.protocol);
            securityGroupArns(model.securityGroupArns);
            storageVirtualMachineArn(model.storageVirtualMachineArn);
            subdirectory(model.subdirectory);
            tags(model.tags);
        }

        public final FsxProtocol.Builder getProtocol() {
            return protocol != null ? protocol.toBuilder() : null;
        }

        public final void setProtocol(FsxProtocol.BuilderImpl protocol) {
            this.protocol = protocol != null ? protocol.build() : null;
        }

        @Override
        public final Builder protocol(FsxProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final String getStorageVirtualMachineArn() {
            return storageVirtualMachineArn;
        }

        public final void setStorageVirtualMachineArn(String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
        }

        @Override
        public final Builder storageVirtualMachineArn(String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationFsxOntapRequest build() {
            return new CreateLocationFsxOntapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
