/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClientBuilder;
import software.amazon.awssdk.services.datasync.DataSyncServiceClientConfiguration;
import software.amazon.awssdk.services.datasync.DefaultDataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.DefaultDataSyncBaseClientBuilder;
import software.amazon.awssdk.services.datasync.endpoints.DataSyncEndpointProvider;

@SdkInternalApi
final class DefaultDataSyncAsyncClientBuilder
extends DefaultDataSyncBaseClientBuilder<DataSyncAsyncClientBuilder, DataSyncAsyncClient>
implements DataSyncAsyncClientBuilder {
    DefaultDataSyncAsyncClientBuilder() {
    }

    @Override
    public DefaultDataSyncAsyncClientBuilder endpointProvider(DataSyncEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataSyncAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDataSyncAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DataSyncServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDataSyncAsyncClient client = new DefaultDataSyncAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DataSyncServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DataSyncServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

