/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeLocationNfsResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationNfsResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationNfsResponse.Builder, DescribeLocationNfsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationNfsResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationNfsResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.<OnPremConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OnPremConfig").getter(getter(DescribeLocationNfsResponse::onPremConfig))
            .setter(setter(Builder::onPremConfig)).constructor(OnPremConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()).build();

    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<NfsMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(DescribeLocationNfsResponse::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(NfsMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationNfsResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD, CREATION_TIME_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final OnPremConfig onPremConfig;

    private final NfsMountOptions mountOptions;

    private final Instant creationTime;

    private DescribeLocationNfsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the NFS location that was described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the NFS location that was described.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the source NFS location that was described.
     * </p>
     * 
     * @return The URL of the source NFS location that was described.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * Returns the value of the OnPremConfig property for this object.
     * 
     * @return The value of the OnPremConfig property for this object.
     */
    public final OnPremConfig onPremConfig() {
        return onPremConfig;
    }

    /**
     * <p>
     * The mount options that DataSync uses to mount your NFS share.
     * </p>
     * 
     * @return The mount options that DataSync uses to mount your NFS share.
     */
    public final NfsMountOptions mountOptions() {
        return mountOptions;
    }

    /**
     * <p>
     * The time that the NFS location was created.
     * </p>
     * 
     * @return The time that the NFS location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationNfsResponse)) {
            return false;
        }
        DescribeLocationNfsResponse other = (DescribeLocationNfsResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(onPremConfig(), other.onPremConfig()) && Objects.equals(mountOptions(), other.mountOptions())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationNfsResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("OnPremConfig", onPremConfig()).add("MountOptions", mountOptions())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "OnPremConfig":
            return Optional.ofNullable(clazz.cast(onPremConfig()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationNfsResponse, T> g) {
        return obj -> g.apply((DescribeLocationNfsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationNfsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the NFS location that was described.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the NFS location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the source NFS location that was described.
         * </p>
         * 
         * @param locationUri
         *        The URL of the source NFS location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * Sets the value of the OnPremConfig property for this object.
         *
         * @param onPremConfig
         *        The new value for the OnPremConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremConfig(OnPremConfig onPremConfig);

        /**
         * Sets the value of the OnPremConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OnPremConfig.Builder} avoiding the need
         * to create one manually via {@link OnPremConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnPremConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremConfig(OnPremConfig)}.
         * 
         * @param onPremConfig
         *        a consumer that will call methods on {@link OnPremConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremConfig(OnPremConfig)
         */
        default Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return onPremConfig(OnPremConfig.builder().applyMutation(onPremConfig).build());
        }

        /**
         * <p>
         * The mount options that DataSync uses to mount your NFS share.
         * </p>
         * 
         * @param mountOptions
         *        The mount options that DataSync uses to mount your NFS share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(NfsMountOptions mountOptions);

        /**
         * <p>
         * The mount options that DataSync uses to mount your NFS share.
         * </p>
         * This is a convenience method that creates an instance of the {@link NfsMountOptions.Builder} avoiding the
         * need to create one manually via {@link NfsMountOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NfsMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(NfsMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link NfsMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(NfsMountOptions)
         */
        default Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return mountOptions(NfsMountOptions.builder().applyMutation(mountOptions).build());
        }

        /**
         * <p>
         * The time that the NFS location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the NFS location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private OnPremConfig onPremConfig;

        private NfsMountOptions mountOptions;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationNfsResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            onPremConfig(model.onPremConfig);
            mountOptions(model.mountOptions);
            creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return onPremConfig != null ? onPremConfig.toBuilder() : null;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationNfsResponse build() {
            return new DescribeLocationNfsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
