/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationNfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationNfsRequest.Builder, UpdateLocationNfsRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationNfsRequest::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationNfsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.<OnPremConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OnPremConfig").getter(getter(UpdateLocationNfsRequest::onPremConfig))
            .setter(setter(Builder::onPremConfig)).constructor(OnPremConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()).build();

    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<NfsMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(UpdateLocationNfsRequest::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(NfsMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            SUBDIRECTORY_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD));

    private final String locationArn;

    private final String subdirectory;

    private final OnPremConfig onPremConfig;

    private final NfsMountOptions mountOptions;

    private UpdateLocationNfsRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the NFS location that you want to update.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the NFS location that you want to update.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Specifies the subdirectory in your NFS file system that DataSync uses to read from or write to during a transfer.
     * The NFS path should be exported by the NFS server, or a subdirectory of that path. The path should be such that
     * it can be mounted by other NFS clients in your network.
     * </p>
     * <p>
     * To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS
     * client that has access to your server. You can specify any directory that appears in the results, and any
     * subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
     * </p>
     * <p>
     * To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data.
     * To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure that the files you
     * want DataSync to access have permissions that allow read access for all users. Doing either option enables the
     * agent to read the files. For the agent to access directories, you must additionally enable all execute access.
     * </p>
     * <p>
     * If you are copying data to or from your Snowcone device, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server
     * on Snowcone</a> for more information.
     * </p>
     * 
     * @return Specifies the subdirectory in your NFS file system that DataSync uses to read from or write to during a
     *         transfer. The NFS path should be exported by the NFS server, or a subdirectory of that path. The path
     *         should be such that it can be mounted by other NFS clients in your network.</p>
     *         <p>
     *         To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an
     *         NFS client that has access to your server. You can specify any directory that appears in the results, and
     *         any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos
     *         authentication.
     *         </p>
     *         <p>
     *         To transfer all the data in the folder that you specified, DataSync must have permissions to read all the
     *         data. To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure that
     *         the files you want DataSync to access have permissions that allow read access for all users. Doing either
     *         option enables the agent to read the files. For the agent to access directories, you must additionally
     *         enable all execute access.
     *         </p>
     *         <p>
     *         If you are copying data to or from your Snowcone device, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS
     *         Server on Snowcone</a> for more information.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * Returns the value of the OnPremConfig property for this object.
     * 
     * @return The value of the OnPremConfig property for this object.
     */
    public final OnPremConfig onPremConfig() {
        return onPremConfig;
    }

    /**
     * Returns the value of the MountOptions property for this object.
     * 
     * @return The value of the MountOptions property for this object.
     */
    public final NfsMountOptions mountOptions() {
        return mountOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationNfsRequest)) {
            return false;
        }
        UpdateLocationNfsRequest other = (UpdateLocationNfsRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(onPremConfig(), other.onPremConfig()) && Objects.equals(mountOptions(), other.mountOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationNfsRequest").add("LocationArn", locationArn()).add("Subdirectory", subdirectory())
                .add("OnPremConfig", onPremConfig()).add("MountOptions", mountOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "OnPremConfig":
            return Optional.ofNullable(clazz.cast(onPremConfig()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationNfsRequest, T> g) {
        return obj -> g.apply((UpdateLocationNfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationNfsRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the NFS location that you want to update.
         * </p>
         * 
         * @param locationArn
         *        Specifies the Amazon Resource Name (ARN) of the NFS location that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Specifies the subdirectory in your NFS file system that DataSync uses to read from or write to during a
         * transfer. The NFS path should be exported by the NFS server, or a subdirectory of that path. The path should
         * be such that it can be mounted by other NFS clients in your network.
         * </p>
         * <p>
         * To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS
         * client that has access to your server. You can specify any directory that appears in the results, and any
         * subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
         * </p>
         * <p>
         * To transfer all the data in the folder that you specified, DataSync must have permissions to read all the
         * data. To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure that the
         * files you want DataSync to access have permissions that allow read access for all users. Doing either option
         * enables the agent to read the files. For the agent to access directories, you must additionally enable all
         * execute access.
         * </p>
         * <p>
         * If you are copying data to or from your Snowcone device, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS
         * Server on Snowcone</a> for more information.
         * </p>
         * 
         * @param subdirectory
         *        Specifies the subdirectory in your NFS file system that DataSync uses to read from or write to during
         *        a transfer. The NFS path should be exported by the NFS server, or a subdirectory of that path. The
         *        path should be such that it can be mounted by other NFS clients in your network.</p>
         *        <p>
         *        To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from
         *        an NFS client that has access to your server. You can specify any directory that appears in the
         *        results, and any subdirectory of that directory. Ensure that the NFS export is accessible without
         *        Kerberos authentication.
         *        </p>
         *        <p>
         *        To transfer all the data in the folder that you specified, DataSync must have permissions to read all
         *        the data. To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure
         *        that the files you want DataSync to access have permissions that allow read access for all users.
         *        Doing either option enables the agent to read the files. For the agent to access directories, you must
         *        additionally enable all execute access.
         *        </p>
         *        <p>
         *        If you are copying data to or from your Snowcone device, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS
         *        Server on Snowcone</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * Sets the value of the OnPremConfig property for this object.
         *
         * @param onPremConfig
         *        The new value for the OnPremConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremConfig(OnPremConfig onPremConfig);

        /**
         * Sets the value of the OnPremConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OnPremConfig.Builder} avoiding the need
         * to create one manually via {@link OnPremConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnPremConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremConfig(OnPremConfig)}.
         * 
         * @param onPremConfig
         *        a consumer that will call methods on {@link OnPremConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremConfig(OnPremConfig)
         */
        default Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return onPremConfig(OnPremConfig.builder().applyMutation(onPremConfig).build());
        }

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * @param mountOptions
         *        The new value for the MountOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(NfsMountOptions mountOptions);

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NfsMountOptions.Builder} avoiding the
         * need to create one manually via {@link NfsMountOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NfsMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(NfsMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link NfsMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(NfsMountOptions)
         */
        default Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return mountOptions(NfsMountOptions.builder().applyMutation(mountOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private String subdirectory;

        private OnPremConfig onPremConfig;

        private NfsMountOptions mountOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationNfsRequest model) {
            super(model);
            locationArn(model.locationArn);
            subdirectory(model.subdirectory);
            onPremConfig(model.onPremConfig);
            mountOptions(model.mountOptions);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return onPremConfig != null ? onPremConfig.toBuilder() : null;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationNfsRequest build() {
            return new UpdateLocationNfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
