/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how you want to configure a task report, which provides detailed information about for your DataSync
 * transfer.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html">Task reports</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskReportConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskReportConfig.Builder, TaskReportConfig> {
    private static final SdkField<ReportDestination> DESTINATION_FIELD = SdkField
            .<ReportDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(TaskReportConfig::destination)).setter(setter(Builder::destination))
            .constructor(ReportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(TaskReportConfig::outputTypeAsString)).setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()).build();

    private static final SdkField<String> REPORT_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportLevel").getter(getter(TaskReportConfig::reportLevelAsString)).setter(setter(Builder::reportLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportLevel").build()).build();

    private static final SdkField<String> OBJECT_VERSION_IDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectVersionIds").getter(getter(TaskReportConfig::objectVersionIdsAsString))
            .setter(setter(Builder::objectVersionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersionIds").build()).build();

    private static final SdkField<ReportOverrides> OVERRIDES_FIELD = SdkField.<ReportOverrides> builder(MarshallingType.SDK_POJO)
            .memberName("Overrides").getter(getter(TaskReportConfig::overrides)).setter(setter(Builder::overrides))
            .constructor(ReportOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            OUTPUT_TYPE_FIELD, REPORT_LEVEL_FIELD, OBJECT_VERSION_IDS_FIELD, OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReportDestination destination;

    private final String outputType;

    private final String reportLevel;

    private final String objectVersionIds;

    private final ReportOverrides overrides;

    private TaskReportConfig(BuilderImpl builder) {
        this.destination = builder.destination;
        this.outputType = builder.outputType;
        this.reportLevel = builder.reportLevel;
        this.objectVersionIds = builder.objectVersionIds;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * Specifies the Amazon S3 bucket where DataSync uploads your task report. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html#task-report-access">Task
     * reports</a>.
     * </p>
     * 
     * @return Specifies the Amazon S3 bucket where DataSync uploads your task report. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html#task-report-access"
     *         >Task reports</a>.
     */
    public final ReportDestination destination() {
        return destination;
    }

    /**
     * <p>
     * Specifies the type of task report that you want:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files, objects,
     * and directories transferred and transfer duration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code>: Provides complete details about your task, including a full list of files, objects, and
     * directories that were transferred, skipped, verified, and more.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link ReportOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of task report that you want:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files,
     *         objects, and directories transferred and transfer duration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Provides complete details about your task, including a full list of files,
     *         objects, and directories that were transferred, skipped, verified, and more.
     *         </p>
     *         </li>
     * @see ReportOutputType
     */
    public final ReportOutputType outputType() {
        return ReportOutputType.fromValue(outputType);
    }

    /**
     * <p>
     * Specifies the type of task report that you want:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files, objects,
     * and directories transferred and transfer duration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code>: Provides complete details about your task, including a full list of files, objects, and
     * directories that were transferred, skipped, verified, and more.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link ReportOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of task report that you want:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files,
     *         objects, and directories transferred and transfer duration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Provides complete details about your task, including a full list of files,
     *         objects, and directories that were transferred, skipped, verified, and more.
     *         </p>
     *         </li>
     * @see ReportOutputType
     */
    public final String outputTypeAsString() {
        return outputType;
    }

    /**
     * <p>
     * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what
     * succeeded and didn't.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip, verify,
     * and delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportLevel} will
     * return {@link ReportLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportLevelAsString}.
     * </p>
     * 
     * @return Specifies whether you want your task report to include only what went wrong with your transfer or a list
     *         of what succeeded and didn't.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip,
     *         verify, and delete.
     *         </p>
     *         </li>
     * @see ReportLevel
     */
    public final ReportLevel reportLevel() {
        return ReportLevel.fromValue(reportLevel);
    }

    /**
     * <p>
     * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what
     * succeeded and didn't.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip, verify,
     * and delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportLevel} will
     * return {@link ReportLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportLevelAsString}.
     * </p>
     * 
     * @return Specifies whether you want your task report to include only what went wrong with your transfer or a list
     *         of what succeeded and didn't.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip,
     *         verify, and delete.
     *         </p>
     *         </li>
     * @see ReportLevel
     */
    public final String reportLevelAsString() {
        return reportLevel;
    }

    /**
     * <p>
     * Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This
     * only applies if you <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable versioning on
     * your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the duration of your task
     * execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectVersionIds}
     * will return {@link ObjectVersionIds#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectVersionIdsAsString}.
     * </p>
     * 
     * @return Specifies whether your task report includes the new version of each object transferred into an S3 bucket.
     *         This only applies if you <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable
     *         versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the
     *         duration of your task execution.
     * @see ObjectVersionIds
     */
    public final ObjectVersionIds objectVersionIds() {
        return ObjectVersionIds.fromValue(objectVersionIds);
    }

    /**
     * <p>
     * Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This
     * only applies if you <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable versioning on
     * your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the duration of your task
     * execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectVersionIds}
     * will return {@link ObjectVersionIds#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectVersionIdsAsString}.
     * </p>
     * 
     * @return Specifies whether your task report includes the new version of each object transferred into an S3 bucket.
     *         This only applies if you <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable
     *         versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the
     *         duration of your task execution.
     * @see ObjectVersionIds
     */
    public final String objectVersionIdsAsString() {
        return objectVersionIds;
    }

    /**
     * <p>
     * Customizes the reporting level for aspects of your task report. For example, your report might generally only
     * include errors, but you could specify that you want a list of successes and errors just for the files that
     * DataSync attempted to delete in your destination location.
     * </p>
     * 
     * @return Customizes the reporting level for aspects of your task report. For example, your report might generally
     *         only include errors, but you could specify that you want a list of successes and errors just for the
     *         files that DataSync attempted to delete in your destination location.
     */
    public final ReportOverrides overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reportLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(objectVersionIdsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskReportConfig)) {
            return false;
        }
        TaskReportConfig other = (TaskReportConfig) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(outputTypeAsString(), other.outputTypeAsString())
                && Objects.equals(reportLevelAsString(), other.reportLevelAsString())
                && Objects.equals(objectVersionIdsAsString(), other.objectVersionIdsAsString())
                && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskReportConfig").add("Destination", destination()).add("OutputType", outputTypeAsString())
                .add("ReportLevel", reportLevelAsString()).add("ObjectVersionIds", objectVersionIdsAsString())
                .add("Overrides", overrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputTypeAsString()));
        case "ReportLevel":
            return Optional.ofNullable(clazz.cast(reportLevelAsString()));
        case "ObjectVersionIds":
            return Optional.ofNullable(clazz.cast(objectVersionIdsAsString()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskReportConfig, T> g) {
        return obj -> g.apply((TaskReportConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskReportConfig> {
        /**
         * <p>
         * Specifies the Amazon S3 bucket where DataSync uploads your task report. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html#task-report-access"
         * >Task reports</a>.
         * </p>
         * 
         * @param destination
         *        Specifies the Amazon S3 bucket where DataSync uploads your task report. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html#task-report-access"
         *        >Task reports</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(ReportDestination destination);

        /**
         * <p>
         * Specifies the Amazon S3 bucket where DataSync uploads your task report. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html#task-report-access"
         * >Task reports</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportDestination.Builder} avoiding the
         * need to create one manually via {@link ReportDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(ReportDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link ReportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(ReportDestination)
         */
        default Builder destination(Consumer<ReportDestination.Builder> destination) {
            return destination(ReportDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Specifies the type of task report that you want:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files,
         * objects, and directories transferred and transfer duration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code>: Provides complete details about your task, including a full list of files, objects,
         * and directories that were transferred, skipped, verified, and more.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputType
         *        Specifies the type of task report that you want:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files,
         *        objects, and directories transferred and transfer duration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Provides complete details about your task, including a full list of files,
         *        objects, and directories that were transferred, skipped, verified, and more.
         *        </p>
         *        </li>
         * @see ReportOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportOutputType
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * Specifies the type of task report that you want:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files,
         * objects, and directories transferred and transfer duration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code>: Provides complete details about your task, including a full list of files, objects,
         * and directories that were transferred, skipped, verified, and more.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputType
         *        Specifies the type of task report that you want:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files,
         *        objects, and directories transferred and transfer duration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Provides complete details about your task, including a full list of files,
         *        objects, and directories that were transferred, skipped, verified, and more.
         *        </p>
         *        </li>
         * @see ReportOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportOutputType
         */
        Builder outputType(ReportOutputType outputType);

        /**
         * <p>
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of
         * what succeeded and didn't.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip,
         * verify, and delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reportLevel
         *        Specifies whether you want your task report to include only what went wrong with your transfer or a
         *        list of what succeeded and didn't.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and
         *        delete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip,
         *        verify, and delete.
         *        </p>
         *        </li>
         * @see ReportLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportLevel
         */
        Builder reportLevel(String reportLevel);

        /**
         * <p>
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of
         * what succeeded and didn't.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip,
         * verify, and delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reportLevel
         *        Specifies whether you want your task report to include only what went wrong with your transfer or a
         *        list of what succeeded and didn't.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and
         *        delete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip,
         *        verify, and delete.
         *        </p>
         *        </li>
         * @see ReportLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportLevel
         */
        Builder reportLevel(ReportLevel reportLevel);

        /**
         * <p>
         * Specifies whether your task report includes the new version of each object transferred into an S3 bucket.
         * This only applies if you <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable
         * versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the
         * duration of your task execution.
         * </p>
         * 
         * @param objectVersionIds
         *        Specifies whether your task report includes the new version of each object transferred into an S3
         *        bucket. This only applies if you <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable
         *        versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the
         *        duration of your task execution.
         * @see ObjectVersionIds
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectVersionIds
         */
        Builder objectVersionIds(String objectVersionIds);

        /**
         * <p>
         * Specifies whether your task report includes the new version of each object transferred into an S3 bucket.
         * This only applies if you <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable
         * versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the
         * duration of your task execution.
         * </p>
         * 
         * @param objectVersionIds
         *        Specifies whether your task report includes the new version of each object transferred into an S3
         *        bucket. This only applies if you <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable
         *        versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the
         *        duration of your task execution.
         * @see ObjectVersionIds
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectVersionIds
         */
        Builder objectVersionIds(ObjectVersionIds objectVersionIds);

        /**
         * <p>
         * Customizes the reporting level for aspects of your task report. For example, your report might generally only
         * include errors, but you could specify that you want a list of successes and errors just for the files that
         * DataSync attempted to delete in your destination location.
         * </p>
         * 
         * @param overrides
         *        Customizes the reporting level for aspects of your task report. For example, your report might
         *        generally only include errors, but you could specify that you want a list of successes and errors just
         *        for the files that DataSync attempted to delete in your destination location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(ReportOverrides overrides);

        /**
         * <p>
         * Customizes the reporting level for aspects of your task report. For example, your report might generally only
         * include errors, but you could specify that you want a list of successes and errors just for the files that
         * DataSync attempted to delete in your destination location.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportOverrides.Builder} avoiding the
         * need to create one manually via {@link ReportOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #overrides(ReportOverrides)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link ReportOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(ReportOverrides)
         */
        default Builder overrides(Consumer<ReportOverrides.Builder> overrides) {
            return overrides(ReportOverrides.builder().applyMutation(overrides).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReportDestination destination;

        private String outputType;

        private String reportLevel;

        private String objectVersionIds;

        private ReportOverrides overrides;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskReportConfig model) {
            destination(model.destination);
            outputType(model.outputType);
            reportLevel(model.reportLevel);
            objectVersionIds(model.objectVersionIds);
            overrides(model.overrides);
        }

        public final ReportDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(ReportDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(ReportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(ReportOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final String getReportLevel() {
            return reportLevel;
        }

        public final void setReportLevel(String reportLevel) {
            this.reportLevel = reportLevel;
        }

        @Override
        public final Builder reportLevel(String reportLevel) {
            this.reportLevel = reportLevel;
            return this;
        }

        @Override
        public final Builder reportLevel(ReportLevel reportLevel) {
            this.reportLevel(reportLevel == null ? null : reportLevel.toString());
            return this;
        }

        public final String getObjectVersionIds() {
            return objectVersionIds;
        }

        public final void setObjectVersionIds(String objectVersionIds) {
            this.objectVersionIds = objectVersionIds;
        }

        @Override
        public final Builder objectVersionIds(String objectVersionIds) {
            this.objectVersionIds = objectVersionIds;
            return this;
        }

        @Override
        public final Builder objectVersionIds(ObjectVersionIds objectVersionIds) {
            this.objectVersionIds(objectVersionIds == null ? null : objectVersionIds.toString());
            return this;
        }

        public final ReportOverrides.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        public final void setOverrides(ReportOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(ReportOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        @Override
        public TaskReportConfig build() {
            return new TaskReportConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
