/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeAgentResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgentResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeAgentResponse.Builder, DescribeAgentResponse> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentArn").getter(getter(DescribeAgentResponse::agentArn)).setter(setter(Builder::agentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeAgentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeAgentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_CONNECTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastConnectionTime").getter(getter(DescribeAgentResponse::lastConnectionTime))
            .setter(setter(Builder::lastConnectionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastConnectionTime").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAgentResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(DescribeAgentResponse::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<PrivateLinkConfig> PRIVATE_LINK_CONFIG_FIELD = SdkField
            .<PrivateLinkConfig> builder(MarshallingType.SDK_POJO).memberName("PrivateLinkConfig")
            .getter(getter(DescribeAgentResponse::privateLinkConfig)).setter(setter(Builder::privateLinkConfig))
            .constructor(PrivateLinkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLinkConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD,
            STATUS_FIELD, LAST_CONNECTION_TIME_FIELD, CREATION_TIME_FIELD, ENDPOINT_TYPE_FIELD, PRIVATE_LINK_CONFIG_FIELD));

    private final String agentArn;

    private final String name;

    private final String status;

    private final Instant lastConnectionTime;

    private final Instant creationTime;

    private final String endpointType;

    private final PrivateLinkConfig privateLinkConfig;

    private DescribeAgentResponse(BuilderImpl builder) {
        super(builder);
        this.agentArn = builder.agentArn;
        this.name = builder.name;
        this.status = builder.status;
        this.lastConnectionTime = builder.lastConnectionTime;
        this.creationTime = builder.creationTime;
        this.endpointType = builder.endpointType;
        this.privateLinkConfig = builder.privateLinkConfig;
    }

    /**
     * <p>
     * The ARN of the agent.
     * </p>
     * 
     * @return The ARN of the agent.
     */
    public final String agentArn() {
        return agentArn;
    }

    /**
     * <p>
     * The name of the agent.
     * </p>
     * 
     * @return The name of the agent.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use.
     * The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned
     * off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent
     * returns to ONLINE status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the agent. If the status is ONLINE, then the agent is configured properly and is available
     *         to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the
     *         agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy
     *         state is resolved, the agent returns to ONLINE status.
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use.
     * The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned
     * off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent
     * returns to ONLINE status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the agent. If the status is ONLINE, then the agent is configured properly and is available
     *         to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the
     *         agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy
     *         state is resolved, the agent returns to ONLINE status.
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the agent last connected to DataSync.
     * </p>
     * 
     * @return The time that the agent last connected to DataSync.
     */
    public final Instant lastConnectionTime() {
        return lastConnectionTime;
    }

    /**
     * <p>
     * The time that the agent was activated (that is, created in your account).
     * </p>
     * 
     * @return The time that the agent was activated (that is, created in your account).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not
     * accessible over the public internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not
     *         accessible over the public internet.
     * @see EndpointType
     */
    public final EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not
     * accessible over the public internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not
     *         accessible over the public internet.
     * @see EndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The subnet and the security group that DataSync used to access a VPC endpoint.
     * </p>
     * 
     * @return The subnet and the security group that DataSync used to access a VPC endpoint.
     */
    public final PrivateLinkConfig privateLinkConfig() {
        return privateLinkConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastConnectionTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateLinkConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentResponse)) {
            return false;
        }
        DescribeAgentResponse other = (DescribeAgentResponse) obj;
        return Objects.equals(agentArn(), other.agentArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastConnectionTime(), other.lastConnectionTime())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(privateLinkConfig(), other.privateLinkConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgentResponse").add("AgentArn", agentArn()).add("Name", name())
                .add("Status", statusAsString()).add("LastConnectionTime", lastConnectionTime())
                .add("CreationTime", creationTime()).add("EndpointType", endpointTypeAsString())
                .add("PrivateLinkConfig", privateLinkConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentArn":
            return Optional.ofNullable(clazz.cast(agentArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastConnectionTime":
            return Optional.ofNullable(clazz.cast(lastConnectionTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "PrivateLinkConfig":
            return Optional.ofNullable(clazz.cast(privateLinkConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentResponse, T> g) {
        return obj -> g.apply((DescribeAgentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAgentResponse> {
        /**
         * <p>
         * The ARN of the agent.
         * </p>
         * 
         * @param agentArn
         *        The ARN of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArn(String agentArn);

        /**
         * <p>
         * The name of the agent.
         * </p>
         * 
         * @param name
         *        The name of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to
         * use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM
         * is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is
         * resolved, the agent returns to ONLINE status.
         * </p>
         * 
         * @param status
         *        The status of the agent. If the status is ONLINE, then the agent is configured properly and is
         *        available to use. The Running status is the normal running status for an agent. If the status is
         *        OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that
         *        caused the unhealthy state is resolved, the agent returns to ONLINE status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to
         * use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM
         * is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is
         * resolved, the agent returns to ONLINE status.
         * </p>
         * 
         * @param status
         *        The status of the agent. If the status is ONLINE, then the agent is configured properly and is
         *        available to use. The Running status is the normal running status for an agent. If the status is
         *        OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that
         *        caused the unhealthy state is resolved, the agent returns to ONLINE status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);

        /**
         * <p>
         * The time that the agent last connected to DataSync.
         * </p>
         * 
         * @param lastConnectionTime
         *        The time that the agent last connected to DataSync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastConnectionTime(Instant lastConnectionTime);

        /**
         * <p>
         * The time that the agent was activated (that is, created in your account).
         * </p>
         * 
         * @param creationTime
         *        The time that the agent was activated (that is, created in your account).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not
         * accessible over the public internet.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is
         *        not accessible over the public internet.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not
         * accessible over the public internet.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is
         *        not accessible over the public internet.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * The subnet and the security group that DataSync used to access a VPC endpoint.
         * </p>
         * 
         * @param privateLinkConfig
         *        The subnet and the security group that DataSync used to access a VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateLinkConfig(PrivateLinkConfig privateLinkConfig);

        /**
         * <p>
         * The subnet and the security group that DataSync used to access a VPC endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateLinkConfig.Builder} avoiding the
         * need to create one manually via {@link PrivateLinkConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateLinkConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #privateLinkConfig(PrivateLinkConfig)}.
         * 
         * @param privateLinkConfig
         *        a consumer that will call methods on {@link PrivateLinkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateLinkConfig(PrivateLinkConfig)
         */
        default Builder privateLinkConfig(Consumer<PrivateLinkConfig.Builder> privateLinkConfig) {
            return privateLinkConfig(PrivateLinkConfig.builder().applyMutation(privateLinkConfig).build());
        }
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String agentArn;

        private String name;

        private String status;

        private Instant lastConnectionTime;

        private Instant creationTime;

        private String endpointType;

        private PrivateLinkConfig privateLinkConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentResponse model) {
            super(model);
            agentArn(model.agentArn);
            name(model.name);
            status(model.status);
            lastConnectionTime(model.lastConnectionTime);
            creationTime(model.creationTime);
            endpointType(model.endpointType);
            privateLinkConfig(model.privateLinkConfig);
        }

        public final String getAgentArn() {
            return agentArn;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastConnectionTime() {
            return lastConnectionTime;
        }

        public final void setLastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
        }

        @Override
        public final Builder lastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final PrivateLinkConfig.Builder getPrivateLinkConfig() {
            return privateLinkConfig != null ? privateLinkConfig.toBuilder() : null;
        }

        public final void setPrivateLinkConfig(PrivateLinkConfig.BuilderImpl privateLinkConfig) {
            this.privateLinkConfig = privateLinkConfig != null ? privateLinkConfig.build() : null;
        }

        @Override
        public final Builder privateLinkConfig(PrivateLinkConfig privateLinkConfig) {
            this.privateLinkConfig = privateLinkConfig;
            return this;
        }

        @Override
        public DescribeAgentResponse build() {
            return new DescribeAgentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
