/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.DataSyncClientBuilder;
import software.amazon.awssdk.services.datasync.DataSyncServiceClientConfiguration;
import software.amazon.awssdk.services.datasync.DefaultDataSyncBaseClientBuilder;
import software.amazon.awssdk.services.datasync.DefaultDataSyncClient;
import software.amazon.awssdk.services.datasync.endpoints.DataSyncEndpointProvider;

@SdkInternalApi
final class DefaultDataSyncClientBuilder
extends DefaultDataSyncBaseClientBuilder<DataSyncClientBuilder, DataSyncClient>
implements DataSyncClientBuilder {
    DefaultDataSyncClientBuilder() {
    }

    @Override
    public DefaultDataSyncClientBuilder endpointProvider(DataSyncEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataSyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataSyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DataSyncServiceClientConfiguration serviceClientConfiguration = DataSyncServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDataSyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

