/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateAgentRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateAgentRequest.Builder, UpdateAgentRequest> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentArn").getter(getter(UpdateAgentRequest::agentArn)).setter(setter(Builder::agentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAgentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD));

    private final String agentArn;

    private final String name;

    private UpdateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentArn = builder.agentArn;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent to update.
     */
    public final String agentArn() {
        return agentArn;
    }

    /**
     * <p>
     * The name that you want to use to configure the agent.
     * </p>
     * 
     * @return The name that you want to use to configure the agent.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRequest)) {
            return false;
        }
        UpdateAgentRequest other = (UpdateAgentRequest) obj;
        return Objects.equals(agentArn(), other.agentArn()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgentRequest").add("AgentArn", agentArn()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentArn":
            return Optional.ofNullable(clazz.cast(agentArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRequest, T> g) {
        return obj -> g.apply((UpdateAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgentRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent to update.
         * </p>
         * 
         * @param agentArn
         *        The Amazon Resource Name (ARN) of the agent to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArn(String agentArn);

        /**
         * <p>
         * The name that you want to use to configure the agent.
         * </p>
         * 
         * @param name
         *        The name that you want to use to configure the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String agentArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRequest model) {
            super(model);
            agentArn(model.agentArn);
            name(model.name);
        }

        public final String getAgentArn() {
            return agentArn;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentRequest build() {
            return new UpdateAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
