/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single entry in a list (or array) of DataSync agents when you call the <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html">ListAgents</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentListEntry implements SdkPojo, Serializable, ToCopyableBuilder<AgentListEntry.Builder, AgentListEntry> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentArn").getter(getter(AgentListEntry::agentArn)).setter(setter(Builder::agentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AgentListEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AgentListEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Platform> PLATFORM_FIELD = SdkField.<Platform> builder(MarshallingType.SDK_POJO)
            .memberName("Platform").getter(getter(AgentListEntry::platform)).setter(setter(Builder::platform))
            .constructor(Platform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD,
            STATUS_FIELD, PLATFORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentArn;

    private final String name;

    private final String status;

    private final Platform platform;

    private AgentListEntry(BuilderImpl builder) {
        this.agentArn = builder.agentArn;
        this.name = builder.name;
        this.status = builder.status;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a DataSync agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a DataSync agent.
     */
    public final String agentArn() {
        return agentArn;
    }

    /**
     * <p>
     * The name of an agent.
     * </p>
     * 
     * @return The name of an agent.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of an agent.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes or
     * longer. This can happen for a few reasons. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
     * >What do I do if my agent is offline?</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an agent.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes
     *         or longer. This can happen for a few reasons. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
     *         >What do I do if my agent is offline?</a>
     *         </p>
     *         </li>
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of an agent.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes or
     * longer. This can happen for a few reasons. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
     * >What do I do if my agent is offline?</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an agent.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes
     *         or longer. This can happen for a few reasons. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
     *         >What do I do if my agent is offline?</a>
     *         </p>
     *         </li>
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The platform-related details about the agent, such as the version number.
     * </p>
     * 
     * @return The platform-related details about the agent, such as the version number.
     */
    public final Platform platform() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentListEntry)) {
            return false;
        }
        AgentListEntry other = (AgentListEntry) obj;
        return Objects.equals(agentArn(), other.agentArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(platform(), other.platform());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentListEntry").add("AgentArn", agentArn()).add("Name", name()).add("Status", statusAsString())
                .add("Platform", platform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentArn":
            return Optional.ofNullable(clazz.cast(agentArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentListEntry, T> g) {
        return obj -> g.apply((AgentListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentListEntry> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a DataSync agent.
         * </p>
         * 
         * @param agentArn
         *        The Amazon Resource Name (ARN) of a DataSync agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArn(String agentArn);

        /**
         * <p>
         * The name of an agent.
         * </p>
         * 
         * @param name
         *        The name of an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of an agent.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes or
         * longer. This can happen for a few reasons. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
         * >What do I do if my agent is offline?</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of an agent.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five
         *        minutes or longer. This can happen for a few reasons. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
         *        >What do I do if my agent is offline?</a>
         *        </p>
         *        </li>
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of an agent.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes or
         * longer. This can happen for a few reasons. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
         * >What do I do if my agent is offline?</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of an agent.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five
         *        minutes or longer. This can happen for a few reasons. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline"
         *        >What do I do if my agent is offline?</a>
         *        </p>
         *        </li>
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);

        /**
         * <p>
         * The platform-related details about the agent, such as the version number.
         * </p>
         * 
         * @param platform
         *        The platform-related details about the agent, such as the version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The platform-related details about the agent, such as the version number.
         * </p>
         * This is a convenience method that creates an instance of the {@link Platform.Builder} avoiding the need to
         * create one manually via {@link Platform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Platform.Builder#build()} is called immediately and its result is
         * passed to {@link #platform(Platform)}.
         * 
         * @param platform
         *        a consumer that will call methods on {@link Platform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platform(Platform)
         */
        default Builder platform(Consumer<Platform.Builder> platform) {
            return platform(Platform.builder().applyMutation(platform).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String agentArn;

        private String name;

        private String status;

        private Platform platform;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentListEntry model) {
            agentArn(model.agentArn);
            name(model.name);
            status(model.status);
            platform(model.platform);
        }

        public final String getAgentArn() {
            return agentArn;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Platform.Builder getPlatform() {
            return platform != null ? platform.toBuilder() : null;
        }

        public final void setPlatform(Platform.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public AgentListEntry build() {
            return new AgentListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
