/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The platform-related details about the DataSync agent, such as the version number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Platform implements SdkPojo, Serializable, ToCopyableBuilder<Platform.Builder, Platform> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(Platform::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String version;

    private Platform(BuilderImpl builder) {
        this.version = builder.version;
    }

    /**
     * <p>
     * The version of the DataSync agent.
     * </p>
     * <important>
     * <p>
     * Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to see if
     * you have affected agents. If you do, <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents before
     * then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     * href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     * </p>
     * </important>
     * 
     * @return The version of the DataSync agent.</p> <important>
     *         <p>
     *         Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to
     *         see if you have affected agents. If you do, <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those
     *         agents before then to avoid data transfer or storage discovery disruptions. If you need more help,
     *         contact <a href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     *         </p>
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Platform)) {
            return false;
        }
        Platform other = (Platform) obj;
        return Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Platform").add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Platform, T> g) {
        return obj -> g.apply((Platform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Platform> {
        /**
         * <p>
         * The version of the DataSync agent.
         * </p>
         * <important>
         * <p>
         * Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to see
         * if you have affected agents. If you do, <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents
         * before then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
         * href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
         * </p>
         * </important>
         * 
         * @param version
         *        The version of the DataSync agent.</p> <important>
         *        <p>
         *        Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console
         *        to see if you have affected agents. If you do, <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those
         *        agents before then to avoid data transfer or storage discovery disruptions. If you need more help,
         *        contact <a href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(Platform model) {
            version(model.version);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Platform build() {
            return new Platform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
