/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTaskExecutionResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskExecutionResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeTaskExecutionResponse.Builder, DescribeTaskExecutionResponse> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskExecutionArn").getter(getter(DescribeTaskExecutionResponse::taskExecutionArn))
            .setter(setter(Builder::taskExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeTaskExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Options> OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(DescribeTaskExecutionResponse::options)).setter(setter(Builder::options))
            .constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Excludes")
            .getter(getter(DescribeTaskExecutionResponse::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Includes")
            .getter(getter(DescribeTaskExecutionResponse::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeTaskExecutionResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Long> ESTIMATED_FILES_TO_TRANSFER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedFilesToTransfer").getter(getter(DescribeTaskExecutionResponse::estimatedFilesToTransfer))
            .setter(setter(Builder::estimatedFilesToTransfer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedFilesToTransfer").build())
            .build();

    private static final SdkField<Long> ESTIMATED_BYTES_TO_TRANSFER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedBytesToTransfer").getter(getter(DescribeTaskExecutionResponse::estimatedBytesToTransfer))
            .setter(setter(Builder::estimatedBytesToTransfer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedBytesToTransfer").build())
            .build();

    private static final SdkField<Long> FILES_TRANSFERRED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FilesTransferred").getter(getter(DescribeTaskExecutionResponse::filesTransferred))
            .setter(setter(Builder::filesTransferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesTransferred").build()).build();

    private static final SdkField<Long> BYTES_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesWritten").getter(getter(DescribeTaskExecutionResponse::bytesWritten))
            .setter(setter(Builder::bytesWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesWritten").build()).build();

    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesTransferred").getter(getter(DescribeTaskExecutionResponse::bytesTransferred))
            .setter(setter(Builder::bytesTransferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()).build();

    private static final SdkField<TaskExecutionResultDetail> RESULT_FIELD = SdkField
            .<TaskExecutionResultDetail> builder(MarshallingType.SDK_POJO).memberName("Result")
            .getter(getter(DescribeTaskExecutionResponse::result)).setter(setter(Builder::result))
            .constructor(TaskExecutionResultDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<Long> BYTES_COMPRESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesCompressed").getter(getter(DescribeTaskExecutionResponse::bytesCompressed))
            .setter(setter(Builder::bytesCompressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesCompressed").build()).build();

    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField
            .<TaskReportConfig> builder(MarshallingType.SDK_POJO).memberName("TaskReportConfig")
            .getter(getter(DescribeTaskExecutionResponse::taskReportConfig)).setter(setter(Builder::taskReportConfig))
            .constructor(TaskReportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()).build();

    private static final SdkField<Long> FILES_DELETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FilesDeleted").getter(getter(DescribeTaskExecutionResponse::filesDeleted))
            .setter(setter(Builder::filesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesDeleted").build()).build();

    private static final SdkField<Long> FILES_SKIPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FilesSkipped").getter(getter(DescribeTaskExecutionResponse::filesSkipped))
            .setter(setter(Builder::filesSkipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesSkipped").build()).build();

    private static final SdkField<Long> FILES_VERIFIED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FilesVerified").getter(getter(DescribeTaskExecutionResponse::filesVerified))
            .setter(setter(Builder::filesVerified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesVerified").build()).build();

    private static final SdkField<ReportResult> REPORT_RESULT_FIELD = SdkField.<ReportResult> builder(MarshallingType.SDK_POJO)
            .memberName("ReportResult").getter(getter(DescribeTaskExecutionResponse::reportResult))
            .setter(setter(Builder::reportResult)).constructor(ReportResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportResult").build()).build();

    private static final SdkField<Long> ESTIMATED_FILES_TO_DELETE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedFilesToDelete").getter(getter(DescribeTaskExecutionResponse::estimatedFilesToDelete))
            .setter(setter(Builder::estimatedFilesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedFilesToDelete").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD,
            STATUS_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, INCLUDES_FIELD, START_TIME_FIELD, ESTIMATED_FILES_TO_TRANSFER_FIELD,
            ESTIMATED_BYTES_TO_TRANSFER_FIELD, FILES_TRANSFERRED_FIELD, BYTES_WRITTEN_FIELD, BYTES_TRANSFERRED_FIELD,
            RESULT_FIELD, BYTES_COMPRESSED_FIELD, TASK_REPORT_CONFIG_FIELD, FILES_DELETED_FIELD, FILES_SKIPPED_FIELD,
            FILES_VERIFIED_FIELD, REPORT_RESULT_FIELD, ESTIMATED_FILES_TO_DELETE_FIELD));

    private final String taskExecutionArn;

    private final String status;

    private final Options options;

    private final List<FilterRule> excludes;

    private final List<FilterRule> includes;

    private final Instant startTime;

    private final Long estimatedFilesToTransfer;

    private final Long estimatedBytesToTransfer;

    private final Long filesTransferred;

    private final Long bytesWritten;

    private final Long bytesTransferred;

    private final TaskExecutionResultDetail result;

    private final Long bytesCompressed;

    private final TaskReportConfig taskReportConfig;

    private final Long filesDeleted;

    private final Long filesSkipped;

    private final Long filesVerified;

    private final ReportResult reportResult;

    private final Long estimatedFilesToDelete;

    private DescribeTaskExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutionArn = builder.taskExecutionArn;
        this.status = builder.status;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.startTime = builder.startTime;
        this.estimatedFilesToTransfer = builder.estimatedFilesToTransfer;
        this.estimatedBytesToTransfer = builder.estimatedBytesToTransfer;
        this.filesTransferred = builder.filesTransferred;
        this.bytesWritten = builder.bytesWritten;
        this.bytesTransferred = builder.bytesTransferred;
        this.result = builder.result;
        this.bytesCompressed = builder.bytesCompressed;
        this.taskReportConfig = builder.taskReportConfig;
        this.filesDeleted = builder.filesDeleted;
        this.filesSkipped = builder.filesSkipped;
        this.filesVerified = builder.filesVerified;
        this.reportResult = builder.reportResult;
        this.estimatedFilesToDelete = builder.estimatedFilesToDelete;
    }

    /**
     * <p>
     * The ARN of the task execution that you wanted information about. <code>TaskExecutionArn</code> is hierarchical
     * and includes <code>TaskArn</code> for the task that was executed.
     * </p>
     * <p>
     * For example, a <code>TaskExecution</code> value with the ARN
     * <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
     * executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
     * </p>
     * 
     * @return The ARN of the task execution that you wanted information about. <code>TaskExecutionArn</code> is
     *         hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
     *         <p>
     *         For example, a <code>TaskExecution</code> value with the ARN
     *         <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
     *         executed the task with the ARN
     *         <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
     */
    public final String taskExecutionArn() {
        return taskExecutionArn;
    }

    /**
     * <p>
     * The status of the task execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task execution.
     * @see TaskExecutionStatus
     */
    public final TaskExecutionStatus status() {
        return TaskExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task execution.
     * @see TaskExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the Options property for this object.
     * 
     * @return The value of the Options property for this object.
     */
    public final Options options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that exclude specific data during your transfer. For more information and examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred by
     * DataSync</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return A list of filter rules that exclude specific data during your transfer. For more information and
     *         examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
     *         data transferred by DataSync</a>.
     */
    public final List<FilterRule> excludes() {
        return excludes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that include specific data during your transfer. For more information and examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred by
     * DataSync</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return A list of filter rules that include specific data during your transfer. For more information and
     *         examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
     *         data transferred by DataSync</a>.
     */
    public final List<FilterRule> includes() {
        return includes;
    }

    /**
     * <p>
     * The time when the task execution started.
     * </p>
     * 
     * @return The time when the task execution started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The expected number of files, objects, and directories that DataSync will transfer over the network. This value
     * is calculated during the task execution's <code>PREPARING</code> phase before the <code>TRANSFERRING</code>
     * phase. The calculation is based on comparing the content of the source and destination locations and finding the
     * difference that needs to be transferred.
     * </p>
     * 
     * @return The expected number of files, objects, and directories that DataSync will transfer over the network. This
     *         value is calculated during the task execution's <code>PREPARING</code> phase before the
     *         <code>TRANSFERRING</code> phase. The calculation is based on comparing the content of the source and
     *         destination locations and finding the difference that needs to be transferred.
     */
    public final Long estimatedFilesToTransfer() {
        return estimatedFilesToTransfer;
    }

    /**
     * <p>
     * The estimated physical number of bytes that will transfer over the network.
     * </p>
     * 
     * @return The estimated physical number of bytes that will transfer over the network.
     */
    public final Long estimatedBytesToTransfer() {
        return estimatedBytesToTransfer;
    }

    /**
     * <p>
     * The actual number of files, objects, and directories that DataSync transferred over the network. This value is
     * updated periodically during the task execution's <code>TRANSFERRING</code> phase when something is read from the
     * source and sent over the network.
     * </p>
     * <p>
     * If DataSync fails to transfer something, this value can be less than <code>EstimatedFilesToTransfer</code>. In
     * some cases, this value can also be greater than <code>EstimatedFilesToTransfer</code>. This element is
     * implementation-specific for some location types, so don't use it as an exact indication of what transferred or to
     * monitor your task execution.
     * </p>
     * 
     * @return The actual number of files, objects, and directories that DataSync transferred over the network. This
     *         value is updated periodically during the task execution's <code>TRANSFERRING</code> phase when something
     *         is read from the source and sent over the network.</p>
     *         <p>
     *         If DataSync fails to transfer something, this value can be less than
     *         <code>EstimatedFilesToTransfer</code>. In some cases, this value can also be greater than
     *         <code>EstimatedFilesToTransfer</code>. This element is implementation-specific for some location types,
     *         so don't use it as an exact indication of what transferred or to monitor your task execution.
     */
    public final Long filesTransferred() {
        return filesTransferred;
    }

    /**
     * <p>
     * The number of logical bytes written to the destination location.
     * </p>
     * 
     * @return The number of logical bytes written to the destination location.
     */
    public final Long bytesWritten() {
        return bytesWritten;
    }

    /**
     * <p>
     * The total number of bytes that are involved in the transfer. For the number of bytes sent over the network, see
     * <code>BytesCompressed</code>.
     * </p>
     * 
     * @return The total number of bytes that are involved in the transfer. For the number of bytes sent over the
     *         network, see <code>BytesCompressed</code>.
     */
    public final Long bytesTransferred() {
        return bytesTransferred;
    }

    /**
     * <p>
     * The result of the task execution.
     * </p>
     * 
     * @return The result of the task execution.
     */
    public final TaskExecutionResultDetail result() {
        return result;
    }

    /**
     * <p>
     * The physical number of bytes transferred over the network after compression was applied. In most cases, this
     * number is less than <code>BytesTransferred</code> unless the data isn't compressible.
     * </p>
     * 
     * @return The physical number of bytes transferred over the network after compression was applied. In most cases,
     *         this number is less than <code>BytesTransferred</code> unless the data isn't compressible.
     */
    public final Long bytesCompressed() {
        return bytesCompressed;
    }

    /**
     * <p>
     * The configuration of your task report, which provides detailed information about for your DataSync transfer.
     * </p>
     * 
     * @return The configuration of your task report, which provides detailed information about for your DataSync
     *         transfer.
     */
    public final TaskReportConfig taskReportConfig() {
        return taskReportConfig;
    }

    /**
     * <p>
     * The number of files, objects, and directories that DataSync deleted in your destination location. If you don't <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a> to
     * delete data in the destination that isn't in the source, the value is always <code>0</code>.
     * </p>
     * 
     * @return The number of files, objects, and directories that DataSync deleted in your destination location. If you
     *         don't <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure
     *         your task</a> to delete data in the destination that isn't in the source, the value is always
     *         <code>0</code>.
     */
    public final Long filesDeleted() {
        return filesDeleted;
    }

    /**
     * <p>
     * The number of files, objects, and directories that DataSync skipped during your transfer.
     * </p>
     * 
     * @return The number of files, objects, and directories that DataSync skipped during your transfer.
     */
    public final Long filesSkipped() {
        return filesSkipped;
    }

    /**
     * <p>
     * The number of files, objects, and directories that DataSync verified during your transfer.
     * </p>
     * <note>
     * <p>
     * When you configure your task to <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html">verify only
     * the data that's transferred</a>, DataSync doesn't verify directories in some situations or files that fail to
     * transfer.
     * </p>
     * </note>
     * 
     * @return The number of files, objects, and directories that DataSync verified during your transfer.</p> <note>
     *         <p>
     *         When you configure your task to <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html"
     *         >verify only the data that's transferred</a>, DataSync doesn't verify directories in some situations or
     *         files that fail to transfer.
     *         </p>
     */
    public final Long filesVerified() {
        return filesVerified;
    }

    /**
     * <p>
     * Indicates whether DataSync generated a complete <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your transfer.
     * </p>
     * 
     * @return Indicates whether DataSync generated a complete <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your
     *         transfer.
     */
    public final ReportResult reportResult() {
        return reportResult;
    }

    /**
     * <p>
     * The expected number of files, objects, and directories that DataSync will delete in your destination location. If
     * you don't <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
     * task</a> to delete data in the destination that isn't in the source, the value is always <code>0</code>.
     * </p>
     * 
     * @return The expected number of files, objects, and directories that DataSync will delete in your destination
     *         location. If you don't <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
     *         task</a> to delete data in the destination that isn't in the source, the value is always <code>0</code>.
     */
    public final Long estimatedFilesToDelete() {
        return estimatedFilesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedFilesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedBytesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(filesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(bytesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(bytesCompressed());
        hashCode = 31 * hashCode + Objects.hashCode(taskReportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(filesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(filesSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(filesVerified());
        hashCode = 31 * hashCode + Objects.hashCode(reportResult());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedFilesToDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskExecutionResponse)) {
            return false;
        }
        DescribeTaskExecutionResponse other = (DescribeTaskExecutionResponse) obj;
        return Objects.equals(taskExecutionArn(), other.taskExecutionArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(options(), other.options())
                && hasExcludes() == other.hasExcludes() && Objects.equals(excludes(), other.excludes())
                && hasIncludes() == other.hasIncludes() && Objects.equals(includes(), other.includes())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(estimatedFilesToTransfer(), other.estimatedFilesToTransfer())
                && Objects.equals(estimatedBytesToTransfer(), other.estimatedBytesToTransfer())
                && Objects.equals(filesTransferred(), other.filesTransferred())
                && Objects.equals(bytesWritten(), other.bytesWritten())
                && Objects.equals(bytesTransferred(), other.bytesTransferred()) && Objects.equals(result(), other.result())
                && Objects.equals(bytesCompressed(), other.bytesCompressed())
                && Objects.equals(taskReportConfig(), other.taskReportConfig())
                && Objects.equals(filesDeleted(), other.filesDeleted()) && Objects.equals(filesSkipped(), other.filesSkipped())
                && Objects.equals(filesVerified(), other.filesVerified()) && Objects.equals(reportResult(), other.reportResult())
                && Objects.equals(estimatedFilesToDelete(), other.estimatedFilesToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTaskExecutionResponse").add("TaskExecutionArn", taskExecutionArn())
                .add("Status", statusAsString()).add("Options", options()).add("Excludes", hasExcludes() ? excludes() : null)
                .add("Includes", hasIncludes() ? includes() : null).add("StartTime", startTime())
                .add("EstimatedFilesToTransfer", estimatedFilesToTransfer())
                .add("EstimatedBytesToTransfer", estimatedBytesToTransfer()).add("FilesTransferred", filesTransferred())
                .add("BytesWritten", bytesWritten()).add("BytesTransferred", bytesTransferred()).add("Result", result())
                .add("BytesCompressed", bytesCompressed()).add("TaskReportConfig", taskReportConfig())
                .add("FilesDeleted", filesDeleted()).add("FilesSkipped", filesSkipped()).add("FilesVerified", filesVerified())
                .add("ReportResult", reportResult()).add("EstimatedFilesToDelete", estimatedFilesToDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskExecutionArn":
            return Optional.ofNullable(clazz.cast(taskExecutionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EstimatedFilesToTransfer":
            return Optional.ofNullable(clazz.cast(estimatedFilesToTransfer()));
        case "EstimatedBytesToTransfer":
            return Optional.ofNullable(clazz.cast(estimatedBytesToTransfer()));
        case "FilesTransferred":
            return Optional.ofNullable(clazz.cast(filesTransferred()));
        case "BytesWritten":
            return Optional.ofNullable(clazz.cast(bytesWritten()));
        case "BytesTransferred":
            return Optional.ofNullable(clazz.cast(bytesTransferred()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "BytesCompressed":
            return Optional.ofNullable(clazz.cast(bytesCompressed()));
        case "TaskReportConfig":
            return Optional.ofNullable(clazz.cast(taskReportConfig()));
        case "FilesDeleted":
            return Optional.ofNullable(clazz.cast(filesDeleted()));
        case "FilesSkipped":
            return Optional.ofNullable(clazz.cast(filesSkipped()));
        case "FilesVerified":
            return Optional.ofNullable(clazz.cast(filesVerified()));
        case "ReportResult":
            return Optional.ofNullable(clazz.cast(reportResult()));
        case "EstimatedFilesToDelete":
            return Optional.ofNullable(clazz.cast(estimatedFilesToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskExecutionResponse, T> g) {
        return obj -> g.apply((DescribeTaskExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTaskExecutionResponse> {
        /**
         * <p>
         * The ARN of the task execution that you wanted information about. <code>TaskExecutionArn</code> is
         * hierarchical and includes <code>TaskArn</code> for the task that was executed.
         * </p>
         * <p>
         * For example, a <code>TaskExecution</code> value with the ARN
         * <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
         * executed the task with the ARN
         * <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
         * </p>
         * 
         * @param taskExecutionArn
         *        The ARN of the task execution that you wanted information about. <code>TaskExecutionArn</code> is
         *        hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
         *        <p>
         *        For example, a <code>TaskExecution</code> value with the ARN
         *        <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code>
         *        executed the task with the ARN
         *        <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionArn(String taskExecutionArn);

        /**
         * <p>
         * The status of the task execution.
         * </p>
         * 
         * @param status
         *        The status of the task execution.
         * @see TaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task execution.
         * </p>
         * 
         * @param status
         *        The status of the task execution.
         * @see TaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskExecutionStatus
         */
        Builder status(TaskExecutionStatus status);

        /**
         * Sets the value of the Options property for this object.
         *
         * @param options
         *        The new value for the Options property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Options options);

        /**
         * Sets the value of the Options property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Options.Builder} avoiding the need to
         * create one manually via {@link Options#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #options(Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Options)
         */
        default Builder options(Consumer<Options.Builder> options) {
            return options(Options.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * A list of filter rules that exclude specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that exclude specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<FilterRule> excludes);

        /**
         * <p>
         * A list of filter rules that exclude specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that exclude specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(FilterRule... excludes);

        /**
         * <p>
         * A list of filter rules that exclude specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #excludes(List<FilterRule>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(java.util.Collection<FilterRule>)
         */
        Builder excludes(Consumer<FilterRule.Builder>... excludes);

        /**
         * <p>
         * A list of filter rules that include specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param includes
         *        A list of filter rules that include specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * A list of filter rules that include specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param includes
         *        A list of filter rules that include specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * A list of filter rules that include specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(java.util.Collection<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        /**
         * <p>
         * The time when the task execution started.
         * </p>
         * 
         * @param startTime
         *        The time when the task execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The expected number of files, objects, and directories that DataSync will transfer over the network. This
         * value is calculated during the task execution's <code>PREPARING</code> phase before the
         * <code>TRANSFERRING</code> phase. The calculation is based on comparing the content of the source and
         * destination locations and finding the difference that needs to be transferred.
         * </p>
         * 
         * @param estimatedFilesToTransfer
         *        The expected number of files, objects, and directories that DataSync will transfer over the network.
         *        This value is calculated during the task execution's <code>PREPARING</code> phase before the
         *        <code>TRANSFERRING</code> phase. The calculation is based on comparing the content of the source and
         *        destination locations and finding the difference that needs to be transferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedFilesToTransfer(Long estimatedFilesToTransfer);

        /**
         * <p>
         * The estimated physical number of bytes that will transfer over the network.
         * </p>
         * 
         * @param estimatedBytesToTransfer
         *        The estimated physical number of bytes that will transfer over the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedBytesToTransfer(Long estimatedBytesToTransfer);

        /**
         * <p>
         * The actual number of files, objects, and directories that DataSync transferred over the network. This value
         * is updated periodically during the task execution's <code>TRANSFERRING</code> phase when something is read
         * from the source and sent over the network.
         * </p>
         * <p>
         * If DataSync fails to transfer something, this value can be less than <code>EstimatedFilesToTransfer</code>.
         * In some cases, this value can also be greater than <code>EstimatedFilesToTransfer</code>. This element is
         * implementation-specific for some location types, so don't use it as an exact indication of what transferred
         * or to monitor your task execution.
         * </p>
         * 
         * @param filesTransferred
         *        The actual number of files, objects, and directories that DataSync transferred over the network. This
         *        value is updated periodically during the task execution's <code>TRANSFERRING</code> phase when
         *        something is read from the source and sent over the network.</p>
         *        <p>
         *        If DataSync fails to transfer something, this value can be less than
         *        <code>EstimatedFilesToTransfer</code>. In some cases, this value can also be greater than
         *        <code>EstimatedFilesToTransfer</code>. This element is implementation-specific for some location
         *        types, so don't use it as an exact indication of what transferred or to monitor your task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesTransferred(Long filesTransferred);

        /**
         * <p>
         * The number of logical bytes written to the destination location.
         * </p>
         * 
         * @param bytesWritten
         *        The number of logical bytes written to the destination location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesWritten(Long bytesWritten);

        /**
         * <p>
         * The total number of bytes that are involved in the transfer. For the number of bytes sent over the network,
         * see <code>BytesCompressed</code>.
         * </p>
         * 
         * @param bytesTransferred
         *        The total number of bytes that are involved in the transfer. For the number of bytes sent over the
         *        network, see <code>BytesCompressed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesTransferred(Long bytesTransferred);

        /**
         * <p>
         * The result of the task execution.
         * </p>
         * 
         * @param result
         *        The result of the task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(TaskExecutionResultDetail result);

        /**
         * <p>
         * The result of the task execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskExecutionResultDetail.Builder}
         * avoiding the need to create one manually via {@link TaskExecutionResultDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskExecutionResultDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #result(TaskExecutionResultDetail)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link TaskExecutionResultDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(TaskExecutionResultDetail)
         */
        default Builder result(Consumer<TaskExecutionResultDetail.Builder> result) {
            return result(TaskExecutionResultDetail.builder().applyMutation(result).build());
        }

        /**
         * <p>
         * The physical number of bytes transferred over the network after compression was applied. In most cases, this
         * number is less than <code>BytesTransferred</code> unless the data isn't compressible.
         * </p>
         * 
         * @param bytesCompressed
         *        The physical number of bytes transferred over the network after compression was applied. In most
         *        cases, this number is less than <code>BytesTransferred</code> unless the data isn't compressible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesCompressed(Long bytesCompressed);

        /**
         * <p>
         * The configuration of your task report, which provides detailed information about for your DataSync transfer.
         * </p>
         * 
         * @param taskReportConfig
         *        The configuration of your task report, which provides detailed information about for your DataSync
         *        transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskReportConfig(TaskReportConfig taskReportConfig);

        /**
         * <p>
         * The configuration of your task report, which provides detailed information about for your DataSync transfer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskReportConfig.Builder} avoiding the
         * need to create one manually via {@link TaskReportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskReportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #taskReportConfig(TaskReportConfig)}.
         * 
         * @param taskReportConfig
         *        a consumer that will call methods on {@link TaskReportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskReportConfig(TaskReportConfig)
         */
        default Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return taskReportConfig(TaskReportConfig.builder().applyMutation(taskReportConfig).build());
        }

        /**
         * <p>
         * The number of files, objects, and directories that DataSync deleted in your destination location. If you
         * don't <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
         * task</a> to delete data in the destination that isn't in the source, the value is always <code>0</code>.
         * </p>
         * 
         * @param filesDeleted
         *        The number of files, objects, and directories that DataSync deleted in your destination location. If
         *        you don't <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
         *        task</a> to delete data in the destination that isn't in the source, the value is always
         *        <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesDeleted(Long filesDeleted);

        /**
         * <p>
         * The number of files, objects, and directories that DataSync skipped during your transfer.
         * </p>
         * 
         * @param filesSkipped
         *        The number of files, objects, and directories that DataSync skipped during your transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesSkipped(Long filesSkipped);

        /**
         * <p>
         * The number of files, objects, and directories that DataSync verified during your transfer.
         * </p>
         * <note>
         * <p>
         * When you configure your task to <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html">verify
         * only the data that's transferred</a>, DataSync doesn't verify directories in some situations or files that
         * fail to transfer.
         * </p>
         * </note>
         * 
         * @param filesVerified
         *        The number of files, objects, and directories that DataSync verified during your transfer.</p> <note>
         *        <p>
         *        When you configure your task to <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html"
         *        >verify only the data that's transferred</a>, DataSync doesn't verify directories in some situations
         *        or files that fail to transfer.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesVerified(Long filesVerified);

        /**
         * <p>
         * Indicates whether DataSync generated a complete <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your
         * transfer.
         * </p>
         * 
         * @param reportResult
         *        Indicates whether DataSync generated a complete <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for
         *        your transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportResult(ReportResult reportResult);

        /**
         * <p>
         * Indicates whether DataSync generated a complete <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your
         * transfer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportResult.Builder} avoiding the need
         * to create one manually via {@link ReportResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportResult.Builder#build()} is called immediately and its
         * result is passed to {@link #reportResult(ReportResult)}.
         * 
         * @param reportResult
         *        a consumer that will call methods on {@link ReportResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportResult(ReportResult)
         */
        default Builder reportResult(Consumer<ReportResult.Builder> reportResult) {
            return reportResult(ReportResult.builder().applyMutation(reportResult).build());
        }

        /**
         * <p>
         * The expected number of files, objects, and directories that DataSync will delete in your destination
         * location. If you don't <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a>
         * to delete data in the destination that isn't in the source, the value is always <code>0</code>.
         * </p>
         * 
         * @param estimatedFilesToDelete
         *        The expected number of files, objects, and directories that DataSync will delete in your destination
         *        location. If you don't <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your
         *        task</a> to delete data in the destination that isn't in the source, the value is always
         *        <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedFilesToDelete(Long estimatedFilesToDelete);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String taskExecutionArn;

        private String status;

        private Options options;

        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Long estimatedFilesToTransfer;

        private Long estimatedBytesToTransfer;

        private Long filesTransferred;

        private Long bytesWritten;

        private Long bytesTransferred;

        private TaskExecutionResultDetail result;

        private Long bytesCompressed;

        private TaskReportConfig taskReportConfig;

        private Long filesDeleted;

        private Long filesSkipped;

        private Long filesVerified;

        private ReportResult reportResult;

        private Long estimatedFilesToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskExecutionResponse model) {
            super(model);
            taskExecutionArn(model.taskExecutionArn);
            status(model.status);
            options(model.options);
            excludes(model.excludes);
            includes(model.includes);
            startTime(model.startTime);
            estimatedFilesToTransfer(model.estimatedFilesToTransfer);
            estimatedBytesToTransfer(model.estimatedBytesToTransfer);
            filesTransferred(model.filesTransferred);
            bytesWritten(model.bytesWritten);
            bytesTransferred(model.bytesTransferred);
            result(model.result);
            bytesCompressed(model.bytesCompressed);
            taskReportConfig(model.taskReportConfig);
            filesDeleted(model.filesDeleted);
            filesSkipped(model.filesSkipped);
            filesVerified(model.filesVerified);
            reportResult(model.reportResult);
            estimatedFilesToDelete(model.estimatedFilesToDelete);
        }

        public final String getTaskExecutionArn() {
            return taskExecutionArn;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEstimatedFilesToTransfer() {
            return estimatedFilesToTransfer;
        }

        public final void setEstimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
        }

        @Override
        public final Builder estimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
            return this;
        }

        public final Long getEstimatedBytesToTransfer() {
            return estimatedBytesToTransfer;
        }

        public final void setEstimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
        }

        @Override
        public final Builder estimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
            return this;
        }

        public final Long getFilesTransferred() {
            return filesTransferred;
        }

        public final void setFilesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
        }

        @Override
        public final Builder filesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
            return this;
        }

        public final Long getBytesWritten() {
            return bytesWritten;
        }

        public final void setBytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        @Override
        public final Builder bytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public final Long getBytesTransferred() {
            return bytesTransferred;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final TaskExecutionResultDetail.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        public final void setResult(TaskExecutionResultDetail.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(TaskExecutionResultDetail result) {
            this.result = result;
            return this;
        }

        public final Long getBytesCompressed() {
            return bytesCompressed;
        }

        public final void setBytesCompressed(Long bytesCompressed) {
            this.bytesCompressed = bytesCompressed;
        }

        @Override
        public final Builder bytesCompressed(Long bytesCompressed) {
            this.bytesCompressed = bytesCompressed;
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return taskReportConfig != null ? taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        public final Long getFilesDeleted() {
            return filesDeleted;
        }

        public final void setFilesDeleted(Long filesDeleted) {
            this.filesDeleted = filesDeleted;
        }

        @Override
        public final Builder filesDeleted(Long filesDeleted) {
            this.filesDeleted = filesDeleted;
            return this;
        }

        public final Long getFilesSkipped() {
            return filesSkipped;
        }

        public final void setFilesSkipped(Long filesSkipped) {
            this.filesSkipped = filesSkipped;
        }

        @Override
        public final Builder filesSkipped(Long filesSkipped) {
            this.filesSkipped = filesSkipped;
            return this;
        }

        public final Long getFilesVerified() {
            return filesVerified;
        }

        public final void setFilesVerified(Long filesVerified) {
            this.filesVerified = filesVerified;
        }

        @Override
        public final Builder filesVerified(Long filesVerified) {
            this.filesVerified = filesVerified;
            return this;
        }

        public final ReportResult.Builder getReportResult() {
            return reportResult != null ? reportResult.toBuilder() : null;
        }

        public final void setReportResult(ReportResult.BuilderImpl reportResult) {
            this.reportResult = reportResult != null ? reportResult.build() : null;
        }

        @Override
        public final Builder reportResult(ReportResult reportResult) {
            this.reportResult = reportResult;
            return this;
        }

        public final Long getEstimatedFilesToDelete() {
            return estimatedFilesToDelete;
        }

        public final void setEstimatedFilesToDelete(Long estimatedFilesToDelete) {
            this.estimatedFilesToDelete = estimatedFilesToDelete;
        }

        @Override
        public final Builder estimatedFilesToDelete(Long estimatedFilesToDelete) {
            this.estimatedFilesToDelete = estimatedFilesToDelete;
            return this;
        }

        @Override
        public DescribeTaskExecutionResponse build() {
            return new DescribeTaskExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
