/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoverySystemType {
    NET_APP_ONTAP("NetAppONTAP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoverySystemType> VALUE_MAP;
    private final String value;

    private DiscoverySystemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoverySystemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoverySystemType> knownValues() {
        EnumSet<DiscoverySystemType> knownValues = EnumSet.allOf(DiscoverySystemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoverySystemType.class, DiscoverySystemType::toString);
    }
}

