/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse;

public class DescribeStorageSystemResourcesPublisher
implements SdkPublisher<DescribeStorageSystemResourcesResponse> {
    private final DataSyncAsyncClient client;
    private final DescribeStorageSystemResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStorageSystemResourcesPublisher(DataSyncAsyncClient client, DescribeStorageSystemResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStorageSystemResourcesPublisher(DataSyncAsyncClient client, DescribeStorageSystemResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStorageSystemResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStorageSystemResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeStorageSystemResourcesResponseFetcher
    implements AsyncPageFetcher<DescribeStorageSystemResourcesResponse> {
        private DescribeStorageSystemResourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStorageSystemResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStorageSystemResourcesResponse> nextPage(DescribeStorageSystemResourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeStorageSystemResourcesPublisher.this.client.describeStorageSystemResources(DescribeStorageSystemResourcesPublisher.this.firstRequest);
            }
            return DescribeStorageSystemResourcesPublisher.this.client.describeStorageSystemResources((DescribeStorageSystemResourcesRequest)((Object)DescribeStorageSystemResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

