/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTaskResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeTaskResponse.Builder, DescribeTaskResponse> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(DescribeTaskResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeTaskResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CURRENT_TASK_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentTaskExecutionArn").getter(getter(DescribeTaskResponse::currentTaskExecutionArn))
            .setter(setter(Builder::currentTaskExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentTaskExecutionArn").build())
            .build();

    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationArn").getter(getter(DescribeTaskResponse::sourceLocationArn))
            .setter(setter(Builder::sourceLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()).build();

    private static final SdkField<String> DESTINATION_LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationLocationArn").getter(getter(DescribeTaskResponse::destinationLocationArn))
            .setter(setter(Builder::destinationLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLocationArn").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(DescribeTaskResponse::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<List<String>> SOURCE_NETWORK_INTERFACE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceNetworkInterfaceArns")
            .getter(getter(DescribeTaskResponse::sourceNetworkInterfaceArns))
            .setter(setter(Builder::sourceNetworkInterfaceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceNetworkInterfaceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESTINATION_NETWORK_INTERFACE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationNetworkInterfaceArns")
            .getter(getter(DescribeTaskResponse::destinationNetworkInterfaceArns))
            .setter(setter(Builder::destinationNetworkInterfaceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationNetworkInterfaceArns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Options> OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(DescribeTaskResponse::options)).setter(setter(Builder::options))
            .constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Excludes")
            .getter(getter(DescribeTaskResponse::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TaskSchedule> SCHEDULE_FIELD = SdkField.<TaskSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(DescribeTaskResponse::schedule)).setter(setter(Builder::schedule))
            .constructor(TaskSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(DescribeTaskResponse::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDetail").getter(getter(DescribeTaskResponse::errorDetail)).setter(setter(Builder::errorDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeTaskResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Includes")
            .getter(getter(DescribeTaskResponse::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ManifestConfig> MANIFEST_CONFIG_FIELD = SdkField
            .<ManifestConfig> builder(MarshallingType.SDK_POJO).memberName("ManifestConfig")
            .getter(getter(DescribeTaskResponse::manifestConfig)).setter(setter(Builder::manifestConfig))
            .constructor(ManifestConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestConfig").build()).build();

    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField
            .<TaskReportConfig> builder(MarshallingType.SDK_POJO).memberName("TaskReportConfig")
            .getter(getter(DescribeTaskResponse::taskReportConfig)).setter(setter(Builder::taskReportConfig))
            .constructor(TaskReportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, STATUS_FIELD,
            NAME_FIELD, CURRENT_TASK_EXECUTION_ARN_FIELD, SOURCE_LOCATION_ARN_FIELD, DESTINATION_LOCATION_ARN_FIELD,
            CLOUD_WATCH_LOG_GROUP_ARN_FIELD, SOURCE_NETWORK_INTERFACE_ARNS_FIELD, DESTINATION_NETWORK_INTERFACE_ARNS_FIELD,
            OPTIONS_FIELD, EXCLUDES_FIELD, SCHEDULE_FIELD, ERROR_CODE_FIELD, ERROR_DETAIL_FIELD, CREATION_TIME_FIELD,
            INCLUDES_FIELD, MANIFEST_CONFIG_FIELD, TASK_REPORT_CONFIG_FIELD));

    private final String taskArn;

    private final String status;

    private final String name;

    private final String currentTaskExecutionArn;

    private final String sourceLocationArn;

    private final String destinationLocationArn;

    private final String cloudWatchLogGroupArn;

    private final List<String> sourceNetworkInterfaceArns;

    private final List<String> destinationNetworkInterfaceArns;

    private final Options options;

    private final List<FilterRule> excludes;

    private final TaskSchedule schedule;

    private final String errorCode;

    private final String errorDetail;

    private final Instant creationTime;

    private final List<FilterRule> includes;

    private final ManifestConfig manifestConfig;

    private final TaskReportConfig taskReportConfig;

    private DescribeTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.status = builder.status;
        this.name = builder.name;
        this.currentTaskExecutionArn = builder.currentTaskExecutionArn;
        this.sourceLocationArn = builder.sourceLocationArn;
        this.destinationLocationArn = builder.destinationLocationArn;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.sourceNetworkInterfaceArns = builder.sourceNetworkInterfaceArns;
        this.destinationNetworkInterfaceArns = builder.destinationNetworkInterfaceArns;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.schedule = builder.schedule;
        this.errorCode = builder.errorCode;
        this.errorDetail = builder.errorDetail;
        this.creationTime = builder.creationTime;
        this.includes = builder.includes;
        this.manifestConfig = builder.manifestConfig;
        this.taskReportConfig = builder.taskReportConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task that was described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task that was described.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The status of the task that was described.
     * </p>
     * <p>
     * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task that was described.</p>
     *         <p>
     *         For detailed information about task execution statuses, see Understanding Task Statuses in the
     *         <i>DataSync User Guide</i>.
     * @see TaskStatus
     */
    public final TaskStatus status() {
        return TaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task that was described.
     * </p>
     * <p>
     * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task that was described.</p>
     *         <p>
     *         For detailed information about task execution statuses, see Understanding Task Statuses in the
     *         <i>DataSync User Guide</i>.
     * @see TaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the task that was described.
     * </p>
     * 
     * @return The name of the task that was described.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution that is transferring files.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution that is transferring files.
     */
    public final String currentTaskExecutionArn() {
        return currentTaskExecutionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source file system's location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source file system's location.
     */
    public final String sourceLocationArn() {
        return sourceLocationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
     */
    public final String destinationLocationArn() {
        return destinationLocationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the
     * task.
     * </p>
     * <p>
     * For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch
     * User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events
     *         in the task.</p>
     *         <p>
     *         For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon
     *         CloudWatch User Guide</i>.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceNetworkInterfaceArns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceNetworkInterfaceArns() {
        return sourceNetworkInterfaceArns != null && !(sourceNetworkInterfaceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
     * >Network interface requirements</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceNetworkInterfaceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
     *         >Network interface requirements</a>.
     */
    public final List<String> sourceNetworkInterfaceArns() {
        return sourceNetworkInterfaceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationNetworkInterfaceArns
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDestinationNetworkInterfaceArns() {
        return destinationNetworkInterfaceArns != null && !(destinationNetworkInterfaceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
     * >Network interface requirements</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationNetworkInterfaceArns}
     * method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
     *         >Network interface requirements</a>.
     */
    public final List<String> destinationNetworkInterfaceArns() {
        return destinationNetworkInterfaceArns;
    }

    /**
     * <p>
     * The configuration options that control the behavior of the <code>StartTaskExecution</code> operation. Some
     * options include preserving file or object metadata and verifying data integrity.
     * </p>
     * <p>
     * You can override these options for each task execution. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.
     * </p>
     * 
     * @return The configuration options that control the behavior of the <code>StartTaskExecution</code> operation.
     *         Some options include preserving file or object metadata and verifying data integrity.</p>
     *         <p>
     *         You can override these options for each task execution. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html"
     *         >StartTaskExecution</a>.
     */
    public final Options options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that exclude specific data during your transfer. For more information and examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred by
     * DataSync</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return A list of filter rules that exclude specific data during your transfer. For more information and
     *         examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
     *         data transferred by DataSync</a>.
     */
    public final List<FilterRule> excludes() {
        return excludes;
    }

    /**
     * <p>
     * The schedule used to periodically transfer files from a source to a destination location.
     * </p>
     * 
     * @return The schedule used to periodically transfer files from a source to a destination location.
     */
    public final TaskSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot
     * issues.
     * </p>
     * 
     * @return Errors that DataSync encountered during execution of the task. You can use this error code to help
     *         troubleshoot issues.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * Detailed description of an error that was encountered during the task execution. You can use this information to
     * help troubleshoot issues.
     * </p>
     * 
     * @return Detailed description of an error that was encountered during the task execution. You can use this
     *         information to help troubleshoot issues.
     */
    public final String errorDetail() {
        return errorDetail;
    }

    /**
     * <p>
     * The time that the task was created.
     * </p>
     * 
     * @return The time that the task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter rules that include specific data during your transfer. For more information and examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred by
     * DataSync</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return A list of filter rules that include specific data during your transfer. For more information and
     *         examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
     *         data transferred by DataSync</a>.
     */
    public final List<FilterRule> includes() {
        return includes;
    }

    /**
     * <p>
     * The configuration of the manifest that lists the files or objects to transfer. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what
     * DataSync transfers by using a manifest</a>.
     * </p>
     * 
     * @return The configuration of the manifest that lists the files or objects to transfer. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying
     *         what DataSync transfers by using a manifest</a>.
     */
    public final ManifestConfig manifestConfig() {
        return manifestConfig;
    }

    /**
     * <p>
     * The configuration of your task report, which provides detailed information about for your DataSync transfer. For
     * more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Creating
     * a task report</a>.
     * </p>
     * 
     * @return The configuration of your task report, which provides detailed information about for your DataSync
     *         transfer. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Creating a task
     *         report</a>.
     */
    public final TaskReportConfig taskReportConfig() {
        return taskReportConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(currentTaskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceNetworkInterfaceArns() ? sourceNetworkInterfaceArns() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDestinationNetworkInterfaceArns() ? destinationNetworkInterfaceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(manifestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(taskReportConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskResponse)) {
            return false;
        }
        DescribeTaskResponse other = (DescribeTaskResponse) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(currentTaskExecutionArn(), other.currentTaskExecutionArn())
                && Objects.equals(sourceLocationArn(), other.sourceLocationArn())
                && Objects.equals(destinationLocationArn(), other.destinationLocationArn())
                && Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn())
                && hasSourceNetworkInterfaceArns() == other.hasSourceNetworkInterfaceArns()
                && Objects.equals(sourceNetworkInterfaceArns(), other.sourceNetworkInterfaceArns())
                && hasDestinationNetworkInterfaceArns() == other.hasDestinationNetworkInterfaceArns()
                && Objects.equals(destinationNetworkInterfaceArns(), other.destinationNetworkInterfaceArns())
                && Objects.equals(options(), other.options()) && hasExcludes() == other.hasExcludes()
                && Objects.equals(excludes(), other.excludes()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorDetail(), other.errorDetail())
                && Objects.equals(creationTime(), other.creationTime()) && hasIncludes() == other.hasIncludes()
                && Objects.equals(includes(), other.includes()) && Objects.equals(manifestConfig(), other.manifestConfig())
                && Objects.equals(taskReportConfig(), other.taskReportConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeTaskResponse")
                .add("TaskArn", taskArn())
                .add("Status", statusAsString())
                .add("Name", name())
                .add("CurrentTaskExecutionArn", currentTaskExecutionArn())
                .add("SourceLocationArn", sourceLocationArn())
                .add("DestinationLocationArn", destinationLocationArn())
                .add("CloudWatchLogGroupArn", cloudWatchLogGroupArn())
                .add("SourceNetworkInterfaceArns", hasSourceNetworkInterfaceArns() ? sourceNetworkInterfaceArns() : null)
                .add("DestinationNetworkInterfaceArns",
                        hasDestinationNetworkInterfaceArns() ? destinationNetworkInterfaceArns() : null)
                .add("Options", options()).add("Excludes", hasExcludes() ? excludes() : null).add("Schedule", schedule())
                .add("ErrorCode", errorCode()).add("ErrorDetail", errorDetail()).add("CreationTime", creationTime())
                .add("Includes", hasIncludes() ? includes() : null).add("ManifestConfig", manifestConfig())
                .add("TaskReportConfig", taskReportConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CurrentTaskExecutionArn":
            return Optional.ofNullable(clazz.cast(currentTaskExecutionArn()));
        case "SourceLocationArn":
            return Optional.ofNullable(clazz.cast(sourceLocationArn()));
        case "DestinationLocationArn":
            return Optional.ofNullable(clazz.cast(destinationLocationArn()));
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "SourceNetworkInterfaceArns":
            return Optional.ofNullable(clazz.cast(sourceNetworkInterfaceArns()));
        case "DestinationNetworkInterfaceArns":
            return Optional.ofNullable(clazz.cast(destinationNetworkInterfaceArns()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "ManifestConfig":
            return Optional.ofNullable(clazz.cast(manifestConfig()));
        case "TaskReportConfig":
            return Optional.ofNullable(clazz.cast(taskReportConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskResponse, T> g) {
        return obj -> g.apply((DescribeTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTaskResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task that was described.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The status of the task that was described.
         * </p>
         * <p>
         * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync
         * User Guide</i>.
         * </p>
         * 
         * @param status
         *        The status of the task that was described.</p>
         *        <p>
         *        For detailed information about task execution statuses, see Understanding Task Statuses in the
         *        <i>DataSync User Guide</i>.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task that was described.
         * </p>
         * <p>
         * For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync
         * User Guide</i>.
         * </p>
         * 
         * @param status
         *        The status of the task that was described.</p>
         *        <p>
         *        For detailed information about task execution statuses, see Understanding Task Statuses in the
         *        <i>DataSync User Guide</i>.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(TaskStatus status);

        /**
         * <p>
         * The name of the task that was described.
         * </p>
         * 
         * @param name
         *        The name of the task that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution that is transferring files.
         * </p>
         * 
         * @param currentTaskExecutionArn
         *        The Amazon Resource Name (ARN) of the task execution that is transferring files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentTaskExecutionArn(String currentTaskExecutionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source file system's location.
         * </p>
         * 
         * @param sourceLocationArn
         *        The Amazon Resource Name (ARN) of the source file system's location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationArn(String sourceLocationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
         * </p>
         * 
         * @param destinationLocationArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationLocationArn(String destinationLocationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in
         * the task.
         * </p>
         * <p>
         * For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch
         * User Guide</i>.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log
         *        events in the task.</p>
         *        <p>
         *        For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon
         *        CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         * >Network interface requirements</a>.
         * </p>
         * 
         * @param sourceNetworkInterfaceArns
         *        The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         *        >Network interface requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkInterfaceArns(Collection<String> sourceNetworkInterfaceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         * >Network interface requirements</a>.
         * </p>
         * 
         * @param sourceNetworkInterfaceArns
         *        The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         *        >Network interface requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkInterfaceArns(String... sourceNetworkInterfaceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         * >Network interface requirements</a>.
         * </p>
         * 
         * @param destinationNetworkInterfaceArns
         *        The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         *        >Network interface requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationNetworkInterfaceArns(Collection<String> destinationNetworkInterfaceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         * >Network interface requirements</a>.
         * </p>
         * 
         * @param destinationNetworkInterfaceArns
         *        The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces"
         *        >Network interface requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationNetworkInterfaceArns(String... destinationNetworkInterfaceArns);

        /**
         * <p>
         * The configuration options that control the behavior of the <code>StartTaskExecution</code> operation. Some
         * options include preserving file or object metadata and verifying data integrity.
         * </p>
         * <p>
         * You can override these options for each task execution. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html"
         * >StartTaskExecution</a>.
         * </p>
         * 
         * @param options
         *        The configuration options that control the behavior of the <code>StartTaskExecution</code> operation.
         *        Some options include preserving file or object metadata and verifying data integrity.</p>
         *        <p>
         *        You can override these options for each task execution. For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html"
         *        >StartTaskExecution</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Options options);

        /**
         * <p>
         * The configuration options that control the behavior of the <code>StartTaskExecution</code> operation. Some
         * options include preserving file or object metadata and verifying data integrity.
         * </p>
         * <p>
         * You can override these options for each task execution. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html"
         * >StartTaskExecution</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Options.Builder} avoiding the need to
         * create one manually via {@link Options#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #options(Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Options)
         */
        default Builder options(Consumer<Options.Builder> options) {
            return options(Options.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * A list of filter rules that exclude specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that exclude specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<FilterRule> excludes);

        /**
         * <p>
         * A list of filter rules that exclude specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param excludes
         *        A list of filter rules that exclude specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(FilterRule... excludes);

        /**
         * <p>
         * A list of filter rules that exclude specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #excludes(List<FilterRule>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(java.util.Collection<FilterRule>)
         */
        Builder excludes(Consumer<FilterRule.Builder>... excludes);

        /**
         * <p>
         * The schedule used to periodically transfer files from a source to a destination location.
         * </p>
         * 
         * @param schedule
         *        The schedule used to periodically transfer files from a source to a destination location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(TaskSchedule schedule);

        /**
         * <p>
         * The schedule used to periodically transfer files from a source to a destination location.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskSchedule.Builder} avoiding the need
         * to create one manually via {@link TaskSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(TaskSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link TaskSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(TaskSchedule)
         */
        default Builder schedule(Consumer<TaskSchedule.Builder> schedule) {
            return schedule(TaskSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * Errors that DataSync encountered during execution of the task. You can use this error code to help
         * troubleshoot issues.
         * </p>
         * 
         * @param errorCode
         *        Errors that DataSync encountered during execution of the task. You can use this error code to help
         *        troubleshoot issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Detailed description of an error that was encountered during the task execution. You can use this information
         * to help troubleshoot issues.
         * </p>
         * 
         * @param errorDetail
         *        Detailed description of an error that was encountered during the task execution. You can use this
         *        information to help troubleshoot issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(String errorDetail);

        /**
         * <p>
         * The time that the task was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A list of filter rules that include specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param includes
         *        A list of filter rules that include specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * A list of filter rules that include specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * 
         * @param includes
         *        A list of filter rules that include specific data during your transfer. For more information and
         *        examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering
         *        data transferred by DataSync</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * A list of filter rules that include specific data during your transfer. For more information and examples,
         * see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred
         * by DataSync</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(java.util.Collection<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        /**
         * <p>
         * The configuration of the manifest that lists the files or objects to transfer. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what
         * DataSync transfers by using a manifest</a>.
         * </p>
         * 
         * @param manifestConfig
         *        The configuration of the manifest that lists the files or objects to transfer. For more information,
         *        see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">
         *        Specifying what DataSync transfers by using a manifest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestConfig(ManifestConfig manifestConfig);

        /**
         * <p>
         * The configuration of the manifest that lists the files or objects to transfer. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what
         * DataSync transfers by using a manifest</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestConfig.Builder} avoiding the need
         * to create one manually via {@link ManifestConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #manifestConfig(ManifestConfig)}.
         * 
         * @param manifestConfig
         *        a consumer that will call methods on {@link ManifestConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestConfig(ManifestConfig)
         */
        default Builder manifestConfig(Consumer<ManifestConfig.Builder> manifestConfig) {
            return manifestConfig(ManifestConfig.builder().applyMutation(manifestConfig).build());
        }

        /**
         * <p>
         * The configuration of your task report, which provides detailed information about for your DataSync transfer.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Creating a task report</a>.
         * </p>
         * 
         * @param taskReportConfig
         *        The configuration of your task report, which provides detailed information about for your DataSync
         *        transfer. For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Creating a task
         *        report</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskReportConfig(TaskReportConfig taskReportConfig);

        /**
         * <p>
         * The configuration of your task report, which provides detailed information about for your DataSync transfer.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Creating a task report</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskReportConfig.Builder} avoiding the
         * need to create one manually via {@link TaskReportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskReportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #taskReportConfig(TaskReportConfig)}.
         * 
         * @param taskReportConfig
         *        a consumer that will call methods on {@link TaskReportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskReportConfig(TaskReportConfig)
         */
        default Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return taskReportConfig(TaskReportConfig.builder().applyMutation(taskReportConfig).build());
        }
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String taskArn;

        private String status;

        private String name;

        private String currentTaskExecutionArn;

        private String sourceLocationArn;

        private String destinationLocationArn;

        private String cloudWatchLogGroupArn;

        private List<String> sourceNetworkInterfaceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinationNetworkInterfaceArns = DefaultSdkAutoConstructList.getInstance();

        private Options options;

        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();

        private TaskSchedule schedule;

        private String errorCode;

        private String errorDetail;

        private Instant creationTime;

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private ManifestConfig manifestConfig;

        private TaskReportConfig taskReportConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskResponse model) {
            super(model);
            taskArn(model.taskArn);
            status(model.status);
            name(model.name);
            currentTaskExecutionArn(model.currentTaskExecutionArn);
            sourceLocationArn(model.sourceLocationArn);
            destinationLocationArn(model.destinationLocationArn);
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            sourceNetworkInterfaceArns(model.sourceNetworkInterfaceArns);
            destinationNetworkInterfaceArns(model.destinationNetworkInterfaceArns);
            options(model.options);
            excludes(model.excludes);
            schedule(model.schedule);
            errorCode(model.errorCode);
            errorDetail(model.errorDetail);
            creationTime(model.creationTime);
            includes(model.includes);
            manifestConfig(model.manifestConfig);
            taskReportConfig(model.taskReportConfig);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCurrentTaskExecutionArn() {
            return currentTaskExecutionArn;
        }

        public final void setCurrentTaskExecutionArn(String currentTaskExecutionArn) {
            this.currentTaskExecutionArn = currentTaskExecutionArn;
        }

        @Override
        public final Builder currentTaskExecutionArn(String currentTaskExecutionArn) {
            this.currentTaskExecutionArn = currentTaskExecutionArn;
            return this;
        }

        public final String getSourceLocationArn() {
            return sourceLocationArn;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final String getDestinationLocationArn() {
            return destinationLocationArn;
        }

        public final void setDestinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
        }

        @Override
        public final Builder destinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final Collection<String> getSourceNetworkInterfaceArns() {
            if (sourceNetworkInterfaceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceNetworkInterfaceArns;
        }

        public final void setSourceNetworkInterfaceArns(Collection<String> sourceNetworkInterfaceArns) {
            this.sourceNetworkInterfaceArns = SourceNetworkInterfaceArnsCopier.copy(sourceNetworkInterfaceArns);
        }

        @Override
        public final Builder sourceNetworkInterfaceArns(Collection<String> sourceNetworkInterfaceArns) {
            this.sourceNetworkInterfaceArns = SourceNetworkInterfaceArnsCopier.copy(sourceNetworkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworkInterfaceArns(String... sourceNetworkInterfaceArns) {
            sourceNetworkInterfaceArns(Arrays.asList(sourceNetworkInterfaceArns));
            return this;
        }

        public final Collection<String> getDestinationNetworkInterfaceArns() {
            if (destinationNetworkInterfaceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationNetworkInterfaceArns;
        }

        public final void setDestinationNetworkInterfaceArns(Collection<String> destinationNetworkInterfaceArns) {
            this.destinationNetworkInterfaceArns = DestinationNetworkInterfaceArnsCopier.copy(destinationNetworkInterfaceArns);
        }

        @Override
        public final Builder destinationNetworkInterfaceArns(Collection<String> destinationNetworkInterfaceArns) {
            this.destinationNetworkInterfaceArns = DestinationNetworkInterfaceArnsCopier.copy(destinationNetworkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationNetworkInterfaceArns(String... destinationNetworkInterfaceArns) {
            destinationNetworkInterfaceArns(Arrays.asList(destinationNetworkInterfaceArns));
            return this;
        }

        public final Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TaskSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(TaskSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(TaskSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorDetail() {
            return errorDetail;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManifestConfig.Builder getManifestConfig() {
            return manifestConfig != null ? manifestConfig.toBuilder() : null;
        }

        public final void setManifestConfig(ManifestConfig.BuilderImpl manifestConfig) {
            this.manifestConfig = manifestConfig != null ? manifestConfig.build() : null;
        }

        @Override
        public final Builder manifestConfig(ManifestConfig manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return taskReportConfig != null ? taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        @Override
        public DescribeTaskResponse build() {
            return new DescribeTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
