/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information
 * and configuration examples, see <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync
 * transfers by using a manifest</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManifestConfig implements SdkPojo, Serializable, ToCopyableBuilder<ManifestConfig.Builder, ManifestConfig> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ManifestConfig::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(ManifestConfig::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<SourceManifestConfig> SOURCE_FIELD = SdkField
            .<SourceManifestConfig> builder(MarshallingType.SDK_POJO).memberName("Source").getter(getter(ManifestConfig::source))
            .setter(setter(Builder::source)).constructor(SourceManifestConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, FORMAT_FIELD,
            SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String format;

    private final SourceManifestConfig source;

    private ManifestConfig(BuilderImpl builder) {
        this.action = builder.action;
        this.format = builder.format;
        this.source = builder.source;
    }

    /**
     * <p>
     * Specifies what DataSync uses the manifest for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ManifestAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies what DataSync uses the manifest for.
     * @see ManifestAction
     */
    public final ManifestAction action() {
        return ManifestAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies what DataSync uses the manifest for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ManifestAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies what DataSync uses the manifest for.
     * @see ManifestAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies the file format of your manifest. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
     * >Creating a manifest</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ManifestFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the file format of your manifest. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
     *         >Creating a manifest</a>.
     * @see ManifestFormat
     */
    public final ManifestFormat format() {
        return ManifestFormat.fromValue(format);
    }

    /**
     * <p>
     * Specifies the file format of your manifest. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
     * >Creating a manifest</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ManifestFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the file format of your manifest. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
     *         >Creating a manifest</a>.
     * @see ManifestFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * Specifies the manifest that you want DataSync to use and where it's hosted.
     * </p>
     * <note>
     * <p>
     * You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
     * </p>
     * <p>
     * If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're missing
     * the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
     * >Providing DataSync access to your manifest</a>.
     * </p>
     * </note>
     * 
     * @return Specifies the manifest that you want DataSync to use and where it's hosted.</p> <note>
     *         <p>
     *         You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
     *         </p>
     *         <p>
     *         If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're
     *         missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
     *         >Providing DataSync access to your manifest</a>.
     *         </p>
     */
    public final SourceManifestConfig source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestConfig)) {
            return false;
        }
        ManifestConfig other = (ManifestConfig) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManifestConfig").add("Action", actionAsString()).add("Format", formatAsString())
                .add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManifestConfig, T> g) {
        return obj -> g.apply((ManifestConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManifestConfig> {
        /**
         * <p>
         * Specifies what DataSync uses the manifest for.
         * </p>
         * 
         * @param action
         *        Specifies what DataSync uses the manifest for.
         * @see ManifestAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies what DataSync uses the manifest for.
         * </p>
         * 
         * @param action
         *        Specifies what DataSync uses the manifest for.
         * @see ManifestAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestAction
         */
        Builder action(ManifestAction action);

        /**
         * <p>
         * Specifies the file format of your manifest. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
         * >Creating a manifest</a>.
         * </p>
         * 
         * @param format
         *        Specifies the file format of your manifest. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
         *        >Creating a manifest</a>.
         * @see ManifestFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestFormat
         */
        Builder format(String format);

        /**
         * <p>
         * Specifies the file format of your manifest. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
         * >Creating a manifest</a>.
         * </p>
         * 
         * @param format
         *        Specifies the file format of your manifest. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create"
         *        >Creating a manifest</a>.
         * @see ManifestFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestFormat
         */
        Builder format(ManifestFormat format);

        /**
         * <p>
         * Specifies the manifest that you want DataSync to use and where it's hosted.
         * </p>
         * <note>
         * <p>
         * You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
         * </p>
         * <p>
         * If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're
         * missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
         * >Providing DataSync access to your manifest</a>.
         * </p>
         * </note>
         * 
         * @param source
         *        Specifies the manifest that you want DataSync to use and where it's hosted.</p> <note>
         *        <p>
         *        You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
         *        </p>
         *        <p>
         *        If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that
         *        you're missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
         *        >Providing DataSync access to your manifest</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(SourceManifestConfig source);

        /**
         * <p>
         * Specifies the manifest that you want DataSync to use and where it's hosted.
         * </p>
         * <note>
         * <p>
         * You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
         * </p>
         * <p>
         * If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're
         * missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
         * >Providing DataSync access to your manifest</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link SourceManifestConfig.Builder}
         * avoiding the need to create one manually via {@link SourceManifestConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceManifestConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #source(SourceManifestConfig)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link SourceManifestConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(SourceManifestConfig)
         */
        default Builder source(Consumer<SourceManifestConfig.Builder> source) {
            return source(SourceManifestConfig.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String format;

        private SourceManifestConfig source;

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestConfig model) {
            action(model.action);
            format(model.format);
            source(model.source);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ManifestAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ManifestFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final SourceManifestConfig.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(SourceManifestConfig.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(SourceManifestConfig source) {
            this.source = source;
            return this;
        }

        @Override
        public ManifestConfig build() {
            return new ManifestConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
