/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures your DataSync task to run on a <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">schedule</a> (at a minimum interval
 * of 1 hour).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskSchedule implements SdkPojo, Serializable, ToCopyableBuilder<TaskSchedule.Builder, TaskSchedule> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(TaskSchedule::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TaskSchedule::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private final String status;

    private TaskSchedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies your task schedule by using a cron expression in UTC time. For information about cron expression
     * syntax, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html">
     * <i>Amazon EventBridge User Guide</i> </a>.
     * </p>
     * 
     * @return Specifies your task schedule by using a cron expression in UTC time. For information about cron
     *         expression syntax, see the <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html"> <i>Amazon
     *         EventBridge User Guide</i> </a>.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can be
     * situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an
     * issue with your task or perform maintenance on your storage system.
     * </p>
     * <p>
     * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html">TaskScheduleDetails
     * </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there
     *         can be situations where you need to disable it. For example, you might need to pause a recurring transfer
     *         to fix an issue with your task or perform maintenance on your storage system.</p>
     *         <p>
     *         DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html"
     *         >TaskScheduleDetails</a>.
     * @see ScheduleStatus
     */
    public final ScheduleStatus status() {
        return ScheduleStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can be
     * situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an
     * issue with your task or perform maintenance on your storage system.
     * </p>
     * <p>
     * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html">TaskScheduleDetails
     * </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there
     *         can be situations where you need to disable it. For example, you might need to pause a recurring transfer
     *         to fix an issue with your task or perform maintenance on your storage system.</p>
     *         <p>
     *         DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html"
     *         >TaskScheduleDetails</a>.
     * @see ScheduleStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSchedule)) {
            return false;
        }
        TaskSchedule other = (TaskSchedule) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskSchedule").add("ScheduleExpression", scheduleExpression()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskSchedule, T> g) {
        return obj -> g.apply((TaskSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskSchedule> {
        /**
         * <p>
         * Specifies your task schedule by using a cron expression in UTC time. For information about cron expression
         * syntax, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html">
         * <i>Amazon EventBridge User Guide</i> </a>.
         * </p>
         * 
         * @param scheduleExpression
         *        Specifies your task schedule by using a cron expression in UTC time. For information about cron
         *        expression syntax, see the <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html"> <i>Amazon
         *        EventBridge User Guide</i> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can
         * be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix
         * an issue with your task or perform maintenance on your storage system.
         * </p>
         * <p>
         * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html"
         * >TaskScheduleDetails</a>.
         * </p>
         * 
         * @param status
         *        Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but
         *        there can be situations where you need to disable it. For example, you might need to pause a recurring
         *        transfer to fix an issue with your task or perform maintenance on your storage system.</p>
         *        <p>
         *        DataSync might disable your schedule automatically if your task fails repeatedly with the same error.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html"
         *        >TaskScheduleDetails</a>.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can
         * be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix
         * an issue with your task or perform maintenance on your storage system.
         * </p>
         * <p>
         * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html"
         * >TaskScheduleDetails</a>.
         * </p>
         * 
         * @param status
         *        Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but
         *        there can be situations where you need to disable it. For example, you might need to pause a recurring
         *        transfer to fix an issue with your task or perform maintenance on your storage system.</p>
         *        <p>
         *        DataSync might disable your schedule automatically if your task fails repeatedly with the same error.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html"
         *        >TaskScheduleDetails</a>.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder status(ScheduleStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSchedule model) {
            scheduleExpression(model.scheduleExpression);
            status(model.status);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScheduleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public TaskSchedule build() {
            return new TaskSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
