/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoveryJobStatus {
    RUNNING("RUNNING"),
    WARNING("WARNING"),
    TERMINATED("TERMINATED"),
    FAILED("FAILED"),
    STOPPED("STOPPED"),
    COMPLETED("COMPLETED"),
    COMPLETED_WITH_ISSUES("COMPLETED_WITH_ISSUES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoveryJobStatus> VALUE_MAP;
    private final String value;

    private DiscoveryJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoveryJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoveryJobStatus> knownValues() {
        EnumSet<DiscoveryJobStatus> knownValues = EnumSet.allOf(DiscoveryJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoveryJobStatus.class, DiscoveryJobStatus::toString);
    }
}

