/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the level of detail for a particular aspect of your DataSync <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportOverride implements SdkPojo, Serializable, ToCopyableBuilder<ReportOverride.Builder, ReportOverride> {
    private static final SdkField<String> REPORT_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportLevel").getter(getter(ReportOverride::reportLevelAsString)).setter(setter(Builder::reportLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportLevel;

    private ReportOverride(BuilderImpl builder) {
        this.reportLevel = builder.reportLevel;
    }

    /**
     * <p>
     * Specifies whether your task report includes errors only or successes and errors.
     * </p>
     * <p>
     * For example, your report might mostly include only what didn't go well in your transfer (<code>ERRORS_ONLY</code>
     * ). At the same time, you want to verify that your <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working correctly.
     * In this situation, you can get a list of what files DataSync successfully skipped and if something transferred
     * that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportLevel} will
     * return {@link ReportLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportLevelAsString}.
     * </p>
     * 
     * @return Specifies whether your task report includes errors only or successes and errors.</p>
     *         <p>
     *         For example, your report might mostly include only what didn't go well in your transfer (
     *         <code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working
     *         correctly. In this situation, you can get a list of what files DataSync successfully skipped and if
     *         something transferred that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
     * @see ReportLevel
     */
    public final ReportLevel reportLevel() {
        return ReportLevel.fromValue(reportLevel);
    }

    /**
     * <p>
     * Specifies whether your task report includes errors only or successes and errors.
     * </p>
     * <p>
     * For example, your report might mostly include only what didn't go well in your transfer (<code>ERRORS_ONLY</code>
     * ). At the same time, you want to verify that your <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working correctly.
     * In this situation, you can get a list of what files DataSync successfully skipped and if something transferred
     * that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportLevel} will
     * return {@link ReportLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportLevelAsString}.
     * </p>
     * 
     * @return Specifies whether your task report includes errors only or successes and errors.</p>
     *         <p>
     *         For example, your report might mostly include only what didn't go well in your transfer (
     *         <code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working
     *         correctly. In this situation, you can get a list of what files DataSync successfully skipped and if
     *         something transferred that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
     * @see ReportLevel
     */
    public final String reportLevelAsString() {
        return reportLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportOverride)) {
            return false;
        }
        ReportOverride other = (ReportOverride) obj;
        return Objects.equals(reportLevelAsString(), other.reportLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportOverride").add("ReportLevel", reportLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportLevel":
            return Optional.ofNullable(clazz.cast(reportLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportOverride, T> g) {
        return obj -> g.apply((ReportOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportOverride> {
        /**
         * <p>
         * Specifies whether your task report includes errors only or successes and errors.
         * </p>
         * <p>
         * For example, your report might mostly include only what didn't go well in your transfer (
         * <code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working
         * correctly. In this situation, you can get a list of what files DataSync successfully skipped and if something
         * transferred that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
         * </p>
         * 
         * @param reportLevel
         *        Specifies whether your task report includes errors only or successes and errors.</p>
         *        <p>
         *        For example, your report might mostly include only what didn't go well in your transfer (
         *        <code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working
         *        correctly. In this situation, you can get a list of what files DataSync successfully skipped and if
         *        something transferred that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
         * @see ReportLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportLevel
         */
        Builder reportLevel(String reportLevel);

        /**
         * <p>
         * Specifies whether your task report includes errors only or successes and errors.
         * </p>
         * <p>
         * For example, your report might mostly include only what didn't go well in your transfer (
         * <code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working
         * correctly. In this situation, you can get a list of what files DataSync successfully skipped and if something
         * transferred that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
         * </p>
         * 
         * @param reportLevel
         *        Specifies whether your task report includes errors only or successes and errors.</p>
         *        <p>
         *        For example, your report might mostly include only what didn't go well in your transfer (
         *        <code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working
         *        correctly. In this situation, you can get a list of what files DataSync successfully skipped and if
         *        something transferred that you didn't to transfer (<code>SUCCESSES_AND_ERRORS</code>).
         * @see ReportLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportLevel
         */
        Builder reportLevel(ReportLevel reportLevel);
    }

    static final class BuilderImpl implements Builder {
        private String reportLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportOverride model) {
            reportLevel(model.reportLevel);
        }

        public final String getReportLevel() {
            return reportLevel;
        }

        public final void setReportLevel(String reportLevel) {
            this.reportLevel = reportLevel;
        }

        @Override
        public final Builder reportLevel(String reportLevel) {
            this.reportLevel = reportLevel;
            return this;
        }

        @Override
        public final Builder reportLevel(ReportLevel reportLevel) {
            this.reportLevel(reportLevel == null ? null : reportLevel.toString());
            return this;
        }

        @Override
        public ReportOverride build() {
            return new ReportOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
